/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import echopointng.TabbedPane;
import echopointng.tabbedpane.TabModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.version.Version;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.PracticeMailContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailDialog;
import org.openvpms.web.component.mail.MailEditor;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.factory.TabbedPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.tabpane.TabPaneModel;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.diagnostics.CacheViewer;
import org.openvpms.web.workspace.admin.system.diagnostics.DatabaseProcessViewer;
import org.openvpms.web.workspace.admin.system.diagnostics.DiagnosticTab;
import org.openvpms.web.workspace.admin.system.diagnostics.InnoDBStatusViewer;
import org.openvpms.web.workspace.admin.system.diagnostics.LogViewer;
import org.openvpms.web.workspace.admin.system.diagnostics.MemoryViewer;
import org.openvpms.web.workspace.admin.system.diagnostics.OpenOfficeViewer;
import org.openvpms.web.workspace.admin.system.diagnostics.PluginViewer;
import org.openvpms.web.workspace.admin.system.diagnostics.PropertiesViewer;
import org.openvpms.web.workspace.admin.system.diagnostics.ThreadViewer;
import org.openvpms.web.workspace.admin.system.diagnostics.logging.LoggingConfig;
import org.openvpms.web.workspace.admin.system.diagnostics.logging.LoggingDialog;
import org.openvpms.web.workspace.admin.system.settings.OpenOfficeSettings;

public class DiagnosticsDialog
extends ModalDialog {
    private final Context context;
    private final HelpContext help;
    private final List<DiagnosticTab> tabs = new ArrayList<DiagnosticTab>();
    private final Button logging;
    private final Button log4j;
    private final TabbedPane pane;
    private final Component container;
    private static final String REFRESH_ID = "button.refresh";
    private static final String LOGGING_ID = "button.logging";
    private static final String RELOAD_LOG4J = "button.reloadlog4j";

    public DiagnosticsDialog(Context context, HelpContext help) {
        super(Messages.get((String)"admin.system.diagnostic.title"), "BrowserDialog", OK, help);
        this.context = context;
        this.help = help;
        this.container = SplitPaneFactory.create((int)5, (String)"TabbedBrowser", (Component[])new Component[0]);
        Column tabContainer = ColumnFactory.create((String)"InsetY");
        this.tabs.addAll(Arrays.asList(new MemoryViewer(), new CacheViewer(), new PropertiesViewer(), new ThreadViewer(), new DatabaseProcessViewer(), new InnoDBStatusViewer(), new PluginViewer()));
        if (OpenOfficeSettings.isAvailable()) {
            this.tabs.add(new OpenOfficeViewer());
        }
        this.tabs.add(new LogViewer());
        TabPaneModel model = new TabPaneModel((Component)tabContainer);
        for (DiagnosticTab tab : this.tabs) {
            model.addTab(tab.getName(), (Component)new Label());
        }
        this.pane = TabbedPaneFactory.create((TabModel)model);
        ButtonSet buttons = this.getButtons();
        buttons.add(REFRESH_ID, this::onRefresh);
        buttons.add("button.mail", this::onMail);
        this.logging = buttons.add(LOGGING_ID, this::onLogging);
        this.log4j = buttons.add(RELOAD_LOG4J, this::onReloadLog);
        this.pane.getSelectionModel().addChangeListener((ChangeListener)new org.openvpms.web.echo.event.ChangeListener(){

            public void onChange(ChangeEvent event) {
                DiagnosticsDialog.this.onTabSelected(DiagnosticsDialog.this.pane.getSelectedIndex());
            }
        });
    }

    protected void doLayout() {
        this.container.add((Component)ColumnFactory.create((String)"InsetY", (Component[])new Component[]{this.pane}));
        this.getLayout().add(this.container);
        this.onTabSelected(0);
    }

    private void onTabSelected(int index) {
        if (this.container.getComponentCount() == 2) {
            this.container.remove(1);
        }
        if (index >= 0 && index < this.tabs.size()) {
            DiagnosticTab tab = this.tabs.get(index);
            this.container.add(tab.getComponent());
            boolean loggingTab = tab instanceof LogViewer;
            this.logging.setVisible(loggingTab);
            this.log4j.setVisible(loggingTab);
        }
    }

    private void onRefresh() {
        int index = this.pane.getSelectedIndex();
        if (index >= 0 && index < this.tabs.size()) {
            this.tabs.get(index).refresh();
            this.onTabSelected(index);
        }
    }

    private void onMail() {
        ConfirmationDialog.show((String)Messages.get((String)"admin.system.diagnostic.mail.title"), (String)Messages.get((String)"admin.system.diagnostic.mail.message"), (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

            public void onYes() {
                DiagnosticsDialog.this.onMail(true);
            }

            public void onNo() {
                DiagnosticsDialog.this.onMail(false);
            }
        });
    }

    private void onMail(boolean includeLogs) {
        MailDialog dialog = new MailDialog((MailContext)new PracticeMailContext(this.context), null, (LayoutContext)new DefaultLayoutContext(this.context, this.help));
        MailEditor editor = dialog.getMailEditor();
        editor.setSubject("Diagnostics for OpenVPMS " + Version.VERSION + "(" + Version.REVISION + ")");
        dialog.show();
        for (DiagnosticTab tab : this.tabs) {
            if (tab instanceof LogViewer) {
                if (!includeLogs) continue;
                LogViewer viewer = (LogViewer)tab;
                for (String file : viewer.getFiles()) {
                    Document document = viewer.getDocument(file);
                    if (document == null) continue;
                    editor.addAttachment((org.openvpms.component.model.document.Document)document);
                }
                continue;
            }
            Document document = tab.getDocument();
            if (document == null) continue;
            editor.addAttachment((org.openvpms.component.model.document.Document)document);
        }
    }

    private void onLogging() {
        LoggingDialog dialog = new LoggingDialog();
        dialog.show();
    }

    private void onReloadLog() {
        ((LoggingConfig)ServiceHelper.getBean(LoggingConfig.class)).reset();
        InformationDialog.show((String)Messages.get((String)"admin.system.diagnostic.reloadlog4j"));
    }
}

