/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import java.io.Serializable;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.table.DefaultTableModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.app.table.TableModel;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.table.DefaultTableHeaderRenderer;
import org.openvpms.web.echo.table.KeyTable;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.workspace.admin.system.cache.CacheState;
import org.openvpms.web.workspace.admin.system.cache.Caches;
import org.openvpms.web.workspace.admin.system.diagnostics.AbstractDiagnosticTab;

class CacheViewer
extends AbstractDiagnosticTab {
    private final Caches caches = new Caches();
    private final String[] columns = new String[]{Messages.get((String)"table.imobject.name"), Messages.get((String)"admin.system.cache.count"), Messages.get((String)"admin.system.cache.maxcount"), Messages.get((String)"admin.system.cache.edit.suggested"), Messages.get((String)"admin.system.cache.use"), Messages.get((String)"admin.system.cache.hits"), Messages.get((String)"admin.system.cache.misses"), Messages.get((String)"admin.system.cache.size")};
    private String[][] snapshot;
    private KeyTable table;

    CacheViewer() {
        super("admin.system.diagnostic.cache");
    }

    @Override
    public Document getDocument() {
        Document result = null;
        String[][] data = this.getData(false, false);
        if (data != null) {
            result = this.toCSV("caches.csv", this.columns, data);
        }
        return result;
    }

    @Override
    protected Component getContent() {
        Row result = null;
        String[][] data = this.getData(true, false);
        if (data != null) {
            this.table = new KeyTable();
            this.table.setStyleName("default");
            this.table.setDefaultHeaderRenderer(DefaultTableHeaderRenderer.DEFAULT);
            this.table.setHeaderFixed(true);
            this.populateTable(data);
            Button calculate = ButtonFactory.create((String)"button.calculatesize", this::calculateSize);
            calculate.setLayoutData((LayoutData)RowFactory.layout((Alignment)Alignment.ALIGN_TOP));
            result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{this.table, calculate});
        }
        return result;
    }

    private void populateTable(String[][] data) {
        this.table.setModel((TableModel)new DefaultTableModel((Object[][])data, (Object[])this.columns));
        TableCellRenderer & Serializable align = (TableCellRenderer & Serializable)(t, object, column, row) -> {
            String s;
            String string = s = object != null ? object.toString() : null;
            if (s != null) {
                if ("-".equals(s)) {
                    return TableHelper.centreAlign((String)s);
                }
                return TableHelper.rightAlign((String)s);
            }
            return new Label();
        };
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 1; i < this.columns.length; ++i) {
            columnModel.getColumn(i).setCellRenderer((TableCellRenderer)align);
        }
    }

    private void calculateSize() {
        String[][] data = this.getData(true, true);
        if (data != null) {
            this.populateTable(data);
        }
    }

    private String[][] getData(boolean refresh, boolean calculate) {
        if (this.snapshot == null || refresh) {
            List<CacheState> states = this.caches.getCaches();
            this.snapshot = new String[states.size()][];
            for (int i = 0; i < this.snapshot.length; ++i) {
                CacheState state = states.get(i);
                if (refresh) {
                    state.refreshStatistics();
                }
                if (calculate) {
                    state.refreshCacheSize();
                }
                String size = state.getSize() != -1L ? NumberFormatter.getSize((long)state.getSize()) : "-";
                String[] data = new String[]{state.getDisplayName(), Long.toString(state.getCount()), Long.toString(state.getMaxCount()), Long.toString(this.caches.getSuggestedSize(state)), state.getUse() + "%", Long.toString(state.getHits()), Long.toString(state.getMisses()), size};
                this.snapshot[i] = data;
            }
        }
        return this.snapshot;
    }
}

