/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.query.FilteredResultSet;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.servlet.SessionMonitor;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.AbstractTabComponent;
import org.openvpms.web.workspace.admin.system.cache.CacheDialog;
import org.openvpms.web.workspace.admin.system.diagnostics.DiagnosticsDialog;
import org.openvpms.web.workspace.admin.system.settings.SettingsDialog;
import org.openvpms.web.workspace.admin.system.smartflow.SmartFlowSheetAdminDialog;

public class SessionBrowser
extends AbstractTabComponent {
    private final Context context;
    private final SimpleProperty search = new SimpleProperty("search", null, String.class, Messages.get((String)"query.search"));
    private final SessionMonitor sessionMonitor;
    private Component component;
    private PagedIMTable<SessionMonitor.Session> sessions;
    private TextField field;
    private static final String QUERY_ID = "button.query";
    private static final String CACHES_ID = "button.caches";
    private static final String DIAGNOSTIC_ID = "button.diagnostic";
    private static final String SFS_ID = "button.smartflowsheet";
    private static final String SETTINGS_ID = "button.settings";
    private static final String TERMINATE_SESSION_ID = "button.terminateSession";

    SessionBrowser(Context context, HelpContext help) {
        super(help);
        this.context = context;
        this.sessionMonitor = (SessionMonitor)ServiceHelper.getBean(SessionMonitor.class);
    }

    public void show() {
        this.refresh();
        FocusHelper.setFocus((Component)this.field);
    }

    public Component getComponent() {
        if (this.component == null) {
            FocusGroup focus = this.getFocusGroup();
            this.field = BoundTextComponentFactory.create((Property)this.search, (int)20);
            this.field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    SessionBrowser.this.refresh();
                }
            });
            focus.add((Component)this.field);
            ButtonRow buttons = new ButtonRow();
            buttons.addButton(QUERY_ID, this::onQuery);
            this.sessions = new PagedIMTable((IMTableModel)new SessionTableModel());
            this.sessions.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    SessionBrowser.this.enableTerminateSession();
                }
            });
            Label label = LabelFactory.create();
            label.setText(this.search.getDisplayName());
            Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{label, this.field, buttons});
            Column column = ColumnFactory.create((String)"Inset", (Component[])new Component[]{ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{row, this.sessions.getComponent()})});
            focus.add(this.sessions.getComponent());
            ButtonSet buttonSet = this.getButtonSet();
            buttonSet.add(SETTINGS_ID, this::onSettings);
            buttonSet.add(SFS_ID, this::onSmartFlowSheet);
            buttonSet.add(CACHES_ID, this::onCaches);
            buttonSet.add(DIAGNOSTIC_ID, this::onDiagnostics);
            buttonSet.add(TERMINATE_SESSION_ID, this::onTerminateSession);
            buttonSet.setEnabled(TERMINATE_SESSION_ID, false);
            focus.add(buttonSet.getFocusGroup());
            this.component = SplitPaneFactory.create((int)6, (String)"SplitPaneWithButtonRow", (Component[])new Component[]{this.getButtons(), column});
        }
        return this.component;
    }

    private void onQuery() {
        this.refresh();
        this.enableTerminateSession();
        if (this.sessions.getTable().getObjects().isEmpty()) {
            FocusHelper.setFocus((Component)this.sessions.getTable());
        }
    }

    private void onSettings() {
        SettingsDialog dialog = new SettingsDialog(this.getHelpContext());
        dialog.show();
    }

    private void onSmartFlowSheet() {
        SmartFlowSheetAdminDialog dialog = new SmartFlowSheetAdminDialog(this.context, this.getHelpContext());
        dialog.show();
    }

    private void onCaches() {
        CacheDialog dialog = new CacheDialog(this.getHelpContext().subtopic("cache"));
        dialog.show();
    }

    private void onDiagnostics() {
        DiagnosticsDialog dialog = new DiagnosticsDialog(this.context, this.getHelpContext().subtopic("diagnostics"));
        dialog.show();
    }

    private void enableTerminateSession() {
        this.getButtonSet().setEnabled(TERMINATE_SESSION_ID, this.sessions.getSelected() != null);
    }

    private void onTerminateSession() {
        SessionMonitor.Session selected = (SessionMonitor.Session)this.sessions.getSelected();
        if (selected != null) {
            long id = this.sessionMonitor.getCurrentSessionMonitorId();
            if (selected.getId() == id) {
                ErrorDialog.show((String)Messages.get((String)"admin.session.terminate.title"), (String)Messages.get((String)"admin.session.terminate.active"));
            } else {
                ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"admin.session.terminate.title"))).message(Messages.format((String)"admin.session.terminate.message", (Object[])new Object[]{selected.getName(), selected.getHost()}))).yesNo()).yes(() -> {
                    this.sessionMonitor.terminate(selected);
                    this.refresh();
                })).show();
            }
        }
    }

    private void refresh() {
        this.sessions.setResultSet(this.getSessions());
    }

    private ResultSet<SessionMonitor.Session> getSessions() {
        List sessions = this.sessionMonitor.getSessions();
        Object set = new ListResultSet<SessionMonitor.Session>(sessions, 20){

            public void sort(SortConstraint[] sort) {
                super.sort(sort);
                IMObjectSorter.sort((List)this.getObjects(), (SortConstraint[])sort, input -> input);
            }
        };
        final String query = this.search.getString();
        if (!StringUtils.isEmpty((CharSequence)query)) {
            set = new FilteredResultSet<SessionMonitor.Session>((ResultSet)set){

                protected void filter(SessionMonitor.Session object, List<SessionMonitor.Session> results) {
                    if (this.contains(object.getName(), query) || this.contains(object.getHost(), query) || this.contains(UserHelper.getName((String)object.getName()), query)) {
                        results.add(object);
                    }
                }

                boolean contains(String value, String search) {
                    return value != null && value.toLowerCase().contains(search.toLowerCase());
                }
            };
        }
        set.sort(new SortConstraint[]{SessionTableModel.getSortOnLogin(true)});
        return set;
    }

    private static class SessionTableModel
    extends AbstractIMTableModel<SessionMonitor.Session> {
        private static final int LOGIN_INDEX = 0;
        private static final int USER_INDEX = 1;
        private static final int HOST_INDEX = 2;
        private static final int LOGGED_IN_INDEX = 3;
        private static final int LAST_ACCESSED_INDEX = 4;

        SessionTableModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(SessionTableModel.createTableColumn((int)0, (String)"admin.system.login"));
            model.addColumn(SessionTableModel.createTableColumn((int)1, (String)"admin.system.user"));
            model.addColumn(SessionTableModel.createTableColumn((int)2, (String)"admin.system.session.host"));
            model.addColumn(SessionTableModel.createTableColumn((int)3, (String)"admin.system.session.loggedin"));
            model.addColumn(SessionTableModel.createTableColumn((int)4, (String)"admin.system.session.lastaccessed"));
            this.setTableColumnModel((TableColumnModel)model);
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            SortConstraint[] sortConstraintArray;
            SortConstraint sort = null;
            switch (column) {
                case 0: {
                    sort = SessionTableModel.getSortOnLogin(ascending);
                    break;
                }
                case 1: {
                    sort = new VirtualNodeSortConstraint("user", ascending, input -> {
                        String login = ((SessionMonitor.Session)input).getName();
                        return UserHelper.getName((String)login);
                    });
                    break;
                }
                case 2: {
                    sort = new VirtualNodeSortConstraint("host", ascending, input -> ((SessionMonitor.Session)input).getHost());
                    break;
                }
                case 3: {
                    sort = new VirtualNodeSortConstraint("loggedIn", ascending, input -> ((SessionMonitor.Session)input).getLoggedIn());
                    break;
                }
                case 4: {
                    sort = new VirtualNodeSortConstraint("lastAccessed", ascending, input -> ((SessionMonitor.Session)input).getLastAccessed());
                }
            }
            if (sort != null) {
                SortConstraint[] sortConstraintArray2 = new SortConstraint[1];
                sortConstraintArray = sortConstraintArray2;
                sortConstraintArray2[0] = sort;
            } else {
                sortConstraintArray = null;
            }
            return sortConstraintArray;
        }

        protected Object getValue(SessionMonitor.Session object, TableColumn column, int row) {
            String result = null;
            switch (column.getModelIndex()) {
                case 0: {
                    result = object.getName();
                    break;
                }
                case 1: {
                    result = UserHelper.getName((String)object.getName());
                    break;
                }
                case 2: {
                    result = object.getHost();
                    break;
                }
                case 3: {
                    result = DateFormatter.formatDateTimeAbbrev((Date)object.getLoggedIn());
                    break;
                }
                case 4: {
                    result = DateFormatter.formatDateTimeAbbrev((Date)object.getLastAccessed());
                }
            }
            return result;
        }

        static SortConstraint getSortOnLogin(boolean ascending) {
            VirtualNodeSortConstraint sort = new VirtualNodeSortConstraint("name", ascending, input -> ((SessionMonitor.Session)input).getName());
            return sort;
        }
    }
}

