/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.mapping;

import java.io.Serializable;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.TableModelListener;
import nextapp.echo2.app.table.TableColumn;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.mapping.model.Mapping;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Target;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.property.AbstractSaveableEditor;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.table.DefaultTableCellRenderer;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.mapping.MappingEditor;
import org.openvpms.web.workspace.admin.mapping.MappingResultSet;
import org.openvpms.web.workspace.admin.mapping.MappingState;
import org.openvpms.web.workspace.admin.mapping.MappingTableModel;

public class MappingEditors<T extends IMObject>
extends AbstractSaveableEditor {
    private final Mappings<T> mappings;
    private final LayoutContext context;
    private PagedIMTable<Mapping> table;
    private Component component;
    private MappingEditor<?>[] editors;

    public MappingEditors(Mappings<T> mappings, LayoutContext context) {
        this.mappings = mappings;
        this.context = context;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.table = new PagedIMTable(new MappingEditorTableModel<T>(this.mappings, this.context));
            this.style((Table)this.table.getTable());
            this.refreshTable();
            this.component = ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.table.getComponent()});
            this.table.getTable().getModel().addTableModelListener((TableModelListener & Serializable)event -> {
                if (event.getType() == 3 && event.getFirstRow() == event.getLastRow()) {
                    this.setModified();
                    this.refreshTable();
                }
            });
        }
        return this.component;
    }

    protected void doSave() {
        this.mappings.save();
    }

    protected boolean doValidation(Validator validator) {
        boolean valid = true;
        if (this.editors != null) {
            for (MappingEditor<?> editor : this.editors) {
                if (editor == null || editor.validate(validator)) continue;
                valid = false;
                break;
            }
            if (valid) {
                for (Mapping mapping : this.mappings.getMappings()) {
                    Target target = mapping.getTarget();
                    if (mapping.getSource() == null || target == null || this.mappings.getTarget(target.getId()) != null) continue;
                    String message = Messages.format((String)"mapping.targetnotfound", (Object[])new Object[]{target.getName(), this.mappings.getTargetDisplayName()});
                    validator.add((Modifiable)this, new ValidatorError(message));
                    valid = false;
                    break;
                }
            }
        }
        return valid;
    }

    private void style(Table table) {
        table.setStyleName("list");
        table.setDefaultRenderer(Object.class, DefaultTableCellRenderer.INSTANCE);
        table.setRolloverEnabled(false);
        table.setSelectionEnabled(false);
    }

    private void refreshTable() {
        int page = this.table.getModel().getPage();
        this.table.setResultSet((ResultSet)new MappingResultSet(null, 20, this.mappings));
        if (page != 0) {
            this.table.getNavigator().setPage(page);
        }
    }

    static /* synthetic */ MappingEditor[] access$002(MappingEditors x0, MappingEditor[] x1) {
        x0.editors = x1;
        return x1;
    }

    private class MappingEditorTableModel<O extends IMObject>
    extends MappingTableModel<O> {
        private final LayoutContext context;

        MappingEditorTableModel(Mappings<O> mappings, LayoutContext context) {
            super(mappings);
            this.context = context;
        }

        public void setObjects(List<Mapping> objects) {
            super.setObjects(objects);
            MappingEditors.access$002(MappingEditors.this, new MappingEditor[objects.size()]);
        }

        @Override
        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return null;
        }

        @Override
        protected Object getValue(Mapping object, TableColumn column, int row) {
            MappingEditor editor = MappingEditors.this.editors[row];
            if (editor == null) {
                MappingEditor newEditor = new MappingEditor((MappingState)object, MappingEditors.this.mappings, this.context);
                ModifiableListener listener = modifiable -> {
                    if (newEditor.isValid()) {
                        this.fireTableRowsUpdated(row, row);
                    }
                };
                newEditor.addModifiableListener(listener);
                ((MappingEditors)MappingEditors.this).editors[row] = newEditor;
                editor = newEditor;
            }
            if (column.getModelIndex() == 0) {
                return editor.getSource().getComponent();
            }
            return editor.getTarget().getComponent();
        }
    }
}

