/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import echopointng.GroupBox;
import java.util.List;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.FilteredResultSet;
import org.openvpms.web.component.im.query.IMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.GroupBoxFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;

class ReplaceLookupBrowser
extends IMObjectTableBrowser<Lookup> {
    private final Lookup replace;
    private final CheckBox deleteSource;
    private final Component gridContainer;
    private final Component queryContainer;

    public ReplaceLookupBrowser(Query<Lookup> query, Lookup lookup, LayoutContext context) {
        super(query, context);
        query.setMaxResults(15);
        this.replace = lookup;
        this.deleteSource = CheckBoxFactory.create((String)"lookup.replace.delete", (boolean)false);
        this.gridContainer = ColumnFactory.create((String)"Inset");
        this.queryContainer = ColumnFactory.create((String)"WideCellSpacing");
    }

    public boolean deleteLookup() {
        return this.deleteSource.isSelected();
    }

    protected void notifySelected(Lookup selected) {
        this.gridContainer.removeAll();
        this.gridContainer.add((Component)this.createGrid());
        super.notifySelected((Object)selected);
    }

    protected PagedIMTable<Lookup> createTable(IMTableModel<Lookup> model) {
        return new PagedIMTable(model);
    }

    protected void doLayout() {
        Column container = ColumnFactory.create((String)"Inset.Large");
        this.doLayout((Component)container);
        this.setComponent((Component)container);
    }

    protected void doLayout(Component container) {
        Column column = ColumnFactory.create((String)"WideCellSpacing");
        this.gridContainer.removeAll();
        this.gridContainer.add((Component)this.createGrid());
        column.add(this.gridContainer);
        this.queryContainer.removeAll();
        this.queryContainer.add(this.doQueryLayout());
        GroupBox box = GroupBoxFactory.create((String)"lookup.replace.select", (Component[])new Component[]{this.queryContainer});
        column.add((Component)box);
        Label label = LabelFactory.create((String)"lookup.replace.message", (boolean)true);
        label.setStyleName("bold");
        column.add((Component)label);
        container.add((Component)column);
    }

    protected void doLayoutForResults(Component container) {
        super.doLayoutForResults(this.queryContainer);
    }

    protected void doLayoutForNoResults(Component container) {
        super.doLayoutForNoResults(this.queryContainer);
    }

    private Grid createGrid() {
        Grid grid = GridFactory.create((int)4);
        grid.add((Component)LabelFactory.create());
        grid.add((Component)LabelFactory.create((String)"table.imobject.name", (String)"bold"));
        grid.add((Component)LabelFactory.create((String)"table.imobject.description", (String)"bold"));
        grid.add((Component)LabelFactory.create());
        grid.add((Component)LabelFactory.create((String)"lookup.replace.replace", (String)"bold"));
        grid.add((Component)this.createLabel(this.replace.getName()));
        grid.add((Component)this.createLabel(this.replace.getDescription()));
        grid.add((Component)this.deleteSource);
        grid.add((Component)LabelFactory.create((String)"lookup.replace.with", (String)"bold"));
        Lookup selected = (Lookup)this.getSelected();
        String name = selected != null ? selected.getName() : Messages.get((String)"imobject.none");
        String description = selected != null ? selected.getDescription() : "";
        grid.add((Component)this.createLabel(name));
        grid.add((Component)this.createLabel(description));
        return grid;
    }

    protected ResultSet<Lookup> doQuery() {
        ResultSet set = super.doQuery();
        return new FilteredResultSet<Lookup>(set){

            protected void filter(Lookup lookup, List<Lookup> results) {
                if (!lookup.equals(ReplaceLookupBrowser.this.replace)) {
                    results.add(lookup);
                }
            }
        };
    }

    private Label createLabel(String text) {
        Label label = LabelFactory.create();
        label.setText(text);
        return label;
    }
}

