/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.laboratory.io;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.laboratory.internal.io.LaboratoryTestDataMatcher;
import org.openvpms.laboratory.internal.io.LaboratoryTestDataSet;
import org.openvpms.laboratory.internal.io.LaboratoryTestDataUpdater;
import org.openvpms.laboratory.internal.io.LaboratoryTestProductData;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.MapBasedMarkablePagedIMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.laboratory.io.LaboratoryTestDataModel;
import org.openvpms.web.workspace.admin.laboratory.io.LaboratoryTestProductDataModel;
import org.openvpms.web.workspace.admin.laboratory.io.RestrictedInvestigationTypeReferenceEditor;

public class LaboratoryTestImportDialog
extends PopupDialog {
    private final Context context;
    private final Column container;
    private final String investigationTypeDisplayName;
    private final LaboratoryTestDataMatcher matcher;
    private final LocationRules locationRules;
    private final LayoutContext layoutContext;
    private LaboratoryTestDataSet data;
    private Map<Product, LaboratoryTestProductData> selected;
    private boolean testDataSaved = false;
    private List<LaboratoryTestProductData> productData;
    private static final String PREVIOUS_ID = "button.previous";
    private static final String NEXT_ID = "button.next";
    private static final String[] BUTTONS = new String[]{"button.previous", "button.next", "ok", "cancel"};

    public LaboratoryTestImportDialog(LaboratoryTestDataSet data, Context context, HelpContext help) {
        super(Messages.get((String)"admin.laboratory.import.title"), "BrowserDialog", BUTTONS, help);
        this.setModal(true);
        this.data = data;
        this.context = context;
        this.layoutContext = new DefaultLayoutContext(context, help);
        this.container = ColumnFactory.create((String)"CellSpacing");
        this.locationRules = (LocationRules)ServiceHelper.getBean(LocationRules.class);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        this.investigationTypeDisplayName = DescriptorHelper.getDisplayName((String)"entity.investigationType", (ArchetypeService)service);
        this.matcher = (LaboratoryTestDataMatcher)ServiceHelper.getBean(LaboratoryTestDataMatcher.class);
        ButtonSet buttons = this.getButtons();
        buttons.setEnabled(PREVIOUS_ID, false);
        buttons.setEnabled("ok", false);
        this.setCancelListener(action -> {
            if (this.selected != null && !this.selected.isEmpty()) {
                ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("admin.laboratory.import.title", new Object[0])).messageKey("admin.laboratory.import.cancelImport", new Object[0])).yesNo()).yes(() -> action.veto(false))).no(() -> action.veto(true))).show();
            } else {
                action.veto(false);
            }
        });
    }

    protected void doLayout() {
        this.getLayout().add((Component)this.container);
        this.showTests();
    }

    protected void onButton(String button) {
        if (PREVIOUS_ID.equals(button)) {
            this.onPrevious();
        } else if (NEXT_ID.equals(button)) {
            this.onNext();
        } else {
            super.onButton(button);
        }
    }

    protected void onOK() {
        if (this.saveProducts()) {
            super.onOK();
        }
    }

    private void onPrevious() {
        this.showTests();
    }

    private void onNext() {
        if (!this.testDataSaved) {
            this.confirmSaveTestData();
        } else {
            this.showProducts();
        }
    }

    private void onInvestigationTypeSelected(org.openvpms.component.business.domain.im.common.Entity investigationType) {
        this.data = new LaboratoryTestDataSet(this.data.getData(), this.data.getErrors(), (Entity)investigationType);
    }

    private void showTests() {
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{LabelFactory.create((String)"admin.laboratory.import.newAndUpdatedTests", (String)"h3")});
        Label label = LabelFactory.text((String)this.investigationTypeDisplayName, (String)"bold");
        if (this.data.getInvestigationType() != null) {
            column.add((Component)RowFactory.create((String)"CellSpacing", (Component[])new Component[]{label, LabelFactory.text((String)this.data.getInvestigationType().getName())}));
        } else {
            org.openvpms.component.business.domain.im.common.Entity investigationType = (org.openvpms.component.business.domain.im.common.Entity)this.data.getInvestigationType();
            SimpleProperty property = SimpleProperty.newProperty().name("investigationType").type(Reference.class).displayName(this.investigationTypeDisplayName).archetypeRange(new String[]{"entity.investigationType"}).build();
            RestrictedInvestigationTypeReferenceEditor editor = new RestrictedInvestigationTypeReferenceEditor((Property)property, this.layoutContext);
            editor.setObject(investigationType);
            column.add((Component)RowFactory.create((String)"CellSpacing", (Component[])new Component[]{label, editor.getComponent()}));
            property.addModifiableListener(modifiable -> {
                org.openvpms.component.business.domain.im.common.Entity object = (org.openvpms.component.business.domain.im.common.Entity)editor.getObject();
                this.onInvestigationTypeSelected(object);
            });
        }
        ListResultSet resultSet = new ListResultSet(this.data.getData(), 20);
        LaboratoryTestDataModel model = new LaboratoryTestDataModel();
        PagedIMTable table = new PagedIMTable((IMTableModel)model, (ResultSet)resultSet);
        column.add(table.getComponent());
        this.container.removeAll();
        this.container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{column}));
        this.enableButtons(true);
    }

    private void confirmSaveTestData() {
        if (this.data.getInvestigationType() == null) {
            ((ErrorDialogBuilder)ErrorDialog.newDialog().messageKey("property.error.required", new Object[]{this.investigationTypeDisplayName})).show();
        } else {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("admin.laboratory.import.title", new Object[0])).messageKey("admin.laboratory.import.save", new Object[0])).yesNo()).yes(() -> {
                this.saveTestData();
                this.showProducts();
            })).show();
        }
    }

    private void saveTestData() {
        LaboratoryTestDataUpdater updater = (LaboratoryTestDataUpdater)ServiceHelper.getBean(LaboratoryTestDataUpdater.class);
        this.data = updater.update(this.data);
        this.testDataSaved = true;
    }

    private void showProducts() {
        List<LaboratoryTestProductData> data = this.getProductData();
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{LabelFactory.create((String)"admin.laboratory.import.updatePrices", (String)"h3")});
        this.enableButtons(false);
        if (data.isEmpty()) {
            column.add((Component)LabelFactory.create((String)"admin.laboratory.import.noProducts", (String)"bold"));
        } else {
            column.add((Component)LabelFactory.create((String)"admin.laboratory.import.selectProducts"));
            ListResultSet resultSet = new ListResultSet(data, 20);
            LaboratoryTestProductDataModel model = new LaboratoryTestProductDataModel(this.layoutContext);
            MapBasedMarkablePagedIMTableModel pagedModel = new MapBasedMarkablePagedIMTableModel((IMTableModel)model, this.selected, LaboratoryTestProductData::getNewProduct);
            PagedIMTable table = new PagedIMTable((IMTableModel)pagedModel, (ResultSet)resultSet);
            column.add(table.getComponent());
        }
        this.container.removeAll();
        this.container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{column}));
        this.enableButtons(false);
    }

    private boolean saveProducts() {
        boolean result = true;
        if (this.selected != null && !this.selected.isEmpty() && !SaveHelper.save(this.selected.keySet())) {
            result = false;
        }
        return result;
    }

    private List<LaboratoryTestProductData> getProductData() {
        if (this.productData == null) {
            PricingGroup pricingGroup = new PricingGroup(this.locationRules.getPricingGroup(this.context.getLocation()));
            this.productData = this.matcher.matchProducts(this.data.getData(), new Date());
            this.selected = this.productData.stream().filter(LaboratoryTestProductData::costIncreased).collect(Collectors.toMap(LaboratoryTestProductData::getNewProduct, Function.identity()));
        }
        return this.productData;
    }

    private void enableButtons(boolean first) {
        ButtonSet buttons = this.getButtons();
        buttons.setEnabled(PREVIOUS_ID, !first);
        buttons.setEnabled(NEXT_ID, first);
        buttons.setEnabled("ok", !first);
    }
}

