/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job;

import java.util.regex.Pattern;

public class CronHelper {
    public static final Pattern MINUTES = CronHelper.getPattern("[0-5]?\\d");
    public static final Pattern HOURS = CronHelper.getPattern("[01]?\\d|2[0-3]");
    public static final Pattern DAY_OF_MONTH = CronHelper.getPattern("\\?|", "0?[1-9]|[12]\\d|3[01]", null);
    public static final Pattern MONTH = CronHelper.getPattern(null, "[1-9]|1[012]", "|" + CronHelper.createRange("jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec"));
    public static final Pattern DAY_OF_WEEK = CronHelper.getPattern("\\?|", "[1-7]", "|" + CronHelper.createRange("mon|tue|wed|thu|fri|sat|sun"));

    private static Pattern getPattern(String prefix, String value, String suffix) {
        StringBuilder pattern = new StringBuilder();
        if (prefix != null) {
            pattern.append(prefix);
        }
        pattern.append(CronHelper.createRange(value));
        if (suffix != null) {
            pattern.append(suffix);
        }
        return Pattern.compile(pattern.toString(), 2);
    }

    private static Pattern getPattern(String value) {
        return CronHelper.getPattern(null, value, null);
    }

    private static String createRange(String value) {
        String range = "(" + value + ")(-(" + value + ")(\\/\\d+)?)?";
        return "\\*(\\/\\d+)?|" + range + "(," + range + ")*";
    }
}

