/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job;

import java.text.ParseException;
import java.util.regex.Pattern;
import org.openvpms.component.business.service.singleton.SingletonServiceImpl;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.job.CronHelper;
import org.quartz.CronExpression;

public abstract class AbstractJobConfigurationEditor
extends AbstractIMObjectEditor {
    private final IMObjectBean bean;
    private static final String RUN_AS = "runAs";
    private static final String NOTIFY = "notify";

    public AbstractJobConfigurationEditor(Entity object, IMObject parent, LayoutContext layoutContext) {
        super((IMObject)object, parent, layoutContext);
        User user;
        this.bean = this.getBean((IMObject)object);
        if (object.isNew() && (user = layoutContext.getContext().getUser()) != null) {
            this.initRunAs(user);
            this.initNotify(user);
        }
    }

    protected boolean doValidation(Validator validator) {
        boolean valid = super.doValidation(validator);
        if (valid) {
            boolean bl = valid = this.validateMinutes(validator) && this.validateHours(validator) && this.validateDayOfMonth(validator) && this.validateMonth(validator) && this.validateDayOfWeek(validator) && this.validateRunAs(validator) && this.validateNotify(validator);
            if (valid) {
                Property property = this.getProperty("expression");
                String expression = property.getString();
                try {
                    new CronExpression(expression);
                }
                catch (ParseException exception) {
                    valid = false;
                    validator.add((Modifiable)property, new ValidatorError(property, exception.getMessage()));
                }
            }
        }
        return valid;
    }

    protected boolean checkSingleton(Validator validator) {
        SingletonServiceImpl service;
        boolean valid = true;
        IMObject object = this.getObject();
        if (object.isActive() && (service = (SingletonServiceImpl)ServiceHelper.getBean(SingletonServiceImpl.class)).exists(object.getArchetype(), object.getObjectReference())) {
            valid = false;
            validator.add((Modifiable)this, new ValidatorError(Messages.format((String)"job.exists", (Object[])new Object[]{this.getDisplayName()})));
        }
        return valid;
    }

    protected void initRunAs(User user) {
        if (this.getProperty(RUN_AS) != null) {
            this.bean.setTarget(RUN_AS, (IMObject)user);
        }
    }

    protected void initNotify(User user) {
        if (this.getProperty(NOTIFY) != null) {
            this.bean.setTarget(NOTIFY, (IMObject)user);
        }
    }

    private boolean validateMinutes(Validator validator) {
        return this.validateProperty("minutes", CronHelper.MINUTES, validator);
    }

    private boolean validateHours(Validator validator) {
        return this.validateProperty("hours", CronHelper.HOURS, validator);
    }

    private boolean validateDayOfMonth(Validator validator) {
        return this.validateProperty("dayOfMonth", CronHelper.DAY_OF_MONTH, validator);
    }

    private boolean validateMonth(Validator validator) {
        return this.validateProperty("month", CronHelper.MONTH, validator);
    }

    private boolean validateDayOfWeek(Validator validator) {
        return this.validateProperty("dayOfWeek", CronHelper.DAY_OF_WEEK, validator);
    }

    private boolean validateProperty(String name, Pattern pattern, Validator validator) {
        boolean valid;
        Property property = this.getProperty(name);
        String value = property.getString();
        if (value == null) {
            value = "";
        }
        if (!(valid = pattern.matcher(value).matches())) {
            validator.add((Modifiable)property, new ValidatorError(property, Messages.format((String)"job.property.invalid", (Object[])new Object[]{value})));
        }
        return valid;
    }

    private boolean validateRunAs(Validator validator) {
        return this.validateUser(RUN_AS, validator);
    }

    private boolean validateNotify(Validator validator) {
        return this.validateUser(NOTIFY, validator);
    }

    private boolean validateUser(String name, Validator validator) {
        Entity userOrGroup;
        boolean valid = true;
        Property property = this.getProperty(name);
        if (property != null && (userOrGroup = (Entity)this.getObject(this.bean.getTargetRef(name))) != null && !userOrGroup.isActive()) {
            validator.add((Modifiable)property, new ValidatorError(Messages.format((String)"admin.job.user.inactive", (Object[])new Object[]{property.getDisplayName()})));
            valid = false;
        }
        return valid;
    }
}

