/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import java.util.HashMap;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.hl7.service.Services;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

abstract class HL7ServiceGroupEditor
extends AbstractIMObjectEditor {
    private final Services services;

    public HL7ServiceGroupEditor(IMObject object, IMObject parent, Services services, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
        this.services = services;
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateServices(validator);
    }

    private boolean validateServices(Validator validator) {
        boolean result = true;
        HashMap<Reference, Entity> locations = new HashMap<Reference, Entity>();
        CollectionProperty property = this.getCollectionProperty("services");
        for (Object value : property.getValues()) {
            IMObjectBean bean;
            Reference location;
            Relationship relationship = (Relationship)value;
            Entity service = relationship.getTarget() != null ? this.services.getService(relationship.getTarget()) : null;
            if (service == null || (location = (bean = this.getBean((IMObject)service)).getTargetRef("location")) == null) continue;
            Entity existing = (Entity)locations.get(location);
            if (existing != null) {
                String message = Messages.format((String)"admin.hl7.serviceGroup.duplicateLocation", (Object[])new Object[]{existing.getName(), service.getName(), IMObjectHelper.getName((Reference)location)});
                validator.add((Modifiable)this, new ValidatorError((Property)property, message));
                result = false;
                break;
            }
            locations.put(location, service);
        }
        return result;
    }
}

