/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.filetransfer.UploadListener;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.doc.DocumentUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.edit.DefaultIMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.AbstractViewCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.servlet.DownloadServlet;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.hl7.LookupMapping;
import org.openvpms.web.workspace.admin.hl7.LookupMappingCSVWriter;
import org.openvpms.web.workspace.admin.hl7.LookupMappingExportDialog;
import org.openvpms.web.workspace.admin.hl7.LookupMappingImportErrorDialog;
import org.openvpms.web.workspace.admin.hl7.LookupMappingImporter;
import org.openvpms.web.workspace.admin.hl7.LookupMappings;

public class HL7MappingCRUDWindow
extends AbstractViewCRUDWindow<Entity> {
    private static final String EXPORT_ID = "button.exportMapping";
    private static final String IMPORT_ID = "button.importMapping";

    public HL7MappingCRUDWindow(Archetypes<Entity> archetypes, Context context, HelpContext help) {
        super(archetypes, (IMObjectActions)DefaultIMObjectActions.getInstance(), context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(EXPORT_ID, this::onExport);
        buttons.add(IMPORT_ID, this::onImport);
    }

    private void onExport() {
        HelpContext help = this.getHelpContext().subtopic("export");
        final LookupMappingExportDialog dialog = new LookupMappingExportDialog(help);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                String from = dialog.getMapFrom();
                String to = dialog.getMapTo();
                LookupMappingCSVWriter writer = new LookupMappingCSVWriter((IArchetypeService)ServiceHelper.getArchetypeService(), ServiceHelper.getLookupService(), ServiceHelper.getDocumentHandlers(), HL7MappingCRUDWindow.this.getSeparator());
                String name = from + "-to-" + to + "-mapping.csv";
                Document document = writer.write(name, from, to);
                DownloadServlet.startDownload((org.openvpms.component.model.document.Document)document);
            }
        });
        dialog.show();
    }

    private void onImport() {
        final HelpContext help = this.getHelpContext().subtopic("import");
        DocumentUploadListener listener = new DocumentUploadListener(){

            protected void upload(org.openvpms.component.model.document.Document document) {
                try {
                    HL7MappingCRUDWindow.this.importMapping(document, help);
                }
                catch (Throwable exception) {
                    ErrorHelper.show((Throwable)exception);
                }
            }
        };
        UploadDialog dialog = new UploadDialog((UploadListener)listener, help.subtopic("upload"));
        dialog.show();
    }

    private void importMapping(org.openvpms.component.model.document.Document document, HelpContext help) {
        LookupMappingImporter importer = new LookupMappingImporter((ArchetypeService)ServiceHelper.getArchetypeService(), ServiceHelper.getLookupService(), ServiceHelper.getDocumentHandlers(), this.getSeparator());
        LookupMappings mappings = importer.load(document);
        if (!mappings.getErrors().isEmpty()) {
            List<LookupMapping> errors = mappings.getErrors();
            LookupMappingImportErrorDialog dialog = new LookupMappingImportErrorDialog(errors, help.subtopic("error"));
            dialog.show();
        } else {
            InformationDialog.show((String)Messages.get((String)"admin.hl7.mapping.import.title"), (String)Messages.get((String)"admin.hl7.mapping.import.message"));
        }
    }

    private char getSeparator() {
        Context context = this.getContext();
        Party practice = context.getPractice();
        if (practice != null) {
            PracticeRules rules = (PracticeRules)ServiceHelper.getBean(PracticeRules.class);
            return rules.getExportFileFieldSeparator(practice);
        }
        return ',';
    }
}

