/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.eftpos;

import echopointng.HttpPaneEx;
import nextapp.echo2.app.Component;
import org.openvpms.eftpos.internal.event.EFTPOSEventMonitor;
import org.openvpms.eftpos.service.WebTerminalRegistrar;
import org.openvpms.eftpos.terminal.Terminal;
import org.openvpms.eftpos.terminal.TerminalStatus;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.InformationDialogBuilder;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.util.ApplicationInstanceConsumer;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class WebTerminalRegistrationDialog
extends ModalDialog {
    private final Terminal terminal;
    private final EFTPOSEventMonitor monitor;
    private ApplicationInstanceConsumer<TerminalStatus> listener;

    public WebTerminalRegistrationDialog(Terminal terminal, WebTerminalRegistrar registrar) {
        super(Messages.get((String)"admin.eftpos.register.title"), CANCEL, null);
        this.terminal = terminal;
        this.setContentWidth(registrar.getWidth());
        this.setContentHeight(registrar.getHeight());
        this.monitor = (EFTPOSEventMonitor)ServiceHelper.getBean(EFTPOSEventMonitor.class);
        HttpPaneEx frame = new HttpPaneEx(registrar.getUrl());
        this.getLayout().add((Component)frame);
    }

    public void show() {
        super.show();
        this.listener = new ApplicationInstanceConsumer(this::onCompleted);
        this.monitor.addTerminalListener(this.terminal, this.listener);
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.listener.dispose();
        }
    }

    private void onCompleted(TerminalStatus status) {
        this.monitor.removeTerminalListener(this.terminal, this.listener);
        if (this.getParent() != null) {
            String title = Messages.get((String)"admin.eftpos.register.title");
            if (status.isRegistered()) {
                ((InformationDialogBuilder)((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().title(title)).message(Messages.get((String)"admin.eftpos.register.registered"))).ok(() -> this.close("ok"))).show();
            } else {
                ((InformationDialogBuilder)((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().title(title)).message(Messages.format((String)"admin.eftpos.register.error", (Object[])new Object[]{status.getMessage()}))).ok(() -> this.close("cancel"))).show();
            }
        }
    }
}

