/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.calendar;

import java.util.Date;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.admin.calendar.CalendarGrid;

public class CalendarGridView
implements CalendarGrid {
    private final CalendarGrid grid;
    private final int startMins;
    private final int endMins;
    private final int startSlot;
    private final int slots;

    public CalendarGridView(CalendarGrid grid, int startMins, int endMins) {
        this.grid = grid;
        this.startMins = startMins;
        this.endMins = endMins;
        int start = grid.getFirstSlot(startMins);
        if (start == -1) {
            start = grid.getSlots() > 0 ? grid.getSlots() - 1 : 0;
        }
        this.startSlot = start;
        int endSlot = grid.getEndMins() == endMins ? grid.getLastSlot(endMins - grid.getSlotSize()) : grid.getLastSlot(endMins);
        this.slots = endSlot - this.startSlot + 1;
    }

    @Override
    public int getStartMins() {
        return this.startMins;
    }

    @Override
    public int getEndMins() {
        return this.endMins;
    }

    @Override
    public int getFirstSlot(int minutes) {
        int slot = this.grid.getFirstSlot(minutes);
        return slot >= 0 ? slot - this.startSlot : slot;
    }

    @Override
    public int getLastSlot(int minutes) {
        int slot = this.grid.getLastSlot(minutes);
        return slot >= 0 ? slot - this.startSlot : slot;
    }

    @Override
    public int getSlots() {
        return this.slots;
    }

    @Override
    public Date getStartDate() {
        return this.grid.getStartDate();
    }

    @Override
    public int getDays() {
        return this.grid.getDays();
    }

    @Override
    public Date getStartTime(int slot) {
        return this.grid.getStartTime(this.startSlot + slot);
    }

    @Override
    public Date getDatetime(int offset, int slot) {
        return this.grid.getDatetime(offset, this.startSlot + slot);
    }

    @Override
    public PropertySet getEvent(int offset, int slot) {
        return this.grid.getEvent(offset, this.startSlot + slot);
    }

    @Override
    public int getHour(int slot) {
        return this.grid.getHour(this.startSlot + slot);
    }

    @Override
    public int getSlotSize() {
        return this.grid.getSlotSize();
    }
}

