/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.archetype;

import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.tools.archetype.comparator.ArchetypeChange;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.archetype.BatchArchetypeUpdater;

class ConfirmingBatchArchetypeUpdater {
    ConfirmingBatchArchetypeUpdater() {
    }

    public void confirmUpdate(final List<ArchetypeChange> changes) {
        StringBuffer names = new StringBuffer();
        for (ArchetypeChange change : changes) {
            if (names.length() != 0) {
                names.append(", ");
            }
            names.append(((ArchetypeDescriptor)change.getNewVersion()).getDisplayName());
        }
        String title = Messages.get((String)"archetype.update.title");
        String message = Messages.format((String)"archetype.update.message", (Object[])new Object[]{names});
        ConfirmationDialog dialog = new ConfirmationDialog(title, message);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                ConfirmingBatchArchetypeUpdater.this.update(changes);
            }
        });
        dialog.show();
    }

    private void update(List<ArchetypeChange> changes) {
        BatchArchetypeUpdater updater = new BatchArchetypeUpdater(changes);
        updater.setListener(new BatchProcessorListener(){

            public void completed() {
            }

            public void error(Throwable exception) {
                ErrorHelper.show((Throwable)exception);
            }
        });
        updater.process();
    }
}

