/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.archetype;

import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import org.openvpms.archetype.component.processor.AbstractAsynchronousBatchProcessor;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.tools.archetype.comparator.ArchetypeChange;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.archetype.ObjectUpdateProgressBarProcessor;

public class BatchArchetypeUpdater
extends AbstractAsynchronousBatchProcessor<ArchetypeChange> {
    public static String[] ASSERTIONS = new String[]{"propercase", "lowercase", "uppercase"};
    private UpdateDialog dialog;
    private ObjectUpdateProgressBarProcessor processor;

    public BatchArchetypeUpdater(List<ArchetypeChange> changes) {
        super(changes.iterator());
    }

    protected void process(ArchetypeChange change) {
        if (this.processor == null) {
            this.processor = new ObjectUpdateProgressBarProcessor();
            this.processor.setListener(new BatchProcessorListener(){

                public void completed() {
                    BatchArchetypeUpdater.this.process();
                }

                public void error(Throwable exception) {
                    BatchArchetypeUpdater.this.notifyError(exception);
                }
            });
        }
        if (this.dialog == null) {
            this.dialog = new UpdateDialog(this.processor);
            this.dialog.show();
        }
        this.setSuspend(true);
        this.dialog.setArchetype(((ArchetypeDescriptor)change.getNewVersion()).getDisplayName());
        this.processor.update(change);
    }

    protected void processingCompleted() {
        this.closeDialog();
        this.setProcessed(this.processor.getProcessed());
        super.processingCompleted();
    }

    protected void notifyError(Throwable exception) {
        this.closeDialog();
        this.setSuspend(true);
        super.notifyError(exception);
    }

    private void closeDialog() {
        if (this.dialog != null) {
            this.dialog.setDefaultCloseAction("close");
            this.dialog.close();
            this.dialog = null;
        }
    }

    private class UpdateDialog
    extends PopupDialog {
        private final Label label;

        public UpdateDialog(ObjectUpdateProgressBarProcessor processor) {
            super(Messages.get((String)"archetype.updating.title"), CANCEL);
            this.setModal(true);
            this.label = LabelFactory.create();
            Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{this.label, processor.getComponent()});
            Column column = ColumnFactory.create((String)"Inset", (Component[])new Component[]{row});
            this.getLayout().add((Component)column);
        }

        public void setArchetype(String displayName) {
            this.label.setText(Messages.format((String)"archetype.updating.message", (Object[])new Object[]{displayName}));
        }

        protected void onCancel() {
            BatchArchetypeUpdater.this.processor.processingCompleted();
            super.onCancel();
        }
    }
}

