/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.archetype;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.component.processor.AbstractAsynchronousBatchProcessor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptors;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.tools.archetype.comparator.ArchetypeChange;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class BatchArchetypeLoader
extends AbstractAsynchronousBatchProcessor<ArchetypeDescriptor> {
    private final List<ArchetypeChange> changes = new ArrayList<ArchetypeChange>();

    public BatchArchetypeLoader(ArchetypeDescriptors descriptors) {
        super(descriptors.getArchetypeDescriptors().values().iterator());
    }

    public List<ArchetypeChange> getChanges() {
        return this.changes;
    }

    protected void process(ArchetypeDescriptor descriptor) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        service.validateObject((IMObject)descriptor);
        String shortName = descriptor.getShortName();
        ArchetypeDescriptor existing = this.getArchetypeDescriptor(shortName, (IArchetypeService)service);
        if (existing != null) {
            this.promptOnReplace(descriptor, existing);
        } else {
            ArchetypeDescriptor cached = service.getArchetypeDescriptor(shortName);
            this.save(descriptor, cached, (IArchetypeService)service);
        }
    }

    protected void notifyError(Throwable exception) {
        this.setSuspend(true);
        super.notifyError(exception);
    }

    private void save(ArchetypeDescriptor descriptor, ArchetypeDescriptor existing, IArchetypeService service) {
        service.save((IMObject)descriptor);
        this.changes.add(new ArchetypeChange((org.openvpms.component.model.archetype.ArchetypeDescriptor)existing, (org.openvpms.component.model.archetype.ArchetypeDescriptor)descriptor));
    }

    private void promptOnReplace(final ArchetypeDescriptor descriptor, final ArchetypeDescriptor existing) {
        String[] buttons = this.getIterator().hasNext() ? ConfirmationDialog.OK_SKIP_CANCEL : ConfirmationDialog.OK_CANCEL;
        String title = Messages.get((String)"archetype.import.replace.title");
        String message = Messages.format((String)"archetype.import.replace.message", (Object[])new Object[]{descriptor.getShortName()});
        ConfirmationDialog dialog = new ConfirmationDialog(title, message, buttons);
        this.setSuspend(true);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                BatchArchetypeLoader.this.replace(descriptor, existing);
                BatchArchetypeLoader.this.process();
            }

            public void onSkip() {
                BatchArchetypeLoader.this.process();
            }
        });
        dialog.show();
    }

    private void replace(ArchetypeDescriptor descriptor, ArchetypeDescriptor existing) {
        SaveHelper.replace((IMObject)existing, (IMObject)descriptor);
        this.changes.add(new ArchetypeChange((org.openvpms.component.model.archetype.ArchetypeDescriptor)existing, (org.openvpms.component.model.archetype.ArchetypeDescriptor)descriptor));
    }

    private ArchetypeDescriptor getArchetypeDescriptor(String shortName, IArchetypeService service) {
        ArchetypeDescriptor result = service.getArchetypeDescriptor(shortName);
        if (result != null) {
            result = (ArchetypeDescriptor)service.get((Reference)result.getObjectReference(), ArchetypeDescriptor.class);
        }
        return result;
    }
}

