/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.archetype;

import java.util.Collections;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.AbstractIMObjectFactory;
import org.openvpms.component.business.service.archetype.IMObjectFactory;
import org.openvpms.tools.archetype.comparator.ArchetypeChange;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditActions;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditResultSetDialog;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.AbstractLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.archetype.BatchArchetypeUpdater;
import org.openvpms.web.workspace.admin.archetype.ConfirmingBatchArchetypeUpdater;

public class ArchetypeEditDialog
extends EditResultSetDialog<ArchetypeDescriptor> {
    private final IMObjectFactory factory = new ObjectFactory();

    public ArchetypeEditDialog(String title, ArchetypeDescriptor first, ResultSet<ArchetypeDescriptor> set, IMObjectActions<ArchetypeDescriptor> actions, Context context, HelpContext help) {
        super(title, (org.openvpms.component.model.object.IMObject)first, set, actions, context, help);
        this.addButton("test", this::onTest);
    }

    protected void doSave(IMObjectEditor editor) {
        ArchetypeDescriptor current = (ArchetypeDescriptor)editor.getObject();
        ArchetypeDescriptor old = (ArchetypeDescriptor)IMObjectHelper.reload((org.openvpms.component.model.object.IMObject)current);
        super.doSave(editor);
        if (old != null) {
            ArchetypeChange change = new ArchetypeChange((org.openvpms.component.model.archetype.ArchetypeDescriptor)current, (org.openvpms.component.model.archetype.ArchetypeDescriptor)old);
            boolean updateDerived = change.hasChangedDerivedNodes();
            boolean updateAssertions = change.hasAddedAssertions(BatchArchetypeUpdater.ASSERTIONS);
            if (updateDerived || updateAssertions) {
                ConfirmingBatchArchetypeUpdater updater = new ConfirmingBatchArchetypeUpdater();
                updater.confirmUpdate(Collections.singletonList(change));
            }
        }
    }

    private void onTest() {
        try {
            DefaultValidator validator = new DefaultValidator();
            if (this.getEditor().validate((Validator)validator)) {
                ArchetypeDescriptor descriptor = (ArchetypeDescriptor)this.getEditor().getObject();
                String shortName = descriptor.getShortName();
                IMObject object = this.factory.create(shortName);
                TestLayoutContext context = new TestLayoutContext((Context)new LocalContext(), this.getHelpContext());
                IMObjectEditor editor = context.getEditorFactory().create((org.openvpms.component.model.object.IMObject)object, (LayoutContext)context);
                TestEditDialog dialog = new TestEditDialog(editor, context.getContext());
                dialog.show();
            } else {
                ValidationHelper.showError((Validator)validator);
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }

    private ArchetypeDescriptor getArchetype() {
        return (ArchetypeDescriptor)this.getEditor().getObject();
    }

    private class TestEditDialog
    extends EditDialog {
        public TestEditDialog(IMObjectEditor editor, Context context) {
            super(editor, EditActions.ok().setSave(false), context);
            this.addButton("validate", this::onCheck);
        }

        private void onCheck() {
            DefaultValidator validator = new DefaultValidator();
            if (!this.getEditor().validate((Validator)validator)) {
                ValidationHelper.showError((Validator)validator);
            }
        }
    }

    private class TestLayoutContext
    extends AbstractLayoutContext {
        public TestLayoutContext(Context context, HelpContext help) {
            super(context, help);
        }

        public ArchetypeDescriptor getArchetypeDescriptor(org.openvpms.component.model.object.IMObject object) {
            ArchetypeDescriptor archetype = ArchetypeEditDialog.this.getArchetype();
            if (object.getArchetype().equals(archetype.getArchetypeType())) {
                return archetype;
            }
            return super.getArchetypeDescriptor(object);
        }
    }

    private class ObjectFactory
    extends AbstractIMObjectFactory {
        private ObjectFactory() {
        }

        protected ArchetypeDescriptor getArchetypeDescriptor(String shortName) {
            ArchetypeDescriptor descriptor = ArchetypeEditDialog.this.getArchetype();
            if (descriptor.getShortName().equals(shortName)) {
                return descriptor;
            }
            return ServiceHelper.getArchetypeService().getArchetypeDescriptor(shortName);
        }
    }
}

