/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace;

import java.util.Date;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ContentPane;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.TaskQueueHandle;
import nextapp.echo2.app.Window;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.webcontainer.ContainerContext;
import nextapp.echo2.webcontainer.command.BrowserOpenWindowCommand;
import nextapp.echo2.webcontainer.command.BrowserRedirectCommand;
import nextapp.echo2.webrender.ClientConfiguration;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.domain.im.party.Party;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.subscription.core.Subscription;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.app.PreferenceSelectionHistory;
import org.openvpms.web.component.app.SelectionHistory;
import org.openvpms.web.component.prefs.UserPreferences;
import org.openvpms.web.component.subscription.SubscriptionHelper;
import org.openvpms.web.component.workspace.WorkspacesFactory;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.lightbox.LightBox;
import org.openvpms.web.echo.servlet.ServletHelper;
import org.openvpms.web.echo.servlet.SessionMonitor;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.ApplicationContentPane;
import org.openvpms.web.workspace.ContextChangeListener;
import org.openvpms.web.workspace.LockScreenDialog;

public class OpenVPMSApp
extends ContextApplicationInstance {
    private final WorkspacesFactory factory;
    private final SessionMonitor monitor;
    private Window window;
    private ContextChangeListener listener;
    private String location;
    private String customer;
    private LightBox lightBox;
    private PopupDialog lockDialog;
    private TaskQueueHandle lockHandle;
    private static final int DEFAULT_LOCK_POLL_INTERVAL = 30;

    public OpenVPMSApp(GlobalContext context, WorkspacesFactory factory, PracticeRules practiceRules, LocationRules locationRules, UserRules userRules, SessionMonitor monitor, UserPreferences preferences) {
        super(context, practiceRules, locationRules, userRules, preferences);
        this.factory = factory;
        this.monitor = monitor;
        this.location = this.getLocation((IMObject)context.getLocation());
        this.customer = this.getCustomer((IMObject)context.getCustomer());
        if (monitor.getAutoLock() > 0) {
            this.getLockTaskQueue(30);
        }
        this.loadHistory();
    }

    public Window init() {
        this.configureSessionExpirationURL();
        this.setStyleSheet();
        this.window = new Window();
        this.updateTitle();
        ApplicationContentPane pane = this.createContentPane();
        this.lightBox = new LightBox();
        this.window.setContent((ContentPane)pane);
        pane.add((Component)this.lightBox);
        GlobalContext context = this.getContext();
        if (this.getActiveWindowCount() <= 1) {
            Party practice;
            Date expiryDate;
            Subscription subscription = SubscriptionHelper.getSubscription();
            Date now = new Date();
            Date date = expiryDate = subscription != null ? subscription.getExpiryDate() : null;
            if ((expiryDate == null || OpenVPMSApp.outsideGracePeriod(expiryDate, now)) && (practice = (Party)context.getPractice()) != null) {
                Date installDate = (Date)practice.getDetails().get("installDate");
                if (installDate == null || installDate.after(now)) {
                    installDate = now;
                    practice.getDetails().put("installDate", installDate);
                    try {
                        ServiceHelper.getArchetypeService((boolean)false).save((IMObject)practice);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                SubscriptionDialog dialog = new SubscriptionDialog(installDate, expiryDate, this.lightBox);
                dialog.show(this.window, this);
            }
        }
        context.addListener("party.customer*", (key, value) -> {
            this.customer = this.getCustomer(value);
            this.updateTitle();
        });
        context.addListener("party.organisationLocation", (key, value) -> {
            this.location = this.getLocation(value);
            this.updateTitle();
        });
        return this.window;
    }

    public void dispose() {
        super.dispose();
        if (this.window != null) {
            this.window.dispose();
        }
    }

    public void createWindow() {
        this.createWindow(-1, -1);
    }

    public void createWindow(int width, int height) {
        StringBuilder uri = new StringBuilder(ServletHelper.getRedirectURI((String)"app"));
        StringBuilder features = new StringBuilder("menubar=yes,toolbar=yes,location=yes");
        if (width != -1 && height != -1) {
            uri.append("?width=");
            uri.append(width);
            uri.append("&height=");
            uri.append(height);
            features.append(",width=");
            features.append(width);
            features.append(",height=");
            features.append(height);
        }
        BrowserOpenWindowCommand open = new BrowserOpenWindowCommand(uri.toString(), "_blank", features.toString());
        this.enqueueCommand((Command)open);
    }

    public int getActiveWindowCount() {
        return ServletHelper.getApplicationInstanceCount((String)"app");
    }

    public void logout() {
        this.getDefaultWindow().removeAll();
        this.clearContext();
        this.setContextChangeListener(null);
        BrowserRedirectCommand redirect = new BrowserRedirectCommand(ServletHelper.getRedirectURI((String)"logout"));
        this.enqueueCommand((Command)redirect);
    }

    public void switchTo(IMObject object) {
        if (this.listener != null) {
            this.listener.changeContext(object);
        }
    }

    public void switchTo(String shortName) {
        if (this.listener != null) {
            this.listener.changeContext(shortName);
        }
    }

    public synchronized void lock() {
        if (this.lockDialog == null) {
            this.setLockDialog(this.createLockDialog());
            this.enqueueTask(this.getLockTaskQueue(1), this::lockScreen);
        }
    }

    public synchronized void unlock() {
        if (this.lockDialog != null) {
            if (this.lockDialog.getParent() != null) {
                this.enqueueTask(this.getLockTaskQueue(1), this::unlockScreen);
            } else {
                this.lockDialog.dispose();
                this.lockDialog = null;
            }
        }
    }

    public static OpenVPMSApp getInstance() {
        return (OpenVPMSApp)ApplicationInstance.getActive();
    }

    protected ApplicationContentPane createContentPane() {
        return new ApplicationContentPane(this.getContext(), this.factory, this.getPreferences());
    }

    protected WorkspacesFactory getWorkspacesFactory() {
        return this.factory;
    }

    protected void setContextChangeListener(ContextChangeListener listener) {
        this.listener = listener;
    }

    private void loadHistory() {
        GlobalContext context = this.getContext();
        UserPreferences prefs = this.getPreferences();
        PreferenceSelectionHistory customer = new PreferenceSelectionHistory((Context)context, "party.customer*", prefs, "entity.preferenceGroupGeneral", "customerHistory");
        PreferenceSelectionHistory patient = new PreferenceSelectionHistory((Context)context, "party.patient*", prefs, "entity.preferenceGroupGeneral", "patientHistory");
        context.setHistory(customer.getShortName(), (SelectionHistory)customer);
        context.setHistory(patient.getShortName(), (SelectionHistory)patient);
    }

    private PopupDialog createLockDialog() {
        return new LockScreenDialog(this){
            private final boolean showLightBox;
            {
                this.showLightBox = !OpenVPMSApp.this.lightBox.isVisible();
            }

            public void show() {
                super.show();
                if (this.showLightBox) {
                    OpenVPMSApp.this.lightBox.setZIndex(this.getZIndex());
                    OpenVPMSApp.this.lightBox.show();
                }
            }

            @Override
            public void userClose() {
                if (this.showLightBox) {
                    OpenVPMSApp.this.lightBox.hide();
                }
                super.userClose();
                OpenVPMSApp.this.resetLockTaskQueue();
            }
        };
    }

    private void lockScreen() {
        PopupDialog dialog = this.getLockDialog();
        if (dialog != null) {
            this.monitor.locked();
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    OpenVPMSApp.this.setLockDialog(null);
                    OpenVPMSApp.this.monitor.unlock();
                }
            });
            dialog.show();
            if (this.getActiveWindowCount() <= 1) {
                this.resetLockTaskQueue();
            }
        } else {
            this.resetLockTaskQueue();
        }
    }

    private void unlockScreen() {
        try {
            PopupDialog dialog = this.getLockDialog();
            if (dialog != null) {
                this.setLockDialog(null);
                dialog.close();
            }
        }
        finally {
            this.resetLockTaskQueue();
        }
    }

    private synchronized PopupDialog getLockDialog() {
        return this.lockDialog;
    }

    private synchronized void setLockDialog(PopupDialog dialog) {
        this.lockDialog = dialog;
    }

    private synchronized TaskQueueHandle getLockTaskQueue(int interval) {
        if (this.lockHandle == null) {
            this.lockHandle = this.createTaskQueue();
        }
        this.setTaskQueueInterval(this.lockHandle, interval);
        return this.lockHandle;
    }

    private void setTaskQueueInterval(TaskQueueHandle handle, int interval) {
        ContainerContext context = (ContainerContext)this.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
        if (context != null) {
            context.setTaskQueueCallbackInterval(handle, interval * 1000);
        }
    }

    private synchronized void resetLockTaskQueue() {
        if (this.lockHandle != null) {
            this.setTaskQueueInterval(this.lockHandle, 30);
        }
    }

    private void configureSessionExpirationURL() {
        ContainerContext context = (ContainerContext)this.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
        if (context != null) {
            String url = ServletHelper.getServerURL() + ServletHelper.getRedirectURI((String)"login");
            ClientConfiguration config = new ClientConfiguration();
            config.setProperty("sessionExpirationUri", url);
            config.setProperty("sessionExpirationMessage", Messages.get((String)"session.expired"));
            context.setClientConfiguration(config);
        }
    }

    private void updateTitle() {
        this.window.setTitle(Messages.format((String)"app.title", (Object[])new Object[]{this.location, this.customer}));
    }

    private String getLocation(IMObject location) {
        return this.getName(location, "app.title.noLocation");
    }

    private String getCustomer(IMObject customer) {
        return this.getName(customer, "app.title.noCustomer");
    }

    private String getName(IMObject object, String nullKey) {
        if (object == null) {
            return Messages.get((String)nullKey);
        }
        return object.getName();
    }

    private static boolean outsideGracePeriod(Date expiryDate, Date now) {
        return Days.daysBetween((ReadableInstant)new DateTime((Object)expiryDate), (ReadableInstant)new DateTime((Object)now)).getDays() > 14;
    }

    private static class SubscriptionDialog
    extends PopupDialog {
        private final Date installDate;
        private final Date expiryDate;
        private final LightBox lightBox;
        private static final String SUBSCRIBE_ID = "button.subscribe";
        private static final String NOT_NOW_ID = "button.notnow";
        private static final String[] BUTTONS = new String[]{"button.subscribe", "button.notnow"};

        public SubscriptionDialog(Date installDate, Date expiryDate, LightBox lightBox) {
            super(Messages.get((String)"subscription.title"), "MessageDialog", BUTTONS);
            this.setModal(true);
            this.installDate = installDate;
            this.expiryDate = expiryDate;
            this.lightBox = lightBox;
        }

        public void show(Window window, OpenVPMSApp app) {
            this.doLayout();
            this.setZIndex(1);
            window.getContent().add((Component)this);
            Date date = DateRules.getDate((Date)new Date(), (int)-30, (DateUnits)DateUnits.DAYS);
            if (this.expiryDate != null && this.expiryDate.before(date) || this.expiryDate == null && this.installDate.before(date)) {
                this.getButtons().setEnabled(NOT_NOW_ID, false);
                this.setClosable(false);
                TaskQueueHandle handle = app.createTaskQueue();
                app.setTaskQueueInterval(handle, 30);
                app.enqueueTask(handle, () -> {
                    app.removeTaskQueue(handle);
                    this.getButtons().setEnabled(NOT_NOW_ID, true);
                    this.setClosable(true);
                });
            }
            this.lightBox.setZIndex(this.getZIndex());
            this.lightBox.show();
        }

        public void userClose() {
            this.lightBox.hide();
            super.userClose();
        }

        protected void onButton(String button) {
            if (SUBSCRIBE_ID.equals(button)) {
                String url = Messages.get((String)"subscription.url");
                ApplicationInstance.getActive().enqueueCommand((Command)new BrowserOpenWindowCommand(url, null, null));
            }
            super.onButton(button);
        }

        protected void doLayout() {
            Label label = LabelFactory.create((boolean)true, (boolean)true);
            label.setStyleName("h4");
            Label message = LabelFactory.create((boolean)true, (boolean)true);
            if (this.expiryDate == null) {
                label.setText(Messages.get((String)"subscription.nosubscription"));
                int more = 30 - Days.daysBetween((ReadableInstant)new DateTime((Object)this.installDate), (ReadableInstant)new DateTime()).getDays();
                if (more > 0) {
                    message.setText(Messages.format((String)"subscription.evaluate", (Object[])new Object[]{more}));
                } else {
                    message.setText(Messages.get((String)"subscription.purchase"));
                }
            } else {
                label.setText(Messages.format((String)"subscription.expiredOn", (Object[])new Object[]{DateFormatter.formatDate((Date)this.expiryDate, (boolean)false)}));
                message.setText(Messages.get((String)"subscription.continue"));
            }
            Row row = RowFactory.create((String)"Inset.Large", (Component[])new Component[]{ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{label, message})});
            this.getLayout().add((Component)row);
        }
    }
}

