/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import java.util.Collections;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleTestCase
extends ArchetypeServiceTest {
    @Autowired
    private AppointmentRules appointmentRules;
    private static final int MINUTES_PER_DAY = 1440;

    @Test
    public void testGetIntersectingBoardingEventDuringDaylightSavings() {
        Party boardingSchedule = ScheduleTestHelper.createSchedule((Party)TestHelper.createLocation());
        Entity cageType = ScheduleTestHelper.createCageType((String)TestHelper.randomName((String)"Z-Cage"));
        Schedule schedule = new Schedule((Entity)boardingSchedule, cageType, 0, 1440, 1440, Collections.emptyList(), Collections.emptyList(), this.appointmentRules);
        Act appointment1 = ScheduleTestHelper.createAppointment((Date)TestHelper.getDatetime((String)"2019-10-06 00:00:00"), (Date)TestHelper.getDatetime((String)"2019-10-06 01:00:00"), (Entity)boardingSchedule);
        Act appointment2 = ScheduleTestHelper.createAppointment((Date)TestHelper.getDatetime((String)"2020-04-05 00:00:00"), (Date)TestHelper.getDatetime((String)"2020-04-05 02:00:00"), (Entity)boardingSchedule);
        PropertySet event1 = this.createEvent(appointment1);
        PropertySet event2 = this.createEvent(appointment2);
        schedule.addEvent(event1);
        schedule.addEvent(event2);
        Assert.assertNull((Object)schedule.getIntersectingEvent(TestHelper.getDatetime((String)"2019-10-05 00:00:00"), TestHelper.getDatetime((String)"2019-10-05 00:00:00"), 1440));
        Assert.assertEquals((Object)event1, (Object)schedule.getIntersectingEvent(TestHelper.getDatetime((String)"2019-10-06 00:00:00"), TestHelper.getDatetime((String)"2019-10-06 00:00:00"), 1440));
        Assert.assertNull((Object)schedule.getIntersectingEvent(TestHelper.getDatetime((String)"2019-10-07 00:00:00"), TestHelper.getDatetime((String)"2019-10-07 00:00:00"), 1440));
        Assert.assertNull((Object)schedule.getIntersectingEvent(TestHelper.getDatetime((String)"2020-04-04 00:00:00"), TestHelper.getDatetime((String)"2020-04-04 00:00:00"), 1440));
        Assert.assertEquals((Object)event2, (Object)schedule.getIntersectingEvent(TestHelper.getDatetime((String)"2020-04-05 00:00:00"), TestHelper.getDatetime((String)"2020-04-05 00:00:00"), 1440));
        Assert.assertNull((Object)schedule.getIntersectingEvent(TestHelper.getDatetime((String)"2020-04-06 00:00:00"), TestHelper.getDatetime((String)"2020-04-06 00:00:00"), 1440));
    }

    private PropertySet createEvent(Act appointment) {
        ObjectSet result = new ObjectSet();
        result.set("act.startTime", (Object)appointment.getActivityStartTime());
        result.set("act.endTime", (Object)appointment.getActivityEndTime());
        result.set("act.objectReference", (Object)appointment.getObjectReference());
        return result;
    }
}

