/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.workflow.scheduling.IntersectComparator;

public class IntersectComparatorTestCase
extends ArchetypeServiceTest {
    private AppointmentRules rules;

    @Before
    public void setUp() {
        this.rules = (AppointmentRules)this.applicationContext.getBean(AppointmentRules.class);
    }

    @Test
    public void testIntersectForEventLengthsEqualToSlotSize() {
        PropertySet event1 = this.createEvent("2014-03-01 10:00:00", "2014-03-01 10:15:00");
        PropertySet event2 = this.createEvent("2014-03-01 10:15:00", "2014-03-01 10:30:00");
        PropertySet event3 = this.createEvent("2014-03-01 10:30:00", "2014-03-01 10:45:00");
        IntersectComparator comparator = new IntersectComparator(15, this.rules);
        Assert.assertEquals((long)0L, (long)comparator.compare(event1, event1));
        Assert.assertEquals((long)-1L, (long)comparator.compare(event1, event2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(event1, event3));
        Assert.assertEquals((long)1L, (long)comparator.compare(event2, event1));
        Assert.assertEquals((long)0L, (long)comparator.compare(event2, event2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(event2, event3));
        Assert.assertEquals((long)1L, (long)comparator.compare(event3, event1));
        Assert.assertEquals((long)1L, (long)comparator.compare(event3, event2));
        Assert.assertEquals((long)0L, (long)comparator.compare(event3, event3));
    }

    @Test
    public void testIntersectForEventLengthsSmallerThanSlotSize() {
        PropertySet event1 = this.createEvent("2014-03-01 10:00:00", "2014-03-01 10:05:00");
        PropertySet event2 = this.createEvent("2014-03-01 10:05:00", "2014-03-01 10:10:00");
        PropertySet event3 = this.createEvent("2014-03-01 10:10:00", "2014-03-01 10:15:00");
        PropertySet event4 = this.createEvent("2014-03-01 10:15:00", "2014-03-01 10:20:00");
        IntersectComparator comparator = new IntersectComparator(10, this.rules);
        Assert.assertEquals((long)0L, (long)comparator.compare(event1, event1));
        Assert.assertEquals((long)0L, (long)comparator.compare(event1, event2));
        Assert.assertEquals((long)0L, (long)comparator.compare(event2, event1));
        Assert.assertEquals((long)0L, (long)comparator.compare(event2, event2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(event1, event3));
        Assert.assertEquals((long)-1L, (long)comparator.compare(event1, event4));
        Assert.assertEquals((long)-1L, (long)comparator.compare(event2, event3));
        Assert.assertEquals((long)-1L, (long)comparator.compare(event2, event4));
        Assert.assertEquals((long)0L, (long)comparator.compare(event3, event3));
        Assert.assertEquals((long)0L, (long)comparator.compare(event3, event4));
        Assert.assertEquals((long)0L, (long)comparator.compare(event4, event3));
        Assert.assertEquals((long)0L, (long)comparator.compare(event4, event4));
        Assert.assertEquals((long)1L, (long)comparator.compare(event3, event2));
        Assert.assertEquals((long)1L, (long)comparator.compare(event3, event1));
        Assert.assertEquals((long)1L, (long)comparator.compare(event4, event2));
        Assert.assertEquals((long)1L, (long)comparator.compare(event4, event1));
    }

    @Test
    public void testIntersectForEventLengthsLongerThanSlotSize() {
        PropertySet event1 = this.createEvent("2014-03-01 10:00:00", "2014-03-01 10:10:00");
        PropertySet event2 = this.createEvent("2014-03-01 10:10:00", "2014-03-01 10:20:00");
        PropertySet event3 = this.createEvent("2014-03-01 10:20:00", "2014-03-01 10:30:00");
        IntersectComparator comparator = new IntersectComparator(5, this.rules);
        Assert.assertEquals((long)0L, (long)comparator.compare(event1, event1));
        Assert.assertEquals((long)-1L, (long)comparator.compare(event1, event2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(event1, event3));
        Assert.assertEquals((long)1L, (long)comparator.compare(event2, event1));
        Assert.assertEquals((long)0L, (long)comparator.compare(event2, event2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(event2, event3));
        Assert.assertEquals((long)1L, (long)comparator.compare(event3, event1));
        Assert.assertEquals((long)1L, (long)comparator.compare(event3, event2));
        Assert.assertEquals((long)0L, (long)comparator.compare(event3, event3));
    }

    @Test
    public void testIntersectForPointInTime() {
        IntersectComparator comparator = new IntersectComparator(1440, this.rules);
        PropertySet point = this.createEvent("2019-10-06 00:00:00", "2019-10-06 00:00:00");
        PropertySet short1 = this.createEvent("2019-10-05 00:00:00", "2019-10-05 01:00:00");
        PropertySet short2 = this.createEvent("2019-10-06 00:00:00", "2019-10-06 01:00:00");
        PropertySet short3 = this.createEvent("2019-10-07 00:00:00", "2019-10-07 01:00:00");
        Assert.assertEquals((long)-1L, (long)comparator.compare(short1, point));
        Assert.assertEquals((long)1L, (long)comparator.compare(point, short1));
        Assert.assertEquals((long)0L, (long)comparator.compare(short2, point));
        Assert.assertEquals((long)0L, (long)comparator.compare(point, short2));
        Assert.assertEquals((long)1L, (long)comparator.compare(short3, point));
        Assert.assertEquals((long)-1L, (long)comparator.compare(point, short3));
        PropertySet same1 = this.createEvent("2019-10-05 00:00:00", "2019-10-06 00:00:00");
        PropertySet same2 = this.createEvent("2019-10-06 00:00:00", "2019-10-07 00:00:00");
        PropertySet same3 = this.createEvent("2019-10-07 00:00:00", "2019-10-08 00:00:00");
        Assert.assertEquals((long)-1L, (long)comparator.compare(same1, point));
        Assert.assertEquals((long)1L, (long)comparator.compare(point, same1));
        Assert.assertEquals((long)0L, (long)comparator.compare(same2, point));
        Assert.assertEquals((long)0L, (long)comparator.compare(point, same2));
        Assert.assertEquals((long)1L, (long)comparator.compare(same3, point));
        Assert.assertEquals((long)-1L, (long)comparator.compare(point, same3));
        PropertySet longer1 = this.createEvent("2019-10-04 00:00:00", "2019-10-06 00:00:00");
        PropertySet longer2 = this.createEvent("2019-10-06 00:00:00", "2019-10-07 01:00:00");
        PropertySet longer3 = this.createEvent("2019-10-07 00:00:00", "2019-10-08 01:00:00");
        Assert.assertEquals((long)-1L, (long)comparator.compare(longer1, point));
        Assert.assertEquals((long)1L, (long)comparator.compare(point, longer1));
        Assert.assertEquals((long)0L, (long)comparator.compare(longer2, point));
        Assert.assertEquals((long)0L, (long)comparator.compare(point, longer2));
        Assert.assertEquals((long)1L, (long)comparator.compare(longer3, point));
        Assert.assertEquals((long)-1L, (long)comparator.compare(point, longer3));
    }

    private PropertySet createEvent(String startTime, String endTime) {
        ObjectSet event = new ObjectSet();
        event.set("act.startTime", (Object)TestHelper.getDatetime((String)startTime));
        event.set("act.endTime", (Object)TestHelper.getDatetime((String)endTime));
        return event;
    }
}

