/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.otc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestMerchandiseProductBuilder;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.AbstractCustomerChargeActEditorTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.workflow.otc.OTCChargeEditor;
import org.openvpms.web.workspace.workflow.otc.OTCPaymentEditor;
import org.openvpms.web.workspace.workflow.otc.OTCPaymentTask;
import org.openvpms.web.workspace.workflow.otc.OverTheCounterWorkflowRunner;
import org.openvpms.web.workspace.workflow.otc.TestOTCChargeTask;
import org.springframework.beans.factory.annotation.Autowired;

public class OverTheCounterWorkflowTestCase
extends AbstractCustomerChargeActEditorTest {
    private final List<String> errors = new ArrayList<String>();
    private Context context;
    private User author;
    private Party otc;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.context = new LocalContext();
        this.context.setPractice(this.practiceFactory.getPractice());
        Entity till = this.practiceFactory.createTill();
        this.otc = this.practiceFactory.createOTC();
        Party location = (Party)this.practiceFactory.newLocation().otc(this.otc).tills(new Entity[]{till}).build();
        this.context.setLocation(location);
        this.author = TestHelper.createUser();
        this.context.setUser(this.author);
        this.context.setTill(till);
        this.initErrorHandler(this.errors);
        new AuthenticationContextImpl().setUser(this.author);
    }

    @Test
    public void testWorkflow() {
        OverTheCounterWorkflowRunner workflow = new OverTheCounterWorkflowRunner(this.context);
        workflow.start();
        FinancialAct charge = this.editCharge(workflow);
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getEditDialog(), (String)"ok");
        this.checkCharge((FinancialAct)this.get((IMObject)charge), this.otc, this.author, null, BigDecimal.ZERO, BigDecimal.ONE, "IN_PROGRESS");
        FinancialAct payment = this.editPayment(workflow);
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getEditDialog(), (String)"ok");
        this.checkPayment((FinancialAct)this.get((IMObject)payment), this.otc, this.author, BigDecimal.ONE, "POSTED");
        this.checkCharge((FinancialAct)this.get((IMObject)charge), this.otc, this.author, null, BigDecimal.ZERO, BigDecimal.ONE, "POSTED");
        workflow.print();
        Assert.assertTrue((boolean)this.errors.isEmpty());
        workflow.checkComplete();
    }

    @Test
    public void testCancelCharge() {
        this.checkCancelCharge(false);
    }

    @Test
    public void testCancelChargeByUserClose() {
        this.checkCancelCharge(true);
    }

    @Test
    public void testCancelPayment() {
        this.checkCancelPayment(false);
    }

    @Test
    public void testCancelPaymentByUserClose() {
        this.checkCancelPayment(true);
    }

    @Test
    public void testCancelPaymentWithPendingEFT() {
        this.checkCancelPaymentWithEFT("PENDING");
    }

    @Test
    public void testCancelPaymentWithInProgressEFT() {
        this.checkCancelPaymentWithEFT("IN_PROGRESS");
    }

    @Test
    public void testCancelPaymentWithApprovedEFT() {
        this.checkCancelPaymentWithEFT("APPROVED");
    }

    @Test
    public void testCancelPaymentWithDeclinedEFT() {
        this.checkCancelPaymentWithEFT("DECLINED");
    }

    @Test
    public void testCancelPaymentWithErrorEFT() {
        this.checkCancelPaymentWithEFT("ERROR");
    }

    @Test
    public void testCancelPaymentWithNoTerminalEFT() {
        this.checkCancelPaymentWithEFT("NO_TERMINAL");
    }

    @Test
    public void testPostCharge() {
        OverTheCounterWorkflowRunner workflow = new OverTheCounterWorkflowRunner(this.context);
        workflow.start();
        FinancialAct charge = this.editCharge(workflow);
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getEditDialog(), (String)"ok");
        charge = (FinancialAct)this.get((IMObject)charge);
        this.checkCharge(charge, this.otc, this.author, null, BigDecimal.ZERO, BigDecimal.ONE, "IN_PROGRESS");
        charge.setStatus("POSTED");
        this.save((IMObject)charge);
        Assert.assertTrue((boolean)this.errors.isEmpty());
        FinancialAct payment = this.editPayment(workflow);
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getEditDialog(), (String)"ok");
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Failed to save object. It may have been changed by another user.", (Object)this.errors.get(0));
        workflow.checkComplete();
        this.checkCharge((FinancialAct)this.get((IMObject)charge), this.otc, this.author, null, BigDecimal.ZERO, BigDecimal.ONE, "POSTED");
        this.checkPayment((FinancialAct)this.get((IMObject)payment), this.otc, this.author, BigDecimal.ONE, "IN_PROGRESS");
    }

    @Test
    public void testPostPayment() {
        OverTheCounterWorkflowRunner workflow = new OverTheCounterWorkflowRunner(this.context);
        workflow.start();
        FinancialAct charge = this.editCharge(workflow);
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getEditDialog(), (String)"ok");
        charge = (FinancialAct)this.get((IMObject)charge);
        this.checkCharge((FinancialAct)this.get((IMObject)charge), this.otc, this.author, null, BigDecimal.ZERO, BigDecimal.ONE, "IN_PROGRESS");
        Assert.assertTrue((boolean)this.errors.isEmpty());
        FinancialAct payment = this.editPayment(workflow);
        payment = (FinancialAct)this.get((IMObject)payment);
        payment.setStatus("POSTED");
        this.save((IMObject)payment);
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getEditDialog(), (String)"ok");
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Failed to save object. It may have been changed by another user.", (Object)this.errors.get(0));
        workflow.checkComplete();
        this.checkCharge((FinancialAct)this.get((IMObject)charge), this.otc, this.author, null, BigDecimal.ZERO, BigDecimal.ONE, "IN_PROGRESS");
        this.checkPayment((FinancialAct)this.get((IMObject)payment), this.otc, this.author, BigDecimal.ONE, "POSTED");
    }

    protected void checkCharge(FinancialAct charge, Party customer, User author, User clinician, BigDecimal tax, BigDecimal total, String status) {
        Assert.assertNotNull((Object)charge);
        IMObjectBean bean = this.getBean((IMObject)charge);
        Assert.assertEquals((Object)customer.getObjectReference(), (Object)bean.getTargetRef("customer"));
        Assert.assertEquals((Object)author.getObjectReference(), (Object)charge.getCreatedBy());
        if (bean.hasNode("clinician") && bean.getNode("clinician").getMaxCardinality() != 0) {
            Assert.assertEquals((Object)clinician.getObjectReference(), (Object)bean.getTargetRef("clinician"));
        }
        this.checkEquals(tax, bean.getBigDecimal("tax"));
        this.checkEquals(total, bean.getBigDecimal("amount"));
        Assert.assertEquals((Object)status, (Object)charge.getStatus());
    }

    protected void checkPayment(FinancialAct payment, Party customer, User author, BigDecimal total, String status) {
        Assert.assertNotNull((Object)payment);
        IMObjectBean bean = this.getBean((IMObject)payment);
        Assert.assertEquals((Object)customer.getObjectReference(), (Object)bean.getTargetRef("customer"));
        Assert.assertEquals((Object)author.getObjectReference(), (Object)payment.getCreatedBy());
        this.checkEquals(total, bean.getBigDecimal("amount"));
        Assert.assertEquals((Object)status, (Object)payment.getStatus());
    }

    private void checkCancelPaymentWithEFT(final String status) {
        OverTheCounterWorkflowRunner.TestOTCWorkflow eftWorkflow = new OverTheCounterWorkflowRunner.TestOTCWorkflow(this.context, new HelpContext("foo", null)){

            protected EditIMObjectTask createPaymentTask() {
                return new OTCPaymentTask(){

                    protected void create(TaskContext context) {
                        FinancialAct charge = (FinancialAct)context.getObject("act.customerAccountChargesCounter");
                        Entity terminal = !status.equals("NO_TERMINAL") ? OverTheCounterWorkflowTestCase.this.practiceFactory.createEFTPOSTerminal() : null;
                        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)OverTheCounterWorkflowTestCase.this.accountFactory.newPayment().customer(context.getCustomer())).location(context.getLocation())).till(context.getTill())).eft().addTransaction(status, terminal)).amount(charge.getTotal())).add()).status("IN_PROGRESS")).build();
                        context.addObject((IMObject)payment);
                        super.edit(context);
                    }
                };
            }
        };
        OverTheCounterWorkflowRunner workflow = new OverTheCounterWorkflowRunner(eftWorkflow);
        workflow.start();
        FinancialAct charge = this.editCharge(workflow);
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getEditDialog(), (String)"ok");
        this.checkCharge((FinancialAct)this.get((IMObject)charge), this.otc, this.author, null, BigDecimal.ZERO, BigDecimal.ONE, "IN_PROGRESS");
        OTCPaymentEditor paymentEditor = workflow.getPaymentEditor();
        Assert.assertTrue((boolean)paymentEditor.isValid());
        FinancialAct payment = paymentEditor.getObject();
        this.checkPayment(payment, this.otc, this.author, BigDecimal.ONE, "IN_PROGRESS");
        this.checkPayment((FinancialAct)this.get((IMObject)payment), this.otc, this.author, BigDecimal.ONE, "IN_PROGRESS");
        EchoTestHelper.cancelDialog((PopupDialog)workflow.getEditDialog(), (boolean)false);
        ConfirmationDialog dialog = (ConfirmationDialog)EchoTestHelper.getWindowPane(ConfirmationDialog.class);
        if ("PENDING".equals(status) || "IN_PROGRESS".equals(status) || "APPROVED".equals(status)) {
            Assert.assertEquals((Object)"This Payment was saved but has not been finalised.\n\nCancel editing?", (Object)dialog.getMessage());
            EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"yes");
            Assert.assertEquals((long)1L, (long)this.errors.size());
            if ("APPROVED".equals(status)) {
                Assert.assertEquals((Object)"Cannot delete Payment. It has an approved EFTPOS transaction.", (Object)this.errors.get(0));
            } else {
                Assert.assertEquals((Object)"Cannot delete Payment. It has an outstanding EFTPOS transaction.", (Object)this.errors.get(0));
            }
            this.checkCharge((FinancialAct)this.get((IMObject)charge), this.otc, this.author, null, BigDecimal.ZERO, BigDecimal.ONE, "IN_PROGRESS");
            this.checkPayment((FinancialAct)this.get((IMObject)payment), this.otc, this.author, BigDecimal.ONE, "IN_PROGRESS");
        } else {
            Assert.assertEquals((Object)"This Payment has been saved.\n\nDo you want to delete it?", (Object)dialog.getMessage());
            EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"yes");
            Assert.assertNull((Object)this.get((IMObject)charge));
            Assert.assertNull((Object)this.get((IMObject)payment));
            Assert.assertEquals((long)0L, (long)this.errors.size());
        }
        workflow.checkComplete();
    }

    private void checkCancelCharge(boolean userClose) {
        OverTheCounterWorkflowRunner workflow = new OverTheCounterWorkflowRunner(this.context);
        workflow.start();
        FinancialAct charge = this.editCharge(workflow);
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getEditDialog(), (String)"ok");
        EchoTestHelper.cancelDialog((PopupDialog)workflow.getEditDialog(), (boolean)userClose);
        Assert.assertNull((Object)this.get((IMObject)charge));
        workflow.checkComplete();
    }

    private void checkCancelPayment(boolean userClose) {
        OverTheCounterWorkflowRunner workflow = new OverTheCounterWorkflowRunner(this.context);
        workflow.start();
        FinancialAct charge = this.editCharge(workflow);
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getEditDialog(), (String)"ok");
        this.checkCharge((FinancialAct)this.get((IMObject)charge), this.otc, this.author, null, BigDecimal.ZERO, BigDecimal.ONE, "IN_PROGRESS");
        FinancialAct payment = this.editPayment(workflow);
        this.checkPayment((FinancialAct)this.get((IMObject)payment), this.otc, this.author, BigDecimal.ONE, "IN_PROGRESS");
        EchoTestHelper.cancelDialog((PopupDialog)workflow.getEditDialog(), (boolean)userClose);
        ConfirmationDialog dialog = (ConfirmationDialog)EchoTestHelper.getWindowPane(ConfirmationDialog.class);
        Assert.assertEquals((Object)"This Payment was saved but has not been finalised.\n\nCancel editing?", (Object)dialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"yes");
        Assert.assertNull((Object)this.get((IMObject)charge));
        Assert.assertNull((Object)this.get((IMObject)payment));
        workflow.checkComplete();
    }

    private FinancialAct editCharge(OverTheCounterWorkflowRunner workflow) {
        Product product = (Product)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(1)).build();
        TestOTCChargeTask chargeTask = workflow.getChargeTask();
        OTCChargeEditor chargeEditor = workflow.getChargeEditor();
        this.addItem((CustomerChargeActEditor)chargeEditor, null, product, BigDecimal.ONE, chargeTask.getQueue());
        EchoTestHelper.fireDialogButton((PopupDialog)chargeTask.getEditDialog(), (String)"apply");
        FinancialAct charge = (FinancialAct)this.get((IMObject)chargeEditor.getObject());
        Assert.assertNotNull((Object)charge);
        this.checkCharge(charge, this.otc, this.author, null, BigDecimal.ZERO, BigDecimal.ONE);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)charge.getStatus());
        return charge;
    }

    private FinancialAct editPayment(OverTheCounterWorkflowRunner workflow) {
        OTCPaymentTask paymentTask = workflow.getPaymentTask();
        OTCPaymentEditor paymentEditor = workflow.getPaymentEditor();
        PaymentItemEditor paymentItemEditor = paymentEditor.getUnsavedItem("act.customerAccountPaymentCash");
        paymentItemEditor.getProperty("amount").setValue((Object)BigDecimal.ONE);
        Assert.assertTrue((boolean)paymentEditor.isValid());
        EchoTestHelper.fireDialogButton((PopupDialog)paymentTask.getEditDialog(), (String)"apply");
        FinancialAct payment = (FinancialAct)this.get((IMObject)paymentEditor.getObject());
        Assert.assertNotNull((Object)payment);
        this.checkPayment(payment, this.otc, this.author, BigDecimal.ONE, "IN_PROGRESS");
        return payment;
    }
}

