/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.investigation;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.laboratory.LaboratoryTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryTestHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.investigation.InvestigationsQuery;

public class InvestigationsQueryTestCase
extends AbstractAppTest {
    @Test
    public void testQueryByInvestigationType() {
        Party patient = TestHelper.createPatient();
        Entity type1 = LaboratoryTestHelper.createInvestigationType();
        Entity type2 = LaboratoryTestHelper.createInvestigationType();
        DocumentAct investigation1 = PatientTestHelper.createInvestigation((Party)patient, (Entity)type1);
        DocumentAct investigation2 = PatientTestHelper.createInvestigation((Party)patient, (Entity)type2);
        InvestigationsQuery query = this.createQuery(new LocalContext());
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation2});
        query.setInvestigationType(type1);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation2});
        query.setInvestigationType(type2);
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation1});
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation2});
        query.setInvestigationType(null);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation2});
    }

    @Test
    public void testQueryByClinician() {
        Party patient = TestHelper.createPatient();
        User clinician1 = TestHelper.createClinician();
        User clinician2 = TestHelper.createClinician();
        Entity type = LaboratoryTestHelper.createInvestigationType();
        DocumentAct investigation1 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician1, (Entity)type);
        DocumentAct investigation2 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician2, (Entity)type);
        InvestigationsQuery query = this.createQuery(new LocalContext());
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation2});
        query.setClinician(clinician1);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation2});
        query.setClinician(clinician2);
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation1});
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation2});
        query.setClinician(null);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation2});
    }

    @Test
    public void testQueryByLocation() {
        LocalContext context = new LocalContext();
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        Entity type = LaboratoryTestHelper.createInvestigationType();
        Party location1 = TestHelper.createLocation();
        Party location2 = TestHelper.createLocation();
        Party location3 = TestHelper.createLocation();
        Party practice = this.createPractice(location1, location2);
        context.setPractice(practice);
        context.setUser(clinician);
        DocumentAct investigation1 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Party)location1, (Entity)type);
        DocumentAct investigation2 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Party)location2, (Entity)type);
        DocumentAct investigation3 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Party)location3, (Entity)type);
        DocumentAct investigation4 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Entity)type);
        InvestigationsQuery query = this.createQuery(context);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation2, investigation4});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation3});
        query.setLocation(location1);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation4});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation2, investigation3});
        query.setLocation(location2);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation2, investigation4});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation1, investigation3});
        query.setLocation(null);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation2, investigation4});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation3});
    }

    @Test
    public void testQueryByLocationForRestrictedUser() {
        LocalContext context = new LocalContext();
        Party patient = TestHelper.createPatient();
        Entity type = LaboratoryTestHelper.createInvestigationType();
        Party location1 = TestHelper.createLocation();
        Party location2 = TestHelper.createLocation();
        Party practice = this.createPractice(location1, location2);
        User clinician = this.createClinician(location1);
        context.setPractice(practice);
        context.setUser(clinician);
        DocumentAct investigation1 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Party)location1, (Entity)type);
        DocumentAct investigation2 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Party)location2, (Entity)type);
        DocumentAct investigation3 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Entity)type);
        InvestigationsQuery query = this.createQuery(context);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation3});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation2});
        query.setLocation(location1);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation3});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation2});
        query.setLocation(location2);
        Assert.assertNull((Object)query.getLocation());
        query.setLocation(null);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation3});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation2});
    }

    @Test
    public void testQueryByLocationForSingleLocation() {
        LocalContext context = new LocalContext();
        Party patient = TestHelper.createPatient();
        Entity type = LaboratoryTestHelper.createInvestigationType();
        Party location1 = TestHelper.createLocation();
        Party location2 = TestHelper.createLocation();
        Party practice = this.createPractice(location1);
        User clinician = this.createClinician(location1);
        context.setPractice(practice);
        context.setUser(clinician);
        DocumentAct investigation1 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Party)location1, (Entity)type);
        DocumentAct investigation2 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Party)location2, (Entity)type);
        DocumentAct investigation3 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Entity)type);
        InvestigationsQuery query = this.createQuery(context);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation3});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation2});
        query.setLocation(location1);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation3});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation2});
        query.setLocation(null);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation3});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation2});
    }

    @Test
    public void testQueryByLocationAndInvestigationType() {
        LocalContext context = new LocalContext();
        Party patient = TestHelper.createPatient();
        Entity type1 = LaboratoryTestHelper.createInvestigationType();
        Entity type2 = LaboratoryTestHelper.createInvestigationType();
        Party location1 = TestHelper.createLocation();
        Party location2 = TestHelper.createLocation();
        Party practice = this.createPractice(location1, location2);
        User clinician = this.createClinician(location1);
        context.setPractice(practice);
        context.setUser(clinician);
        DocumentAct investigation1 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Party)location1, (Entity)type1);
        DocumentAct investigation2 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Party)location1, (Entity)type2);
        DocumentAct investigation3 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Party)location2, (Entity)type1);
        DocumentAct investigation4 = PatientTestHelper.createInvestigation((Party)patient, (User)clinician, (Entity)type1);
        InvestigationsQuery query = this.createQuery(context);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation2, investigation4});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation3});
        query.setLocation(location1);
        query.setInvestigationType(type1);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation4});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation2, investigation3});
        query.setLocation(location2);
        Assert.assertNull((Object)query.getLocation());
        query.setLocation(null);
        query.setInvestigationType(null);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{investigation1, investigation2, investigation4});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{investigation3});
    }

    @Test
    public void testQueryByStatus() {
        Party patient = TestHelper.createPatient();
        Entity type = LaboratoryTestHelper.createInvestigationType();
        Act inProgress1 = this.createInvestigation(patient, type, "IN_PROGRESS", "PENDING");
        Act inProgress2 = this.createInvestigation(patient, type, "IN_PROGRESS", "CONFIRM");
        Act inProgress3 = this.createInvestigation(patient, type, "IN_PROGRESS", "CONFIRM_DEFERRED");
        Act inProgress4 = this.createInvestigation(patient, type, "IN_PROGRESS", "SENT");
        Act inProgress5 = this.createInvestigation(patient, type, "IN_PROGRESS", "ERROR");
        Act inProgress6 = this.createInvestigation(patient, type, "IN_PROGRESS", "WAITING_FOR_SAMPLE");
        Act inProgress7 = this.createInvestigation(patient, type, "IN_PROGRESS", "PARTIAL_RESULTS");
        Act inProgress8 = this.createInvestigation(patient, type, "IN_PROGRESS", "RECEIVED");
        Act inProgress9 = this.createInvestigation(patient, type, "IN_PROGRESS", "REVIEWED");
        Act posted1 = this.createInvestigation(patient, type, "POSTED", "PENDING");
        Act posted2 = this.createInvestigation(patient, type, "POSTED", "CONFIRM");
        Act posted3 = this.createInvestigation(patient, type, "POSTED", "CONFIRM_DEFERRED");
        Act posted4 = this.createInvestigation(patient, type, "POSTED", "SENT");
        Act posted5 = this.createInvestigation(patient, type, "POSTED", "ERROR");
        Act posted6 = this.createInvestigation(patient, type, "POSTED", "WAITING_FOR_SAMPLE");
        Act posted7 = this.createInvestigation(patient, type, "POSTED", "PARTIAL_RESULTS");
        Act posted8 = this.createInvestigation(patient, type, "POSTED", "RECEIVED");
        Act posted9 = this.createInvestigation(patient, type, "POSTED", "REVIEWED");
        Act cancelled1 = this.createInvestigation(patient, type, "CANCELLED", "PENDING");
        Act cancelled2 = this.createInvestigation(patient, type, "CANCELLED", "CONFIRM");
        Act cancelled3 = this.createInvestigation(patient, type, "CANCELLED", "CONFIRM_DEFERRED");
        Act cancelled4 = this.createInvestigation(patient, type, "CANCELLED", "SENT");
        Act cancelled5 = this.createInvestigation(patient, type, "CANCELLED", "ERROR");
        Act cancelled6 = this.createInvestigation(patient, type, "CANCELLED", "WAITING_FOR_SAMPLE");
        Act cancelled7 = this.createInvestigation(patient, type, "CANCELLED", "PARTIAL_RESULTS");
        Act cancelled8 = this.createInvestigation(patient, type, "CANCELLED", "RECEIVED");
        Act cancelled9 = this.createInvestigation(patient, type, "CANCELLED", "REVIEWED");
        InvestigationsQuery query = this.createQuery(new LocalContext());
        query.setStatus(null);
        query.setOrderStatus(null);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{inProgress1, inProgress2, inProgress3, inProgress4, inProgress5, inProgress6, inProgress7, inProgress8, inProgress9, posted1, posted2, posted3, posted4, posted5, posted6, posted7, posted8, posted9, cancelled1, cancelled2, cancelled3, cancelled4, cancelled5, cancelled6, cancelled7, cancelled8, cancelled9});
        query.setOrderStatus("CONFIRM");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{inProgress2, inProgress3, posted2, posted3});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{inProgress1, inProgress4, inProgress5, inProgress6, inProgress7, inProgress8, inProgress9, posted1, posted4, posted5, posted6, posted7, posted8, posted9, cancelled1, cancelled2, cancelled3, cancelled4, cancelled5, cancelled6, cancelled7, cancelled8, cancelled9});
        query.setOrderStatus("INCOMPLETE");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{inProgress1, inProgress2, inProgress3, inProgress4, inProgress5, inProgress6, inProgress7, inProgress8, posted1, posted2, posted3, posted4, posted5, posted6, posted7, posted8});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{inProgress9, posted9, cancelled1, cancelled2, cancelled3, cancelled4, cancelled5, cancelled6, cancelled7, cancelled8, cancelled9});
        query.setOrderStatus("REVIEWED");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Act[]{inProgress9, posted9, cancelled9});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Act[]{inProgress1, inProgress2, inProgress3, inProgress4, inProgress5, inProgress6, inProgress7, inProgress8, posted1, posted2, posted3, posted4, posted5, posted6, posted7, posted8, cancelled1, cancelled2, cancelled3, cancelled4, cancelled5, cancelled6, cancelled7, cancelled8});
    }

    private Act createInvestigation(Party patient, Entity type, String status, String resultStatus) {
        DocumentAct act = PatientTestHelper.createInvestigation((Party)patient, (Entity)type);
        act.setStatus(status);
        act.setStatus2(resultStatus);
        this.save((IMObject)act);
        return act;
    }

    private InvestigationsQuery createQuery(LocalContext context) {
        DefaultLayoutContext layout = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        return new InvestigationsQuery((LayoutContext)layout);
    }

    private Party createPractice(Party ... locations) {
        Party practice = (Party)this.create("party.organisationPractice", Party.class);
        IMObjectBean bean = this.getBean((IMObject)practice);
        for (Party location : locations) {
            bean.addTarget("locations", (IMObject)location, "practice");
        }
        return practice;
    }

    private User createClinician(Party ... locations) {
        User clinician = TestHelper.createClinician();
        IMObjectBean bean = this.getBean((IMObject)clinician);
        for (Party location : locations) {
            bean.addTarget("locations", (IMObject)location);
        }
        return clinician;
    }
}

