/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.consult;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;

public abstract class AbstractGetConsultInvoiceTaskTest
extends AbstractAppTest {
    private Party customer;
    private Party patient1;
    private Act event;

    @Before
    public void setUp() {
        super.setUp();
        this.customer = TestHelper.createCustomer();
        this.patient1 = TestHelper.createPatient((Party)this.customer);
        this.event = PatientTestHelper.createEvent((Party)this.patient1);
    }

    @Test
    public void testMissingInvoice() {
        SynchronousTask task = this.createGetInvoiceTask();
        TaskContext context = this.createContext();
        task.execute(context);
        Assert.assertNull((Object)context.getObject("act.customerAccountChargesInvoice"));
    }

    @Test
    public void testInvoiceLinkedToEvent() {
        Product product = TestHelper.createProduct();
        List acts1 = FinancialTestHelper.createChargesInvoice((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Party)this.patient1, (Product)product, (String)"IN_PROGRESS");
        List acts2 = FinancialTestHelper.createChargesInvoice((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Party)this.patient1, (Product)product, (String)"IN_PROGRESS");
        FinancialAct invoice1 = (FinancialAct)acts1.get(0);
        FinancialAct invoice2 = (FinancialAct)acts2.get(0);
        invoice1.setActivityStartTime(DateRules.getYesterday());
        invoice2.setActivityStartTime(DateRules.getToday());
        this.save(acts1);
        this.save(acts2);
        FinancialAct item1 = (FinancialAct)acts1.get(1);
        this.addToEvent(this.event, item1);
        SynchronousTask task = this.createGetInvoiceTask();
        TaskContext context1 = this.createContext();
        task.execute(context1);
        Assert.assertEquals((Object)invoice1, (Object)context1.getObject("act.customerAccountChargesInvoice"));
        invoice1.setStatus("POSTED");
        this.save((IMObject)invoice1);
        TaskContext context2 = this.createContext();
        task.execute(context2);
        Assert.assertEquals((Object)invoice2, (Object)context2.getObject("act.customerAccountChargesInvoice"));
        invoice2.setStatus("POSTED");
        this.save((IMObject)invoice2);
        TaskContext context3 = this.createContext();
        task.execute(context3);
        Assert.assertEquals((Object)invoice1, (Object)context3.getObject("act.customerAccountChargesInvoice"));
        FinancialAct item2 = (FinancialAct)acts2.get(1);
        this.addToEvent(this.event, item2);
        TaskContext context4 = this.createContext();
        task.execute(context4);
        Assert.assertEquals((Object)invoice2, (Object)context4.getObject("act.customerAccountChargesInvoice"));
    }

    protected Party getCustomer() {
        return this.customer;
    }

    protected void addToEvent(Act event, FinancialAct item) {
        IMObjectBean bean = this.getBean((IMObject)event);
        bean.addTarget("chargeItems", (IMObject)item);
        this.save((IMObject[])new Act[]{event, item});
    }

    protected abstract SynchronousTask createGetInvoiceTask();

    private TaskContext createContext() {
        DefaultTaskContext context = new DefaultTaskContext(new HelpContext("foo", null));
        context.addObject((IMObject)this.customer);
        context.addObject((IMObject)this.patient1);
        context.addObject((IMObject)this.event);
        return context;
    }
}

