/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.charge.AbstractCustomerChargeActEditorTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.TestChargeEditor;
import org.openvpms.web.workspace.workflow.checkout.BoardingInvoicer;
import org.openvpms.web.workspace.workflow.checkout.BoardingTestHelper;
import org.openvpms.web.workspace.workflow.checkout.Visit;
import org.openvpms.web.workspace.workflow.checkout.Visits;
import org.springframework.beans.factory.annotation.Autowired;

public class BoardingInvoicerTestCase
extends AbstractCustomerChargeActEditorTest {
    @Autowired
    private PatientRules patientRules;
    @Autowired
    private AppointmentRules appointmentRules;
    private Party customer;
    private Party patient1;
    private Party patient2;
    private Party location;
    private User author;
    private User clinician;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.customer = TestHelper.createCustomer();
        this.patient1 = TestHelper.createPatient((Party)this.customer);
        this.patient2 = TestHelper.createPatient((Party)this.customer);
        this.location = TestHelper.createLocation();
        this.author = TestHelper.createClinician();
        this.clinician = TestHelper.createClinician();
        new AuthenticationContextImpl().setUser(this.author);
    }

    @Test
    public void testInvoiceSingleDay() {
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal firstPetProductDayPrice = new BigDecimal("9.09");
        BigDecimal firstPetProductDayPriceIncTax = BigDecimal.TEN;
        BigDecimal firstPetProductNightPrice = new BigDecimal("18.18");
        BigDecimal secondPetProductDayPrice = new BigDecimal("4.54");
        BigDecimal secondPetProductDayPriceIncTax = new BigDecimal("4.99");
        BigDecimal secondPetProductNightPrice = new BigDecimal("13.64");
        Product firstPetProductDay = ProductTestHelper.createService((BigDecimal)firstPetProductDayPrice, (BigDecimal)unitPrice);
        Product firstPetProductNight = ProductTestHelper.createService((BigDecimal)firstPetProductNightPrice, (BigDecimal)unitPrice);
        Product secondPetProductDay = ProductTestHelper.createService((BigDecimal)secondPetProductDayPrice, (BigDecimal)unitPrice);
        Product secondPetProductNight = ProductTestHelper.createService((BigDecimal)secondPetProductNightPrice, (BigDecimal)unitPrice);
        Entity cageType = ScheduleTestHelper.createCageType((String)"Z Test Cage", (Product)firstPetProductDay, (Product)firstPetProductNight, (Product)secondPetProductDay, (Product)secondPetProductNight);
        Party schedule = ScheduleTestHelper.createSchedule((Party)this.location, (Entity)cageType);
        Visits visits = new Visits(this.customer, this.appointmentRules, this.patientRules, this.getArchetypeService());
        Visit visit1 = BoardingTestHelper.createVisit("2016-03-24 10:00:00", "2016-03-24 17:00:00", (Entity)schedule, this.customer, this.patient1, visits);
        Visit visit2 = BoardingTestHelper.createVisit("2016-03-24 10:00:00", "2016-03-24 17:00:00", (Entity)schedule, this.customer, this.patient2, visits);
        visits.add(visit1);
        visits.add(visit2);
        visit1.setFirstPet(true);
        visit2.setFirstPet(false);
        FinancialAct invoice = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createEditor(invoice);
        BoardingInvoicer invoicer = new BoardingInvoicer();
        invoicer.invoice(visits, (CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        invoice = (FinancialAct)this.get((IMObject)invoice);
        IMObjectBean bean = this.getBean((IMObject)invoice);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)2L, (long)items.size());
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient1, firstPetProductDay, null, -1, this.author, this.clinician, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, unitPriceIncTax, BigDecimal.ZERO, firstPetProductDayPriceIncTax, BigDecimal.ZERO, new BigDecimal("1.818"), firstPetProductDayPriceIncTax.add(unitPriceIncTax), true, visit1.getEvent(), 0);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient2, secondPetProductDay, null, -1, this.author, this.clinician, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, unitPriceIncTax, BigDecimal.ZERO, secondPetProductDayPriceIncTax, BigDecimal.ZERO, new BigDecimal("1.363"), secondPetProductDayPriceIncTax.add(unitPriceIncTax), true, visit2.getEvent(), 0);
    }

    @Test
    public void testInvoiceMultipleDays() {
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal firstPetProductDayPrice = new BigDecimal("9.09");
        BigDecimal firstPetProductNightPrice = new BigDecimal("18.18");
        BigDecimal firstPetProductNightPriceIncTax = BigDecimal.valueOf(20L);
        BigDecimal secondPetProductDayPrice = new BigDecimal("4.54");
        BigDecimal secondPetProductNightPrice = new BigDecimal("13.64");
        BigDecimal secondPetProductNightPriceIncTax = BigDecimal.valueOf(15L);
        BigDecimal lateCheckoutProductPrice = new BigDecimal("9.09");
        BigDecimal lateCheckoutProductPriceIncTax = BigDecimal.TEN;
        Product firstPetProductDay = ProductTestHelper.createService((BigDecimal)firstPetProductDayPrice, (BigDecimal)unitPrice);
        Product firstPetProductNight = ProductTestHelper.createService((BigDecimal)firstPetProductNightPrice, (BigDecimal)unitPrice);
        Product secondPetProductDay = ProductTestHelper.createService((BigDecimal)secondPetProductDayPrice, (BigDecimal)unitPrice);
        Product secondPetProductNight = ProductTestHelper.createService((BigDecimal)secondPetProductNightPrice, (BigDecimal)unitPrice);
        Product lateCheckoutProduct = ProductTestHelper.createService((BigDecimal)lateCheckoutProductPrice, (BigDecimal)BigDecimal.ZERO);
        Entity cageType = ScheduleTestHelper.createCageType((String)"Z Test Cage", (Product)firstPetProductDay, (Product)firstPetProductNight, (Product)secondPetProductDay, (Product)secondPetProductNight, (Time)Time.valueOf("18:00:00"), (Product)lateCheckoutProduct);
        Party schedule = ScheduleTestHelper.createSchedule((Party)this.location, (Entity)cageType);
        Visits visits = new Visits(this.customer, this.appointmentRules, this.patientRules, this.getArchetypeService());
        Visit visit1 = BoardingTestHelper.createVisit("2016-03-24 10:00:00", "2016-03-29 17:45:00", (Entity)schedule, this.customer, this.patient1, visits);
        Visit visit2 = BoardingTestHelper.createVisit("2016-03-24 10:00:00", "2016-03-29 18:30:00", (Entity)schedule, this.customer, this.patient2, visits);
        visits.add(visit1);
        visits.add(visit2);
        visit1.setFirstPet(true);
        visit2.setFirstPet(false);
        FinancialAct invoice = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createEditor(invoice);
        BoardingInvoicer invoicer = new BoardingInvoicer();
        invoicer.invoice(visits, (CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        invoice = (FinancialAct)this.get((IMObject)invoice);
        IMObjectBean bean = this.getBean((IMObject)invoice);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)3L, (long)items.size());
        BigDecimal quantity = BigDecimal.valueOf(5L);
        BigDecimal unitPriceXQty = unitPriceIncTax.multiply(quantity);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient1, firstPetProductNight, null, -1, this.author, this.clinician, BigDecimal.ZERO, quantity, BigDecimal.ZERO, unitPriceIncTax, BigDecimal.ZERO, firstPetProductNightPriceIncTax, BigDecimal.ZERO, new BigDecimal("6.364"), firstPetProductNightPriceIncTax.add(unitPriceXQty), true, visit1.getEvent(), 0);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient2, secondPetProductNight, null, -1, this.author, this.clinician, BigDecimal.ZERO, quantity, BigDecimal.ZERO, unitPriceIncTax, BigDecimal.ZERO, secondPetProductNightPriceIncTax, BigDecimal.ZERO, new BigDecimal("5.909"), secondPetProductNightPriceIncTax.add(unitPriceXQty), true, visit2.getEvent(), 0);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient2, lateCheckoutProduct, null, -1, this.author, this.clinician, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, lateCheckoutProductPriceIncTax, BigDecimal.ZERO, new BigDecimal("0.909"), lateCheckoutProductPriceIncTax, true, visit2.getEvent(), 0);
    }

    @Test
    public void testInvoiceMultipleDaysWithTemplateProduct() {
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal price1 = new BigDecimal("9.09");
        BigDecimal price1IncTax = BigDecimal.TEN;
        BigDecimal price2 = new BigDecimal("18.18");
        BigDecimal price2IncTax = BigDecimal.valueOf(20L);
        Product template = ProductTestHelper.createTemplate((String)"Z Boarding Template");
        Product product1 = ProductTestHelper.createService((BigDecimal)price1, (BigDecimal)unitPrice);
        Product product2 = ProductTestHelper.createService((BigDecimal)price2, (BigDecimal)unitPrice);
        ProductTestHelper.addInclude((Product)template, (Product)product1, (int)1, (int)1);
        ProductTestHelper.addInclude((Product)template, (Product)product2, (int)1, (int)2);
        Entity cageType = ScheduleTestHelper.createCageType((String)"Z Test Cage", (Product)template, null, null, null);
        Party schedule = ScheduleTestHelper.createSchedule((Party)this.location, (Entity)cageType);
        Visits visits = new Visits(this.customer, this.appointmentRules, this.patientRules, this.getArchetypeService());
        Visit visit = BoardingTestHelper.createVisit("2016-03-24 10:00:00", "2016-03-29 17:45:00", (Entity)schedule, this.customer, this.patient1, visits);
        visits.add(visit);
        visit.setFirstPet(true);
        FinancialAct invoice = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createEditor(invoice);
        BoardingInvoicer invoicer = new BoardingInvoicer();
        invoicer.invoice(visits, (CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        invoice = (FinancialAct)this.get((IMObject)invoice);
        IMObjectBean bean = this.getBean((IMObject)invoice);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)2L, (long)items.size());
        BigDecimal quantity = BigDecimal.valueOf(5L);
        BigDecimal unitPriceXQty = unitPriceIncTax.multiply(quantity);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient1, product1, template, 0, this.author, this.clinician, quantity, quantity, BigDecimal.ZERO, unitPriceIncTax, BigDecimal.ZERO, price1IncTax, BigDecimal.ZERO, new BigDecimal("5.455"), price1IncTax.add(unitPriceXQty), true, visit.getEvent(), 0);
        BigDecimal two = BigDecimal.valueOf(2L);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient1, product2, template, 0, this.author, this.clinician, quantity, quantity.multiply(two), BigDecimal.ZERO, unitPriceIncTax, BigDecimal.ZERO, price2IncTax, BigDecimal.ZERO, new BigDecimal("10.909"), price2IncTax.add(unitPriceXQty.multiply(two)), true, visit.getEvent(), 0);
    }

    @Test
    public void testInvoiceOvernightLessThan24Hours() {
        BigDecimal unitPrice = new BigDecimal("9.09");
        BigDecimal unitPriceIncTax = BigDecimal.TEN;
        BigDecimal firstPetProductDayPrice = new BigDecimal("9.09");
        BigDecimal firstPetProductNightPrice = new BigDecimal("18.18");
        BigDecimal firstPetProductNightPriceIncTax = new BigDecimal("20.00");
        BigDecimal secondPetProductDayPrice = new BigDecimal("4.54");
        BigDecimal secondPetProductNightPrice = new BigDecimal("13.64");
        BigDecimal secondPetProductNightPriceIncTax = new BigDecimal("15.00");
        Product firstPetProductDay = ProductTestHelper.createService((BigDecimal)firstPetProductDayPrice, (BigDecimal)unitPrice);
        Product firstPetProductNight = ProductTestHelper.createService((BigDecimal)firstPetProductNightPrice, (BigDecimal)unitPrice);
        Product secondPetProductDay = ProductTestHelper.createService((BigDecimal)secondPetProductDayPrice, (BigDecimal)unitPrice);
        Product secondPetProductNight = ProductTestHelper.createService((BigDecimal)secondPetProductNightPrice, (BigDecimal)unitPrice);
        Entity cageType = ScheduleTestHelper.createCageType((String)"Z Test Cage", (Product)firstPetProductDay, (Product)firstPetProductNight, (Product)secondPetProductDay, (Product)secondPetProductNight);
        Party schedule = ScheduleTestHelper.createSchedule((Party)this.location, (Entity)cageType);
        Visits visits = new Visits(this.customer, this.appointmentRules, this.patientRules, this.getArchetypeService());
        Visit visit1 = BoardingTestHelper.createVisit("2016-03-24 10:00:00", "2016-03-25 09:00:00", (Entity)schedule, this.customer, this.patient1, visits);
        Visit visit2 = BoardingTestHelper.createVisit("2016-03-24 10:00:00", "2016-03-25 09:00:00", (Entity)schedule, this.customer, this.patient2, visits);
        visits.add(visit1);
        visits.add(visit2);
        visit1.setFirstPet(true);
        visit2.setFirstPet(false);
        FinancialAct invoice = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createEditor(invoice);
        BoardingInvoicer invoicer = new BoardingInvoicer();
        invoicer.invoice(visits, (CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        invoice = (FinancialAct)this.get((IMObject)invoice);
        IMObjectBean bean = this.getBean((IMObject)invoice);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)2L, (long)items.size());
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient1, firstPetProductNight, null, -1, this.author, this.clinician, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, unitPriceIncTax, BigDecimal.ZERO, firstPetProductNightPriceIncTax, BigDecimal.ZERO, new BigDecimal("2.727"), firstPetProductNightPriceIncTax.add(unitPriceIncTax), true, visit1.getEvent(), 0);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient2, secondPetProductNight, null, -1, this.author, this.clinician, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, unitPriceIncTax, BigDecimal.ZERO, secondPetProductNightPriceIncTax, BigDecimal.ZERO, new BigDecimal("2.273"), secondPetProductNightPriceIncTax.add(unitPriceIncTax), true, visit2.getEvent(), 0);
    }

    protected TestChargeEditor createEditor(FinancialAct invoice) {
        DefaultLayoutContext context = new DefaultLayoutContext(true, (Context)new LocalContext(), new HelpContext("foo", null));
        context.getContext().setCustomer(this.customer);
        context.getContext().setPractice(this.getPractice());
        context.getContext().setUser(this.author);
        context.getContext().setClinician(this.clinician);
        context.getContext().setLocation(this.location);
        TestChargeEditor editor = new TestChargeEditor(invoice, (LayoutContext)context, false);
        editor.getComponent();
        return editor;
    }
}

