/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.math.BigDecimal;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.ScheduleArchetypes;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.scheduling.TestTaskVerifier;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.checkin.CheckInEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class CheckInEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testInvalidPatient() {
        Party location = this.practiceFactory.createLocation();
        Party customer = this.customerFactory.createCustomer("J", "Smith");
        Party patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name("Fido")).build();
        CheckInEditor editor = new CheckInEditor(customer, patient, this.schedulingFactory.createSchedule(location), null, location, new Date(), null, null, new HelpContext("foo", null));
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Fido is not owned by Smith,J");
    }

    @Test
    public void testNewInstance() {
        Party location = this.practiceFactory.createLocation();
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        Entity schedule = this.schedulingFactory.createSchedule(location);
        Entity workList = this.schedulingFactory.createWorkList();
        Entity taskType = this.schedulingFactory.createTaskType();
        User clinician = this.userFactory.createClinician();
        User user = this.userFactory.createUser();
        Date arrivalTime = new Date();
        Act appointment = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(DateRules.getToday())).schedule(schedule).appointmentType(this.schedulingFactory.createAppointmentType()).customer(customer)).patient(patient)).build();
        CheckInEditor editor1 = new CheckInEditor(customer, patient, schedule, clinician, location, arrivalTime, appointment, user, new HelpContext("foo", null));
        editor1.setWeight(BigDecimal.TEN);
        editor1.setWorkList(workList);
        editor1.setTaskType(taskType);
        CheckInEditor editor2 = editor1.newInstance();
        Assert.assertEquals((Object)customer, (Object)editor2.getCustomer());
        Assert.assertEquals((Object)patient, (Object)editor2.getPatient());
        Assert.assertEquals((Object)schedule, (Object)editor2.getSchedule());
        Assert.assertEquals((Object)clinician, (Object)editor2.getClinician());
        Assert.assertEquals((Object)location, (Object)editor2.getLocation());
        Assert.assertEquals((Object)arrivalTime, (Object)editor2.getArrivalTime());
        Assert.assertEquals((Object)user, (Object)editor2.getUser());
        Assert.assertEquals((Object)appointment, (Object)editor2.getAppointment());
        this.checkEquals(BigDecimal.TEN, editor2.getWeight());
        Assert.assertEquals((Object)workList, (Object)editor2.getWorkList());
        Assert.assertEquals((Object)taskType, (Object)editor2.getTaskType());
        IMObjectBean bean = this.getBean((IMObject)appointment);
        bean.setTarget("customer", (IMObject)this.customerFactory.createCustomer());
        bean.save();
        try {
            editor2.newInstance();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)"The appointment customer has changed", (Object)expected.getMessage());
        }
        this.remove((IMObject)appointment);
        try {
            editor2.newInstance();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)"Appointment no longer exists", (Object)expected.getMessage());
        }
    }

    @Test
    public void testCreateTask() {
        this.checkCreateTask(true, "Checkup", "Some notes", "Checkup - Some notes");
        this.checkCreateTask(true, "Surgery", null, "Surgery");
        this.checkCreateTask(true, null, "Some notes", "Appointment - Some notes");
        this.checkCreateTask(true, null, null, "Appointment");
        this.checkCreateTask(false, null, null, null);
    }

    private void checkCreateTask(boolean fromAppointment, String appointmentReason, String appointmentNotes, String taskNotes) {
        String reasonCode = null;
        if (fromAppointment && appointmentReason != null) {
            Lookup reason = (Lookup)((TestLookupBuilder)((TestLookupBuilder)this.lookupFactory.newLookup(ScheduleArchetypes.VISIT_REASON).uniqueCode("XREASON")).name(appointmentReason)).build();
            reasonCode = reason.getCode();
        }
        Party location = this.practiceFactory.createLocation();
        Entity schedule = this.schedulingFactory.createSchedule(location);
        Party customer = this.customerFactory.createCustomer("J", "Smith");
        Party patient = this.patientFactory.createPatient("Fido", customer);
        Act appointment = null;
        if (fromAppointment) {
            appointment = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(DateRules.getToday())).schedule(schedule).appointmentType(this.schedulingFactory.createAppointmentType()).reason(reasonCode)).customer(customer)).patient(patient)).notes(appointmentNotes)).build();
        }
        Date arrivalTime = new Date();
        CheckInEditor editor = new CheckInEditor(customer, patient, schedule, null, location, arrivalTime, appointment, null, new HelpContext("foo", null));
        editor.setWeight(BigDecimal.TEN);
        Entity workList = this.schedulingFactory.createWorkList();
        Entity taskType = this.schedulingFactory.createTaskType();
        editor.setWorkList(workList);
        editor.setTaskType(taskType);
        editor.save();
        Act task = (Act)IMObjectHelper.reload((IMObject)editor.getTask());
        Assert.assertNotNull((Object)task);
        TestTaskVerifier verifier = new TestTaskVerifier((ArchetypeService)this.getArchetypeService());
        ((TestTaskVerifier)((TestTaskVerifier)verifier.startTime(arrivalTime)).worklist(workList).taskType(taskType).customer(customer).patient(patient).status("PENDING")).notes(taskNotes).verify((IMObject)task);
    }
}

