/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionTest;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnWeekdaysEditor;

public class RepeatOnWeekdaysEditorTestCase
extends AbstractRepeatExpressionTest {
    @Test
    public void testSupports() {
        CronRepeatExpression cron1 = this.parse("0 30 9 ? * MON-FRI *");
        CronRepeatExpression cron2 = this.parse("0 30 9 ? * MON,TUE,WED,THU,FRI *");
        CronRepeatExpression cron3 = this.parse("0 30 9 ? * MON,TUE,WED,THU *");
        CronRepeatExpression cron4 = this.parse("0 30 9 ? * SAT,SUN *");
        CronRepeatExpression cron5 = this.parse("0 30 9 ? * * *");
        Assert.assertTrue((boolean)RepeatOnWeekdaysEditor.supports((CronRepeatExpression)cron1));
        Assert.assertTrue((boolean)RepeatOnWeekdaysEditor.supports((CronRepeatExpression)cron2));
        Assert.assertFalse((boolean)RepeatOnWeekdaysEditor.supports((CronRepeatExpression)cron3));
        Assert.assertFalse((boolean)RepeatOnWeekdaysEditor.supports((CronRepeatExpression)cron4));
        Assert.assertFalse((boolean)RepeatOnWeekdaysEditor.supports((CronRepeatExpression)cron5));
    }

    @Test
    public void testExpression() {
        RepeatOnWeekdaysEditor editor = new RepeatOnWeekdaysEditor();
        Assert.assertNull((Object)editor.getExpression());
        Date startTime = TestHelper.getDatetime((String)"2015-01-08 09:30:00");
        editor.setStartTime(startTime);
        RepeatExpression expression = editor.getExpression();
        Assert.assertTrue((boolean)(expression instanceof CronRepeatExpression));
        CronRepeatExpression cron = (CronRepeatExpression)expression;
        Assert.assertEquals((Object)"0 30 9 ? * MON-FRI *", (Object)cron.getExpression());
        Date date1 = this.checkNext(startTime, (RepeatExpression)cron, "2015-01-09 09:30:00");
        Date date2 = this.checkNext(date1, (RepeatExpression)cron, "2015-01-12 09:30:00");
        Date date3 = this.checkNext(date2, (RepeatExpression)cron, "2015-01-13 09:30:00");
        this.checkNext(date3, (RepeatExpression)cron, "2015-01-14 09:30:00");
    }
}

