/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.boarding;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.stringparsers.IntegerStringParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class AppointmentGenerator {
    private final IArchetypeService service;
    private final PatientRules patientRules;
    private final AppointmentRules appointmentRules;
    private final List<User> clinicians = new ArrayList<User>();
    private IMObjectQueryIterator<Party> patientIterator;
    private Iterator<User> clinicianIterator;
    private static final String APPLICATION_CONTEXT = "applicationContext.xml";

    public AppointmentGenerator(IArchetypeService service, PatientRules patientRules, AppointmentRules appointmentRules, UserRules userRules) {
        this.service = service;
        this.patientRules = patientRules;
        this.appointmentRules = appointmentRules;
        ArchetypeQuery query = new ArchetypeQuery("security.user");
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            if (!userRules.isClinician(user)) continue;
            this.clinicians.add(user);
        }
    }

    public void generate(String name, int days) {
        ArchetypeQuery query = new ArchetypeQuery("entity.organisationScheduleView");
        query.add((IConstraint)Constraints.eq((String)"name", (Object)name));
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        Date startDate = DateRules.getToday();
        if (iterator.hasNext()) {
            ArrayList<Act> appointments = new ArrayList<Act>();
            Entity view = (Entity)iterator.next();
            IMObjectBean scheduleBean = this.service.getBean((IMObject)view);
            List schedules = scheduleBean.getTargets("schedules", Entity.class, Policies.orderBySequence());
            for (Entity schedule : schedules) {
                Date date = startDate;
                Entity appointmentType = this.getAppointmentType(schedule);
                if (appointmentType != null) {
                    System.out.println("Generating appointments for schedule: " + schedule.getName());
                    int slotSize = this.appointmentRules.getSlotSize(schedule);
                    for (int i = 0; i < days; ++i) {
                        System.out.println("Generating appointments for date: " + DateFormatter.formatDate((Date)date, (boolean)false));
                        Date next = DateRules.getNextDate((Date)date);
                        Date start = date;
                        boolean done = false;
                        while (!done) {
                            Date end = DateRules.getDate((Date)start, (int)slotSize, (DateUnits)DateUnits.MINUTES);
                            if (DateRules.dateEquals((Date)date, (Date)end) || next.equals(end)) {
                                Patient patient = this.nextPatient();
                                Act appointment = ScheduleTestHelper.createAppointment((Date)start, (Date)end, (Entity)schedule, (Entity)appointmentType, (Party)patient.customer, (Party)patient.patient, (User)this.nextClinician());
                                appointment.setStatus("PENDING");
                                appointments.add(appointment);
                                if (appointments.size() > 100) {
                                    this.service.save(appointments);
                                    appointments.clear();
                                }
                                start = end;
                                continue;
                            }
                            done = true;
                        }
                        date = next;
                    }
                }
                if (appointments.isEmpty()) continue;
                this.service.save(appointments);
            }
        } else {
            System.out.println("No view named " + name);
        }
    }

    public static void main(String[] args) throws Exception {
        JSAP parser = AppointmentGenerator.createParser();
        JSAPResult config = parser.parse(args);
        if (!config.success()) {
            AppointmentGenerator.displayUsage(parser);
        } else {
            String contextPath = config.getString("context");
            Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
            AppointmentGenerator generator = new AppointmentGenerator((IArchetypeService)context.getBean(IArchetypeService.class), (PatientRules)context.getBean(PatientRules.class), (AppointmentRules)context.getBean(AppointmentRules.class), (UserRules)context.getBean(UserRules.class));
            generator.generate(config.getString("view"), config.getInt("days"));
        }
    }

    private Entity getAppointmentType(Entity schedule) {
        IMObjectBean bean = this.service.getBean((IMObject)schedule);
        return (Entity)bean.getTarget("appointmentTypes", Entity.class);
    }

    private Patient nextPatient() {
        Patient result;
        boolean all = false;
        if (this.patientIterator == null || !this.patientIterator.hasNext()) {
            all = true;
            this.patientIterator = this.createPatientIterator();
        }
        if ((result = this.getNext(this.patientIterator)) == null && !all) {
            this.patientIterator = this.createPatientIterator();
            result = this.getNext(this.patientIterator);
        }
        if (result == null) {
            throw new IllegalStateException("No patients found");
        }
        return result;
    }

    private User nextClinician() {
        if (this.clinicianIterator == null || !this.clinicianIterator.hasNext()) {
            this.clinicianIterator = this.clinicians.iterator();
        }
        if (this.clinicianIterator.hasNext()) {
            return this.clinicianIterator.next();
        }
        return null;
    }

    private Patient getNext(IMObjectQueryIterator<Party> patients) {
        Patient result = null;
        while (patients.hasNext()) {
            Party patient = (Party)patients.next();
            Party customer = this.patientRules.getOwner(patient);
            if (customer == null || !customer.isActive()) continue;
            result = new Patient(patient, customer);
            break;
        }
        return result;
    }

    private IMObjectQueryIterator<Party> createPatientIterator() {
        ArchetypeQuery query = new ArchetypeQuery("party.patientpet");
        query.add((IConstraint)Constraints.sort((String)"id"));
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }

    private static JSAP createParser() throws JSAPException {
        JSAP parser = new JSAP();
        parser.registerParameter(new FlaggedOption("context").setShortFlag('c').setLongFlag("context").setDefault(APPLICATION_CONTEXT).setHelp("Application context path"));
        parser.registerParameter(new FlaggedOption("view").setShortFlag('v').setLongFlag("view").setHelp("The schedule view."));
        parser.registerParameter(new FlaggedOption("days").setShortFlag('d').setLongFlag("days").setStringParser((StringParser)IntegerStringParser.getParser()).setHelp("The no. of days to generate appointments for."));
        return parser;
    }

    private static void displayUsage(JSAP parser) {
        System.err.println();
        System.err.println("Usage: java " + AppointmentGenerator.class.getName());
        System.err.println("                " + parser.getUsage());
        System.err.println();
        System.err.println(parser.getHelp());
        System.exit(1);
    }

    private static class Patient {
        private final Party patient;
        private final Party customer;

        public Patient(Party patient, Party customer) {
            this.patient = patient;
            this.customer = customer;
        }
    }
}

