/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import java.util.HashMap;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.TableModel;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.echo.table.TableEx;
import org.openvpms.web.workspace.workflow.appointment.AbstractAppointmentGridTest;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.MultiScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.MultiScheduleTableModel;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;

public class MultiScheduleTableModelTestCase
extends AbstractAppointmentGridTest {
    @Test
    public void testGetEvent() {
        Entity schedule = this.createSchedule(60, "09:00", "17:00");
        Date date = TestHelper.getDate((String)"2019-10-07");
        Act appointment1 = this.createAppointment("2019-10-07 08:30", "2019-10-07 09:30", schedule);
        Act appointment2 = this.createAppointment("2019-10-07 11:00", "2019-10-07 11:15", schedule);
        Act appointment3 = this.createAppointment("2019-10-07 12:30", "2019-10-07 13:00", schedule);
        Act appointment4 = this.createAppointment("2019-10-07 16:45", "2019-10-07 17:15", schedule);
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule});
        HashMap<Entity, ScheduleEvents> map = new HashMap<Entity, ScheduleEvents>();
        map.put(schedule, this.getScheduleEvents(appointment1, appointment2, appointment3, appointment4));
        MultiScheduleGrid grid = new MultiScheduleGrid(scheduleView, date, map, this.rules, this.rosterService);
        MultiScheduleTableModel model = new MultiScheduleTableModel((AppointmentGrid)grid, (Context)new LocalContext(), (ScheduleColours)Mockito.mock(ScheduleColours.class));
        Assert.assertEquals((long)3L, (long)model.getColumnCount());
        Assert.assertEquals((long)10L, (long)model.getRowCount());
        this.checkEvent(model, 0, 0, null, null);
        this.checkEvent(model, 1, 0, schedule, appointment1);
        this.checkEvent(model, 1, 1, schedule, appointment1);
        this.checkEvent(model, 1, 2, schedule, null);
        this.checkEvent(model, 1, 3, schedule, appointment2);
        this.checkEvent(model, 1, 4, schedule, appointment3);
        this.checkEvent(model, 1, 5, schedule, null);
        this.checkEvent(model, 1, 8, schedule, appointment4);
        this.checkEvent(model, 1, 9, schedule, appointment4);
        this.checkEvent(model, 2, 0, null, null);
        this.checkEvent(model, -1, -1, null, null);
        this.checkEvent(model, 1, -1, schedule, null);
        this.checkEvent(model, 1, 10, schedule, null);
        this.checkEvent(model, 3, 0, null, null);
    }

    @Test
    public void testAppointmentRendering() {
        Entity schedule = this.createSchedule(60, "09:00", "17:00");
        Date date = TestHelper.getDate((String)"2024-10-09");
        Party customer1 = this.customerFactory.createCustomer("MR", "J", "Smith");
        Party patient1 = this.patientFactory.createPatient("Fido", customer1);
        Act appointment1 = this.createAppointment("2024-10-09 08:30", "2024-10-09 09:30", schedule, customer1, patient1);
        Party customer2 = this.customerFactory.createCustomer("MS", "S", "Bloggs");
        Act appointment2 = this.createAppointment("2024-10-09 11:00", "2024-10-09 11:15", schedule, customer2, null);
        Party customer3 = this.customerFactory.createCustomer(null, "F", "Jones");
        Party patient3 = this.patientFactory.createPatient("Spot", customer3);
        Act appointment3 = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.newAppointment("2024-10-09 12:30", "2024-10-09 13:00", schedule).customer(customer3)).patient(patient3)).appointmentType(this.schedulingFactory.createAppointmentType("New Patient")).reason(ValueStrategy.value(null))).build();
        Act appointment4 = (Act)((TestAppointmentBuilder)this.newAppointment("2024-10-09 16:45", "2024-10-09 17:15", schedule).appointmentType(this.schedulingFactory.createAppointmentType("Scan microchip")).reason("Escaped pet")).build();
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule});
        HashMap<Entity, ScheduleEvents> map = new HashMap<Entity, ScheduleEvents>();
        map.put(schedule, this.getScheduleEvents(appointment1, appointment2, appointment3, appointment4));
        MultiScheduleGrid grid = new MultiScheduleGrid(scheduleView, date, map, this.rules, this.rosterService);
        MultiScheduleTableModel model = new MultiScheduleTableModel((AppointmentGrid)grid, (Context)new LocalContext(), (ScheduleColours)Mockito.mock(ScheduleColours.class));
        TableEx table = new TableEx((TableModel)model, model.getColumnModel());
        table.validate();
        this.checkCellText(table, 0, 0, "08:00");
        this.checkCellText(table, 0, 1, "09:00");
        this.checkCellText(table, 0, 9, "17:00");
        this.checkCellText(table, 1, 0, "Smith,J - Fido\nCheckup - Pending");
        this.checkCellText(table, 1, 3, "Bloggs,S\nCheckup - Pending");
        this.checkCellText(table, 1, 4, "Jones,F - Spot\nNo Reason - Pending");
        this.checkCellText(table, 1, 8, "No Customer\nEscaped pet - Pending");
        this.checkCellText(table, 0, 0, "08:00");
    }

    private Act createAppointment(String startTime, String endTime, Entity schedule, Party customer, Party patient) {
        return (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.newAppointment(startTime, endTime, schedule).customer(customer)).patient(patient)).appointmentType(this.schedulingFactory.createAppointmentType()).reason("Checkup")).build();
    }

    private void checkEvent(MultiScheduleTableModel model, int column, int row, Entity schedule, Act appointment) {
        Cell cell = new Cell(column, row);
        PropertySet event = model.getEvent(cell);
        Assert.assertEquals((Object)event, (Object)model.getEvent(column, row));
        if (schedule == null) {
            Assert.assertNull((Object)model.getSchedule(cell));
            Assert.assertNull((Object)model.getSchedule(column, row));
        } else {
            Schedule actual = model.getSchedule(column, row);
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((Object)schedule, (Object)actual.getSchedule());
            Assert.assertEquals((Object)actual, (Object)model.getSchedule(cell));
            Assert.assertEquals((Object)schedule, (Object)model.getScheduleEntity(cell));
            Assert.assertEquals((Object)schedule, (Object)model.getScheduleEntity(column, row));
        }
        if (appointment == null) {
            Assert.assertNull((Object)event);
        } else {
            Assert.assertNotNull((Object)event);
            Assert.assertEquals((Object)appointment.getObjectReference(), (Object)event.getReference("act.objectReference"));
            Assert.assertNotNull((Object)schedule);
            Assert.assertEquals((Object)schedule.getObjectReference(), (Object)event.getReference("schedule.objectReference"));
        }
    }

    private void checkCellText(TableEx table, int column, int row, String expected) {
        Object content = table.getCellContent(column, row);
        Assert.assertTrue((boolean)(content instanceof Label));
        String text = ((Label)content).getText();
        Assert.assertEquals((Object)expected, (Object)text);
    }
}

