/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.workspace.workflow.appointment.AbstractAppointmentGridTest;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.MultiScheduleGrid;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;

public class MultiScheduleGridTestCase
extends AbstractAppointmentGridTest {
    @Test
    public void testGridWithDifferentScheduleTimesAndSlotSizes() {
        Entity schedule1 = this.createSchedule(15, "09:00", "17:00");
        Entity schedule2 = this.createSchedule(60, "08:00", "16:00");
        Date date = TestHelper.getDate((String)"2019-10-07");
        Act appointment1a = this.createAppointment("2019-10-07 09:00", "2019-10-07 09:15", schedule1);
        Act appointment1b = this.createAppointment("2019-10-07 09:30", "2019-10-07 10:00", schedule1);
        Act appointment2a = this.createAppointment("2019-10-07 08:00", "2019-10-07 10:00", schedule2);
        Act appointment2b = this.createAppointment("2019-10-07 12:00", "2019-10-07 13:00", schedule2);
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule1, schedule2});
        LinkedHashMap<Entity, ScheduleEvents> map = new LinkedHashMap<Entity, ScheduleEvents>();
        map.put(schedule1, this.getScheduleEvents(appointment1a, appointment1b));
        map.put(schedule2, this.getScheduleEvents(appointment2a, appointment2b));
        MultiScheduleGrid grid = new MultiScheduleGrid(scheduleView, date, map, this.rules, this.rosterService);
        Assert.assertEquals((long)15L, (long)grid.getSlotSize());
        Assert.assertEquals((long)36L, (long)grid.getSlots());
        this.checkSlot((AppointmentGrid)grid, schedule1, 0, "2019-10-07 08:00", null, 0, ScheduleEventGrid.Availability.UNAVAILABLE);
        this.checkSlot((AppointmentGrid)grid, schedule1, 1, "2019-10-07 08:15", null, 0, ScheduleEventGrid.Availability.UNAVAILABLE);
        this.checkSlot((AppointmentGrid)grid, schedule1, 2, "2019-10-07 08:30", null, 0, ScheduleEventGrid.Availability.UNAVAILABLE);
        this.checkSlot((AppointmentGrid)grid, schedule1, 3, "2019-10-07 08:45", null, 0, ScheduleEventGrid.Availability.UNAVAILABLE);
        this.checkSlot((AppointmentGrid)grid, schedule1, 4, "2019-10-07 09:00", appointment1a, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule1, 5, "2019-10-07 09:15", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule1, 6, "2019-10-07 09:30", appointment1b, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule1, 7, "2019-10-07 09:45", appointment1b, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule1, 8, "2019-10-07 10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule1, 35, "2019-10-07 16:45", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule2, 0, "2019-10-07 08:00", appointment2a, 8, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 1, "2019-10-07 08:15", appointment2a, 7, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 2, "2019-10-07 08:30", appointment2a, 6, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 3, "2019-10-07 08:45", appointment2a, 5, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 4, "2019-10-07 09:00", appointment2a, 4, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 5, "2019-10-07 09:15", appointment2a, 3, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 6, "2019-10-07 09:30", appointment2a, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 7, "2019-10-07 09:45", appointment2a, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 8, "2019-10-07 10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule2, 15, "2019-10-07 11:45", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule2, 16, "2019-10-07 12:00", appointment2b, 4, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 17, "2019-10-07 12:15", appointment2b, 3, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 18, "2019-10-07 12:30", appointment2b, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 19, "2019-10-07 12:45", appointment2b, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 20, "2019-10-07 13:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule2, 35, "2019-10-07 16:45", null, 0, ScheduleEventGrid.Availability.UNAVAILABLE);
        Schedule first = (Schedule)grid.getSchedules().get(0);
        Assert.assertEquals((Object)first.getSchedule(), (Object)schedule1);
        Assert.assertNull((Object)grid.getEvent(first, -1));
        Assert.assertNull((Object)grid.getEvent(first, grid.getSlots()));
        Schedule second = (Schedule)grid.getSchedules().get(1);
        Assert.assertEquals((Object)second.getSchedule(), (Object)schedule2);
        Assert.assertNull((Object)grid.getEvent(second, -1));
        Assert.assertNull((Object)grid.getEvent(second, grid.getSlots()));
    }

    @Test
    public void testAppointmentsOutsideOfScheduleTimes() {
        Entity schedule1 = this.createSchedule(30, "09:00", "17:00");
        Entity schedule2 = this.createSchedule(60, "08:00", "16:00");
        Date date = TestHelper.getDate((String)"2019-10-07");
        Act appointment1a = this.createAppointment("2019-10-07 08:00", "2019-10-07 08:30", schedule1);
        Act appointment1b = this.createAppointment("2019-10-07 16:30", "2019-10-07 17:30", schedule1);
        Act appointment2a = this.createAppointment("2019-10-07 07:00", "2019-10-07 07:30", schedule2);
        Act appointment2b = this.createAppointment("2019-10-07 16:00", "2019-10-07 17:00", schedule2);
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule1, schedule2});
        LinkedHashMap<Entity, ScheduleEvents> map = new LinkedHashMap<Entity, ScheduleEvents>();
        map.put(schedule1, this.getScheduleEvents(appointment1a, appointment1b));
        map.put(schedule2, this.getScheduleEvents(appointment2a, appointment2b));
        MultiScheduleGrid grid = new MultiScheduleGrid(scheduleView, date, map, this.rules, this.rosterService);
        Assert.assertEquals((long)30L, (long)grid.getSlotSize());
        Assert.assertEquals((long)21L, (long)grid.getSlots());
        this.checkSlot((AppointmentGrid)grid, schedule1, 0, "2019-10-07 07:00", null, 0, ScheduleEventGrid.Availability.UNAVAILABLE);
        this.checkSlot((AppointmentGrid)grid, schedule1, 1, "2019-10-07 07:30", null, 0, ScheduleEventGrid.Availability.UNAVAILABLE);
        this.checkSlot((AppointmentGrid)grid, schedule1, 2, "2019-10-07 08:00", appointment1a, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule1, 3, "2019-10-07 08:30", null, 0, ScheduleEventGrid.Availability.UNAVAILABLE);
        this.checkSlot((AppointmentGrid)grid, schedule1, 4, "2019-10-07 09:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule1, 18, "2019-10-07 16:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule1, 19, "2019-10-07 16:30", appointment1b, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule1, 20, "2019-10-07 17:00", appointment1b, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 0, "2019-10-07 07:00", appointment2a, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 1, "2019-10-07 07:30", null, 0, ScheduleEventGrid.Availability.UNAVAILABLE);
        this.checkSlot((AppointmentGrid)grid, schedule2, 2, "2019-10-07 08:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule2, 3, "2019-10-07 08:30", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule2, 18, "2019-10-07 16:00", appointment2b, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 19, "2019-10-07 16:30", appointment2b, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule2, 20, "2019-10-07 17:00", null, 0, ScheduleEventGrid.Availability.UNAVAILABLE);
        Schedule first = (Schedule)grid.getSchedules().get(0);
        Assert.assertEquals((Object)first.getSchedule(), (Object)schedule1);
        Assert.assertNull((Object)grid.getEvent(first, -1));
        Assert.assertNull((Object)grid.getEvent(first, grid.getSlots()));
        Schedule second = (Schedule)grid.getSchedules().get(1);
        Assert.assertEquals((Object)second.getSchedule(), (Object)schedule2);
        Assert.assertNull((Object)grid.getEvent(second, -1));
        Assert.assertNull((Object)grid.getEvent(second, grid.getSlots()));
    }

    @Test
    public void testAppointmentsNotOnSlotBoundaries() {
        Entity schedule = this.createSchedule(60, "09:00", "17:00");
        Date date = TestHelper.getDate((String)"2019-10-07");
        Act appointment1 = this.createAppointment("2019-10-07 08:30", "2019-10-07 09:30", schedule);
        Act appointment2 = this.createAppointment("2019-10-07 11:00", "2019-10-07 11:15", schedule);
        Act appointment3 = this.createAppointment("2019-10-07 12:30", "2019-10-07 13:00", schedule);
        Act appointment4 = this.createAppointment("2019-10-07 16:45", "2019-10-07 17:15", schedule);
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule});
        HashMap<Entity, ScheduleEvents> map = new HashMap<Entity, ScheduleEvents>();
        map.put(schedule, this.getScheduleEvents(appointment1, appointment2, appointment3, appointment4));
        MultiScheduleGrid grid = new MultiScheduleGrid(scheduleView, date, map, this.rules, this.rosterService);
        Assert.assertEquals((long)10L, (long)grid.getSlots());
        this.checkSlot((AppointmentGrid)grid, schedule, 0, "2019-10-07T08:00:00+11:00", appointment1, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 1, "2019-10-07T09:00:00+11:00", appointment1, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 2, "2019-10-07T10:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule, 3, "2019-10-07T11:00:00+11:00", appointment2, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 4, "2019-10-07T12:00:00+11:00", appointment3, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 5, "2019-10-07T13:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)grid, schedule, 8, "2019-10-07T16:00:00+11:00", appointment4, 2, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)grid, schedule, 9, "2019-10-07T17:00:00+11:00", appointment4, 1, ScheduleEventGrid.Availability.BUSY);
        Schedule first = (Schedule)grid.getSchedules().get(0);
        Assert.assertEquals((Object)first.getSchedule(), (Object)schedule);
        Assert.assertNull((Object)grid.getEvent(first, -1));
        Assert.assertNull((Object)grid.getEvent(first, grid.getSlots()));
    }
}

