/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractCalendarEventSeriesTest;
import org.openvpms.web.workspace.workflow.appointment.repeat.CalendarBlockSeries;
import org.openvpms.web.workspace.workflow.appointment.repeat.Repeats;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public class CalendarBlockSeriesTestCase
extends AbstractCalendarEventSeriesTest {
    private Entity blockType;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.blockType = ScheduleTestHelper.createCalendarBlockType();
    }

    @Test
    public void testChangeBlockType() {
        Entity blockType2 = ScheduleTestHelper.createCalendarBlockType();
        Act block = this.createEvent();
        ScheduleEventSeries series = this.createSeries(block, Repeats.weekly(), Repeats.times((int)2));
        this.checkSeries(series, block, 1, DateUnits.WEEKS, 3);
        IMObjectBean bean = this.getBean((IMObject)block);
        bean.setTarget("type", (IMObject)blockType2);
        this.checkSave(series);
        Assert.assertEquals((Object)blockType2, (Object)bean.getTarget("type"));
        this.checkSeries(series, block, 1, DateUnits.WEEKS, 3);
    }

    @Override
    protected Act createEvent(Date startTime, Date endTime, Entity schedule, Entity appointmentType) {
        Act block = ScheduleTestHelper.createCalendarBlock((Date)startTime, (Date)endTime, (Entity)schedule, (Entity)this.blockType);
        block.setName("block name");
        IMObjectBean bean = this.getBean((IMObject)block);
        bean.setValue("notes", (Object)"block description");
        return block;
    }

    @Override
    protected List<Act> checkSeries(ScheduleEventSeries series, Act event, int interval, DateUnits units, int count, User author) {
        List acts = series.getEvents();
        Assert.assertEquals((long)count, (long)acts.size());
        Date from = event.getActivityStartTime();
        Date to = event.getActivityEndTime();
        Assert.assertEquals((Object)event, acts.get(0));
        IMObjectBean bean = this.getBean((IMObject)event);
        Entity schedule = (Entity)bean.getTarget("schedule", Entity.class);
        Entity blockType = (Entity)bean.getTarget("type", Entity.class);
        String name = event.getName();
        String notes = bean.getString("notes");
        for (Act act : acts) {
            this.checkEvent(act, from, to, schedule, blockType, author, name, notes);
            from = DateRules.getDate((Date)from, (int)interval, (DateUnits)units);
            to = DateRules.getDate((Date)to, (int)interval, (DateUnits)units);
        }
        return acts;
    }

    @Override
    protected ScheduleEventSeries createSeries(Act event) {
        return new CalendarBlockSeries(event, this.getArchetypeService());
    }

    private void checkEvent(Act act, Date startTime, Date endTime, Entity schedule, Entity blockType, User author, String name, String notes) {
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)startTime, (Date)act.getActivityStartTime()));
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)endTime, (Date)act.getActivityEndTime()));
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)schedule, (Object)bean.getTarget("schedule"));
        Assert.assertEquals((Object)blockType, (Object)bean.getTarget("type"));
        Assert.assertNull((Object)act.getStatus());
        Assert.assertEquals((Object)author.getObjectReference(), (Object)act.getCreatedBy());
        Assert.assertEquals((Object)name, (Object)bean.getString("name"));
        Assert.assertEquals((Object)notes, (Object)bean.getString("notes"));
    }
}

