/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.functor.ActComparator;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.appointment.CalendarBlockEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.Repeats;

public class CalendarBlockEditorTestCase
extends AbstractAppTest {
    @Test
    public void testNewInstance() {
        Date start = DateRules.getToday();
        Date end = DateRules.getTomorrow();
        Party schedule = ScheduleTestHelper.createSchedule((Party)TestHelper.createLocation());
        Entity blockType = ScheduleTestHelper.createCalendarBlockType();
        Act block = ScheduleTestHelper.createCalendarBlock((Date)start, (Date)end, (Entity)schedule, (Entity)blockType);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        CalendarBlockEditor editor = new CalendarBlockEditor(block, null, (LayoutContext)context);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof CalendarBlockEditor));
    }

    @Test
    public void testWeekdaysRepeat() {
        Date initialStart = TestHelper.getDate((String)"2018-07-23");
        Date initialEnd = DateRules.getDate((Date)initialStart, (int)1, (DateUnits)DateUnits.HOURS);
        Party schedule = ScheduleTestHelper.createSchedule((Party)TestHelper.createLocation());
        Entity blockType = ScheduleTestHelper.createCalendarBlockType();
        Act block = ScheduleTestHelper.createCalendarBlock((Date)initialStart, (Date)initialEnd, (Entity)schedule, (Entity)blockType);
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createUser());
        DefaultLayoutContext layout = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        CalendarBlockEditor editor = new CalendarBlockEditor(block, null, true, (LayoutContext)layout);
        editor.getComponent();
        editor.setExpression(Repeats.weekdays((Date)initialStart));
        editor.setCondition(Repeats.times((int)10));
        Date newStart = DateRules.getDate((Date)initialStart, (int)2, (DateUnits)DateUnits.HOURS);
        Date newEnd = DateRules.getDate((Date)newStart, (int)1, (DateUnits)DateUnits.HOURS);
        editor.setStartTime(newStart);
        editor.setEndTime(newEnd);
        Assert.assertTrue((boolean)editor.isValid());
        editor.save();
        IMObjectBean bean = this.getBean((IMObject)block);
        Act series = (Act)bean.getSource("repeat", Act.class);
        Assert.assertNotNull((Object)series);
        IMObjectBean seriesBean = this.getBean((IMObject)series);
        List items = seriesBean.getTargets("items", Act.class);
        Collections.sort(items, ActComparator.ascending());
        Assert.assertEquals((long)11L, (long)items.size());
        Date start = newStart;
        Date end = newEnd;
        for (Act item : items) {
            Assert.assertEquals((Object)start, (Object)item.getActivityStartTime());
            Assert.assertEquals((Object)end, (Object)item.getActivityEndTime());
            start = Instant.ofEpochMilli(start.getTime()).atZone(ZoneId.systemDefault()).toLocalDate().getDayOfWeek() == DayOfWeek.FRIDAY ? DateRules.getDate((Date)start, (int)3, (DateUnits)DateUnits.DAYS) : DateRules.getDate((Date)start, (int)1, (DateUnits)DateUnits.DAYS);
            end = DateRules.getDate((Date)start, (int)1, (DateUnits)DateUnits.HOURS);
        }
    }
}

