/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.prefs.PreferenceService;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.appointment.AppointmentWorkspace;
import org.springframework.beans.factory.annotation.Autowired;

public class AppointmentWorkspaceTestCase
extends AbstractAppTest {
    @Autowired
    private PreferenceService preferenceService;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;

    @Test
    public void testChangeLocation() {
        Party location1 = this.practiceFactory.createLocation();
        Entity schedule1 = this.schedulingFactory.createSchedule(location1);
        Entity scheduleView1 = this.schedulingFactory.createScheduleView(new Entity[]{schedule1});
        this.practiceFactory.updateLocation(location1).addScheduleView(scheduleView1, true).build();
        Party location2 = this.practiceFactory.createLocation();
        Entity schedule2 = this.schedulingFactory.createSchedule(location2);
        Entity scheduleView2 = this.schedulingFactory.createScheduleView(new Entity[]{schedule2});
        this.practiceFactory.updateLocation(location2).addScheduleView(scheduleView2, true).build();
        ContextApplicationInstance app = ContextApplicationInstance.getInstance();
        GlobalContext context = app.getContext();
        context.setLocation(location1);
        AppointmentWorkspace workspace = new AppointmentWorkspace((Context)context, (Preferences)app.getPreferences());
        workspace.getComponent();
        workspace.show();
        Assert.assertEquals((Object)workspace.getObject(), (Object)scheduleView1);
        context.setLocation(location2);
        Assert.assertEquals((Object)workspace.getObject(), (Object)scheduleView2);
        workspace.hide();
        context.setLocation(location1);
        workspace.getComponent();
        workspace.show();
        Assert.assertEquals((Object)workspace.getObject(), (Object)scheduleView1);
    }

    protected PreferenceService getPreferenceService() {
        return this.preferenceService;
    }
}

