/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import org.junit.Assert;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGrid;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractAppointmentGridTest
extends AbstractAppTest {
    @Autowired
    protected TestCustomerFactory customerFactory;
    @Autowired
    protected TestPatientFactory patientFactory;
    @Autowired
    protected TestPracticeFactory practiceFactory;
    @Autowired
    protected TestSchedulingFactory schedulingFactory;
    @Autowired
    protected AppointmentRules rules;
    @Autowired
    protected RosterService rosterService;

    protected PropertySet createEvent(Act appointment) {
        ObjectSet result = new ObjectSet();
        IMObjectBean bean = this.getBean((IMObject)appointment);
        Entity appointmentType = (Entity)bean.getTarget("appointmentType", Entity.class);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        Lookup statusLookup = bean.getLookup("status");
        Lookup reasonLookup = bean.getLookup("reason");
        result.set("act.startTime", (Object)appointment.getActivityStartTime());
        result.set("act.endTime", (Object)appointment.getActivityEndTime());
        result.set("act.objectReference", (Object)appointment.getObjectReference());
        result.set("act.status", (Object)appointment.getStatus());
        result.set("act.statusName", (Object)(statusLookup != null ? statusLookup.getName() : null));
        result.set("act.reason", (Object)appointment.getReason());
        result.set("act.reasonName", (Object)(reasonLookup != null ? reasonLookup.getName() : null));
        result.set("schedule.objectReference", (Object)bean.getTargetRef("schedule"));
        result.set("scheduleType.objectReference", (Object)appointmentType.getObjectReference());
        result.set("scheduleType.name", (Object)appointmentType.getName());
        result.set("customer.name", (Object)(customer != null ? customer.getName() : null));
        result.set("patient.name", (Object)(patient != null ? patient.getName() : null));
        result.set("notes", (Object)bean.getString("notes"));
        return result;
    }

    protected ScheduleEvents getScheduleEvents(Act ... appointments) {
        ArrayList<PropertySet> events = new ArrayList<PropertySet>();
        for (Act appointment : appointments) {
            events.add(this.createEvent(appointment));
        }
        return new ScheduleEvents(events, 0L);
    }

    protected Act createAppointment(String startTime, String endTime, Entity schedule) {
        return (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)this.newAppointment(startTime, endTime, schedule).customer(this.customerFactory.createCustomer())).patient(this.patientFactory.createPatient())).appointmentType(this.schedulingFactory.createAppointmentType()).build();
    }

    protected TestAppointmentBuilder newAppointment(String startTime, String endTime, Entity schedule) {
        return ((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(startTime)).endTime(endTime)).schedule(schedule);
    }

    protected void checkSlot(AppointmentGrid grid, Entity schedule, int slot, String time, Act appointment, int slots, ScheduleEventGrid.Availability availability) {
        Date date = time.contains("T") ? Date.from(OffsetDateTime.parse(time).toInstant()) : TestHelper.getDatetime((String)time);
        Date actualTime = grid.getStartTime(slot);
        Assert.assertEquals((Object)date, (Object)actualTime);
        Assert.assertEquals((long)slot, (long)grid.getSlot(actualTime));
        Schedule gridSchedule = this.getSchedule(grid, schedule);
        PropertySet event = grid.getEvent(gridSchedule, slot);
        if (appointment != null) {
            Assert.assertNotNull((Object)event);
            Assert.assertEquals((Object)appointment.getObjectReference(), (Object)event.getReference("act.objectReference"));
        } else {
            Assert.assertNull((Object)event);
        }
        if (event != null) {
            int actualSlots = grid.getSlots(event, gridSchedule, slot);
            Assert.assertEquals((long)slots, (long)actualSlots);
        }
        ScheduleEventGrid.Availability actualAvailability = grid.getAvailability(this.getSchedule(grid, schedule), slot);
        Assert.assertEquals((Object)availability, (Object)actualAvailability);
    }

    protected Entity createSchedule(int slotSize, String start, String end) {
        return (Entity)this.schedulingFactory.newSchedule().location(this.practiceFactory.createLocation()).slotSize(slotSize, DateUnits.MINUTES).addAppointmentType(this.schedulingFactory.createAppointmentType(), 1, true).times(start, end).build();
    }

    private Schedule getSchedule(AppointmentGrid grid, Entity schedule) {
        for (Schedule sched : grid.getSchedules()) {
            if (!sched.getSchedule().equals(schedule)) continue;
            return sched;
        }
        Assert.fail((String)"Schedule not found");
        return null;
    }
}

