/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.delivery;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.WindowPane;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.archetype.test.builder.supplier.delivery.TestDeliveryBuilder;
import org.openvpms.archetype.test.builder.supplier.delivery.TestDeliveryItemBuilder;
import org.openvpms.archetype.test.builder.supplier.delivery.TestReturnBuilder;
import org.openvpms.archetype.test.builder.supplier.delivery.TestReturnItemBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.supplier.delivery.DeliveryCRUDWindow;
import org.openvpms.web.workspace.supplier.delivery.DeliveryEditor;
import org.openvpms.web.workspace.supplier.delivery.DeliveryItemEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class DeliveryCRUDWindowTestCase
extends AbstractAppTest {
    private final List<String> errors = new ArrayList<String>();
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    private Context context;
    private static final String EACH = "EA";

    @Before
    public void setUp() {
        super.setUp();
        this.initErrorHandler(this.errors);
        this.context = new LocalContext();
        this.context.setPractice(this.practiceFactory.getPractice());
    }

    @Test
    public void testPost() {
        FinancialAct delivery = (FinancialAct)((TestDeliveryBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryBuilder)((TestDeliveryBuilder)((TestDeliveryBuilder)this.supplierFactory.newDelivery().supplier(this.supplierFactory.createSupplier())).stockLocation(this.practiceFactory.createStockLocation(new Party[0]))).status("IN_PROGRESS")).item().product(this.productFactory.createMedication())).quantity(10)).packageSize(10)).packageUnits(EACH)).add()).build();
        this.checkPost(delivery);
        FinancialAct supplierReturn = (FinancialAct)((TestReturnBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnBuilder)((TestReturnBuilder)((TestReturnBuilder)this.supplierFactory.newReturn().supplier(this.supplierFactory.createSupplier())).stockLocation(this.practiceFactory.createStockLocation(new Party[0]))).status("IN_PROGRESS")).item().product(this.productFactory.createMedication())).quantity(10)).packageSize(10)).packageUnits(EACH)).add()).build();
        this.checkPost(supplierReturn);
    }

    @Test
    public void testPostIncompleteDelivery() {
        this.lookupFactory.createUnitOfMeasure(EACH);
        FinancialAct delivery = (FinancialAct)((TestDeliveryBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryBuilder)((TestDeliveryBuilder)((TestDeliveryBuilder)this.supplierFactory.newDelivery().supplier(this.supplierFactory.createSupplier())).stockLocation(this.practiceFactory.createStockLocation(new Party[0]))).status("IN_PROGRESS")).item().product(this.productFactory.createMedication())).quantity(10)).packageSize(10)).packageUnits(null)).add()).build();
        DeliveryCRUDWindow window = this.createWindow(delivery);
        EchoTestHelper.fireButton((Component)window.getComponent(), (String)"button.post");
        String displayName = this.getDisplayName((IMObject)delivery);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)("Finalise " + displayName), (String)("Are you sure you want to Finalise the " + displayName + "?"), (String)"ok");
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Failed to validate property Package Units: Package Units is required", (Object)this.errors.get(0));
        this.errors.clear();
        EditDialog dialog = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog);
        Assert.assertTrue((boolean)(dialog.getEditor() instanceof DeliveryEditor));
        DeliveryEditor editor = (DeliveryEditor)dialog.getEditor();
        FinancialAct item = (FinancialAct)editor.getItems().getActs().get(0);
        DeliveryItemEditor itemEditor = (DeliveryItemEditor)editor.getItems().getEditor((IMObject)item);
        itemEditor.setPackageUnits(EACH);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        FinancialAct reloaded = (FinancialAct)this.get((IMObject)delivery);
        Assert.assertEquals((Object)"POSTED", (Object)reloaded.getStatus());
        this.checkPosted(reloaded);
    }

    private void checkPost(FinancialAct object) {
        DeliveryCRUDWindow window = this.createWindow(object);
        EchoTestHelper.fireButton((Component)window.getComponent(), (String)"button.post");
        String displayName = this.getDisplayName((IMObject)object);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)("Finalise " + displayName), (String)("Are you sure you want to Finalise the " + displayName + "?"), (String)"ok");
        FinancialAct reloaded = (FinancialAct)this.get((IMObject)object);
        Assert.assertEquals((Object)"POSTED", (Object)reloaded.getStatus());
        Assert.assertEquals((Object)reloaded, (Object)window.getObject());
        this.checkPosted(object);
    }

    private void checkPosted(FinancialAct object) {
        if (object.isA("act.supplierDelivery")) {
            EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Invoice Supplier?", (String)"Do you want to invoice the supplier?", (String)"ok");
        } else {
            EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Credit Supplier?", (String)"Do you want to credit the supplier?", (String)"ok");
        }
        Assert.assertNull((Object)EchoTestHelper.findWindowPane(WindowPane.class));
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    private DeliveryCRUDWindow createWindow(FinancialAct object) {
        DeliveryCRUDWindow window = new DeliveryCRUDWindow(Archetypes.create((String[])new String[]{"act.supplierDelivery", "act.supplierReturn"}, FinancialAct.class), this.context, new HelpContext("foo", null));
        window.setObject((Act)object);
        return window;
    }
}

