/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.doc.TestDocumentBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderTypeBuilder;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.app.PracticeMailContext;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.mail.DefaultMailer;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailException;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.security.mail.MailPasswordResolver;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.AbstractPatientReminderProcessorTest;
import org.openvpms.web.workspace.reporting.reminder.EmailReminders;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;
import org.openvpms.web.workspace.reporting.reminder.ReminderEmailProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;

public class ReminderEmailProcessorTestCase
extends AbstractPatientReminderProcessorTest<EmailReminders> {
    private final List<String> attachments = new ArrayList<String>();
    @Autowired
    private PracticeRules practiceRules;
    @Autowired
    private TestDocumentFactory documentFactory;
    private ReminderEmailProcessor processor;
    private JavaMailSender sender;
    private MimeMessage mimeMessage;

    public ReminderEmailProcessorTestCase() {
        super("contact.email");
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Document handout1 = (Document)((TestDocumentBuilder)this.documentFactory.newDocument().name("Patient Handout.pdf")).content("dummy pdf content").mimeType("application/pdf").build();
        Entity attachment1 = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").document(handout1)).build();
        Document handout2 = (Document)((TestDocumentBuilder)this.documentFactory.newDocument().name("Customer Handout.pdf")).content("dummy pdf content").mimeType("application/pdf").build();
        Entity attachment2 = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.customerDocumentForm").document(handout2)).build();
        Entity documentTemplate = (Entity)this.documentFactory.newTemplate().type("act.patientDocumentForm").emailTemplate().subject("openvpms:get(., 'reminderType.entity.name')").subjectType(EmailTemplate.SubjectType.XPATH).content("text").addAttachments(new Entity[]{attachment1, attachment2}).add().build();
        ((TestReminderTypeBuilder)this.reminderFactory.updateReminderType(this.reminderType).name("Vaccination Reminder")).newCount().count(0).interval(1, DateUnits.WEEKS).template(documentTemplate).newRule().email().sendTo(ReminderRule.SendTo.ANY).add().add().build();
        MailerFactory mailerFactory = (MailerFactory)Mockito.mock(MailerFactory.class);
        this.sender = (JavaMailSender)Mockito.mock(JavaMailSender.class);
        this.mimeMessage = (MimeMessage)Mockito.mock(MimeMessage.class);
        Mockito.when((Object)this.sender.createMimeMessage()).thenReturn((Object)this.mimeMessage);
        LocalContext context = new LocalContext();
        context.setPractice(this.practice);
        PracticeMailContext mailContext = new PracticeMailContext((Context)context);
        DefaultMailer mailer = new DefaultMailer((MailContext)mailContext, this.sender, (DocumentHandlers)Mockito.mock(DocumentHandlers.class)){

            public void addAttachment(Document document) {
                super.addAttachment(document);
                ReminderEmailProcessorTestCase.this.attachments.add(document.getName());
            }
        };
        Mockito.when((Object)mailerFactory.create((MailContext)Mockito.any(), (JavaMailSender)Mockito.any())).thenReturn((Object)mailer);
        IArchetypeService service = this.getArchetypeService();
        EmailTemplateEvaluator evaluator = new EmailTemplateEvaluator((ArchetypeService)this.getArchetypeService(), this.getLookupService(), null, (ReportFactory)Mockito.mock(ReportFactory.class), (DocumentConverter)Mockito.mock(DocumentConverter.class));
        ReminderTypes reminderTypes = new ReminderTypes((ArchetypeService)service);
        CommunicationLogger logger = (CommunicationLogger)Mockito.mock(CommunicationLogger.class);
        ReporterFactory reporterFactory = (ReporterFactory)Mockito.mock(ReporterFactory.class);
        ReminderConfiguration config = this.createConfiguration();
        this.processor = new ReminderEmailProcessor(mailerFactory, evaluator, reporterFactory, reminderTypes, this.practice, this.reminderRules, this.patientRules, this.practiceRules, service, config, logger, (MailPasswordResolver)Mockito.mock(MailPasswordResolver.class), this.actionFactory);
    }

    @Test
    public void testReminderContact() throws Exception {
        Contact email1 = this.contactFactory.createEmail("x@test.com", false, new String[]{"REMINDER"});
        Contact email2 = this.contactFactory.createEmail("y@test.com", true, new String[0]);
        Contact email3 = this.contactFactory.createEmail("z@test.com", new String[0]);
        this.customer.addContact(email1);
        this.customer.addContact(email2);
        this.customer.addContact(email3);
        this.checkSend(null, "x@test.com");
    }

    @Test
    public void testOverrideContact() throws Exception {
        Contact email1 = this.contactFactory.createEmail("x@test.com", true, new String[]{"REMINDER"});
        Contact email2 = this.contactFactory.createEmail("y@test.com", false, new String[0]);
        this.customer.addContact(email1);
        this.customer.addContact(email2);
        this.checkSend(email2, "y@test.com");
    }

    @Test
    public void testFailed() {
        Contact email = this.contactFactory.createEmail("x@test.com", true, new String[]{"REMINDER"});
        this.customer.addContact(email);
        Date tomorrow = DateRules.getTomorrow();
        Act item = (Act)this.reminderFactory.newSMSReminder().sendDate(DateRules.getToday()).dueDate(tomorrow).build();
        Act reminder = this.createReminder(tomorrow, this.reminderType, item);
        ((JavaMailSender)Mockito.doThrow((Throwable[])new Throwable[]{new MailException(MailException.ErrorCode.FailedToSend, new Object[]{"x@test.com", "some error"})}).when((Object)this.sender)).send((MimeMessage)Mockito.any());
        EmailReminders reminders = (EmailReminders)this.prepare(item, reminder, null);
        try {
            this.processor.process(reminders);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (OpenVPMSException expected) {
            Assert.assertTrue((boolean)this.processor.failed((PatientReminders)reminders, (Throwable)expected));
            this.checkItem((Act)this.get((IMObject)item), "ERROR", "Failed to send email to x@test.com: some error");
        }
    }

    @Test
    public void testMissingReminderCount() {
        this.checkMissingReminderCount(this.contactFactory.createEmail("x@test.com", true, new String[]{"REMINDER"}));
    }

    @Test
    public void testMissingReminderCountTemplate() {
        this.checkMissingReminderCountTemplate(this.contactFactory.createEmail("x@test.com", true, new String[]{"REMINDER"}));
    }

    protected ReminderEmailProcessor getProcessor() {
        return this.processor;
    }

    @Override
    protected Act createReminderItem(Date send, Date dueDate) {
        return (Act)this.reminderFactory.newEmailReminder().sendDate(send).dueDate(dueDate).build();
    }

    private void checkSend(Contact contact, String to) throws Exception {
        EmailReminders reminders = this.prepare(contact);
        this.processor.process(reminders);
        InternetAddress from = new InternetAddress("foo@bar.com", "Test Practice");
        ((MimeMessage)Mockito.verify((Object)this.mimeMessage)).setFrom((Address)from);
        ((MimeMessage)Mockito.verify((Object)this.mimeMessage)).setSubject("Vaccination Reminder", "UTF-8");
        ((MimeMessage)Mockito.verify((Object)this.mimeMessage)).setRecipients(Message.RecipientType.TO, new Address[]{new InternetAddress(to)});
        ((MimeMessage)Mockito.verify((Object)this.mimeMessage)).setReplyTo(new Address[]{from});
        Assert.assertEquals((long)2L, (long)this.attachments.size());
        Assert.assertTrue((boolean)this.attachments.contains("Customer Handout.pdf"));
        Assert.assertTrue((boolean)this.attachments.contains("Patient Handout.pdf"));
    }

    private EmailReminders prepare(Contact contact) {
        Date tomorrow = DateRules.getTomorrow();
        Act item = this.createReminderItem(DateRules.getToday(), tomorrow);
        Act reminder = this.createReminder(tomorrow, this.reminderType, item);
        return (EmailReminders)this.prepare(item, reminder, contact);
    }
}

