/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.practice.MailServer;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.mail.DefaultMailerFactory;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.Mailer;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.security.mail.MailPasswordResolver;
import org.openvpms.web.workspace.reporting.ReportingException;
import org.openvpms.web.workspace.reporting.email.LocationMailerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;

public class LocationMailerFactoryTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PracticeRules practiceRules;

    @Test
    public void testCreate() {
        DefaultMailerFactory mailerFactory = new DefaultMailerFactory(null, (DocumentHandlers)Mockito.mock(DocumentHandlers.class)){

            public Mailer create(MailContext context, JavaMailSender sender) {
                return super.create(context, sender);
            }
        };
        Party practice = this.createPractice();
        Party location1 = this.createLocation("Main Clinic", practice);
        practice.addContact(TestHelper.createEmailContact((String)"foo@bar.com"));
        Entity settings1 = this.createMailSettings("bar.com");
        this.addMailServer(practice, settings1);
        TestReminderMailerFactory factory1 = new TestReminderMailerFactory(practice, (MailerFactory)mailerFactory);
        Mailer mailer1 = factory1.create(location1, (Context)new LocalContext());
        this.checkMailer(mailer1, "\"VetsRUs\" <foo@bar.com>", settings1);
        Entity settings2 = this.createMailSettings("gum.com");
        this.addMailServer(location1, settings2);
        TestReminderMailerFactory factory2 = new TestReminderMailerFactory(practice, (MailerFactory)mailerFactory);
        Mailer mailer2 = factory2.create(location1, (Context)new LocalContext());
        this.checkMailer(mailer2, "\"VetsRUs\" <foo@bar.com>", settings1);
        location1.addContact(TestHelper.createEmailContact((String)"foo@gum.com"));
        this.save((IMObject)location1);
        TestReminderMailerFactory factory3 = new TestReminderMailerFactory(practice, (MailerFactory)mailerFactory);
        Mailer mailer3 = factory3.create(location1, (Context)new LocalContext());
        this.checkMailer(mailer3, "\"VetsRUs\" <foo@bar.com>", settings1);
        location1.addContact(TestHelper.createEmailContact((String)"bar@gum.com", (boolean)false, (String)"REMINDER"));
        this.save((IMObject)location1);
        TestReminderMailerFactory factory4 = new TestReminderMailerFactory(practice, (MailerFactory)mailerFactory);
        Mailer mailer4 = factory4.create(location1, (Context)new LocalContext());
        this.checkMailer(mailer4, "\"Main Clinic\" <bar@gum.com>", settings2);
    }

    @Test
    public void testNoPracticeContact() {
        Party practice = this.createPractice();
        MailPasswordResolver passwordResolver = (MailPasswordResolver)Mockito.mock(MailPasswordResolver.class);
        try {
            new LocationMailerFactory(practice, this.practiceRules, (ArchetypeService)this.getArchetypeService(), null, "REMINDER", passwordResolver);
            Assert.fail((String)"Expected ReportingException to be thrown");
        }
        catch (ReportingException expected) {
            Assert.assertEquals((Object)"Practice VetsRUs has no email contact", (Object)expected.getMessage());
        }
        try {
            practice.addContact(TestHelper.createEmailContact((String)"foo@bar.com"));
            new LocationMailerFactory(practice, this.practiceRules, (ArchetypeService)this.getArchetypeService(), null, "REMINDER", passwordResolver);
            Assert.fail((String)"Expected ReportingException to be thrown");
        }
        catch (ReportingException expected) {
            Assert.assertEquals((Object)"No Mail Server has been configured for VetsRUs", (Object)expected.getMessage());
        }
        this.addMailServer(practice, this.createMailSettings("bar.com"));
        new LocationMailerFactory(practice, this.practiceRules, (ArchetypeService)this.getArchetypeService(), null, "REMINDER", passwordResolver);
    }

    private void checkMailer(Mailer mailer, String from, Entity settings) {
        Assert.assertTrue((boolean)(mailer instanceof TestMailer));
        Assert.assertEquals((Object)from, (Object)mailer.getFrom());
        Assert.assertEquals((long)settings.getId(), (long)((TestMailer)mailer).getMailServer().getId());
    }

    private Party createPractice() {
        Party practice = (Party)this.create("party.organisationPractice", Party.class);
        practice.setName("VetsRUs");
        practice.setActive(false);
        IMObjectBean bean = this.getArchetypeService().getBean((IMObject)practice);
        Lookup currency = TestHelper.getCurrency((String)"AUD");
        bean.setValue("currency", (Object)currency.getCode());
        this.save((IMObject)practice);
        return practice;
    }

    private Entity createMailSettings(String host) {
        Entity settings = (Entity)this.create("entity.mailServer", Entity.class);
        IMObjectBean bean = this.getArchetypeService().getBean((IMObject)settings);
        bean.setValue("name", (Object)host);
        bean.setValue("host", (Object)host);
        bean.save();
        return settings;
    }

    private Party createLocation(String name, Party practice) {
        Party location = (Party)this.create("party.organisationLocation", Party.class);
        location.setName(name);
        IMObjectBean bean = this.getArchetypeService().getBean((IMObject)practice);
        bean.addTarget("locations", (IMObject)location, "practice");
        bean.save(new IMObject[]{location});
        return location;
    }

    private void addMailServer(Party location, Entity settings) {
        IMObjectBean bean = this.getArchetypeService().getBean((IMObject)location);
        bean.addTarget("mailServer", (IMObject)settings);
    }

    private static class TestMailer
    implements Mailer {
        private final Mailer mailer;
        private final MailServer settings;

        TestMailer(Mailer mailer, MailServer settings) {
            this.mailer = mailer;
            this.settings = settings;
        }

        public MailContext getContext() {
            return this.mailer.getContext();
        }

        public void setFrom(String from) {
            this.mailer.setFrom(from);
        }

        public String getFrom() {
            return this.mailer.getFrom();
        }

        public void setTo(String[] to) {
            this.mailer.setTo(to);
        }

        public String[] getTo() {
            return this.mailer.getTo();
        }

        public void setCc(String[] cc) {
            this.mailer.setCc(cc);
        }

        public String[] getCc() {
            return this.mailer.getCc();
        }

        public void setBcc(String[] bcc) {
            this.mailer.setBcc(bcc);
        }

        public String[] getBcc() {
            return this.mailer.getBcc();
        }

        public void setSubject(String subject) {
            this.mailer.setSubject(subject);
        }

        public String getSubject() {
            return this.mailer.getSubject();
        }

        public void setBody(String body) {
            this.mailer.setBody(body);
        }

        public String getBody() {
            return this.mailer.getBody();
        }

        public void addAttachment(Document document) {
            this.mailer.addAttachment(document);
        }

        public List<Document> getAttachments() {
            return this.mailer.getAttachments();
        }

        public void send() {
            this.mailer.send();
        }

        MailServer getMailServer() {
            return this.settings;
        }
    }

    private class TestReminderMailerFactory
    extends LocationMailerFactory {
        TestReminderMailerFactory(Party practice, MailerFactory mailerFactory) {
            super(practice, LocationMailerFactoryTestCase.this.practiceRules, (ArchetypeService)LocationMailerFactoryTestCase.this.getArchetypeService(), mailerFactory, "REMINDER", (MailPasswordResolver)Mockito.mock(MailPasswordResolver.class));
        }

        protected Mailer create(Context context, MailServer settings) {
            return new TestMailer(super.create(context, settings), settings);
        }
    }
}

