/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Date;
import org.junit.Assert;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.action.ActionFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractReminderBatchProcessorTest
extends ArchetypeServiceTest {
    @Autowired
    protected ActionFactory actionFactory;
    @Autowired
    protected TestCustomerFactory customerFactory;
    @Autowired
    protected TestPatientFactory patientFactory;
    @Autowired
    protected TestPracticeFactory practiceFactory;
    @Autowired
    protected TestReminderFactory reminderFactory;

    protected void checkReminder(Act reminder, Date nextReminder) {
        this.checkReminder(reminder, 1, nextReminder);
    }

    protected void checkReminder(Act reminder, int reminderCount, Date nextReminder) {
        reminder = (Act)this.get((IMObject)reminder);
        Assert.assertNotNull((Object)reminder);
        IMObjectBean bean = this.getBean((IMObject)reminder);
        Assert.assertEquals((long)reminderCount, (long)bean.getInt("reminderCount"));
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)reminder.getActivityStartTime(), (Date)nextReminder, (boolean)true));
    }

    protected void checkCompleted(Act ... items) {
        this.checkStatus("COMPLETED", null, items);
    }

    protected void checkStatus(String status, String error, Act ... items) {
        for (Act item : items) {
            item = (Act)this.get((IMObject)item);
            Assert.assertNotNull((Object)item);
            Assert.assertEquals((Object)status, (Object)item.getStatus());
            IMObjectBean bean = this.getBean((IMObject)item);
            Assert.assertEquals((Object)error, (Object)bean.getString("error"));
        }
    }
}

