/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.charge;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerChargeBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryTestHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.reporting.charge.AbstractChargesQuery;
import org.openvpms.web.workspace.reporting.charge.IncompleteChargesQuery;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractChargesQueryTest
extends AbstractAppTest {
    private final boolean selectsPosted;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party customer;
    private Party patient;
    private Product product;

    protected AbstractChargesQueryTest(boolean selectsPosted) {
        this.selectsPosted = selectsPosted;
    }

    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient();
        this.product = this.productFactory.createMedication();
    }

    @Test
    public void testEmptyQuery() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        Party practice = (Party)this.practiceFactory.newPractice().locations(new Party[]{location1, location2, location3}).build();
        User user = (User)this.userFactory.newUser().addLocations(new Party[]{location1}).build();
        context.setUser(user);
        context.setPractice(practice);
        AbstractChargesQuery query = this.createQuery((Context)context);
        query.setLocation(location1);
        QueryTestHelper.checkEmpty((Query)query);
        FinancialAct invoice = this.createInvoice(location2, null, "IN_PROGRESS");
        FinancialAct counter = this.createCounter(location2, "IN_PROGRESS");
        FinancialAct credit = this.createCredit(location3, null, "IN_PROGRESS");
        this.save((IMObject)invoice);
        this.save((IMObject)counter);
        this.save((IMObject)credit);
        QueryTestHelper.checkEmpty((Query)query);
    }

    @Test
    public void testQueryByLocation() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        Party practice = (Party)this.practiceFactory.newPractice().locations(new Party[]{location1, location2, location3}).build();
        User user = (User)this.userFactory.newUser().addLocations(new Party[]{location1, location2}).build();
        context.setUser(user);
        context.setPractice(practice);
        AbstractChargesQuery query = this.createQuery((Context)context);
        query.setLocation(null);
        FinancialAct invoice1 = this.createInvoice(null, null, "IN_PROGRESS");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{invoice1});
        this.checkNoLocationInvoices(query, IncompleteChargesQuery.ARCHETYPES);
        FinancialAct invoice2 = this.createInvoice(location1, null, "IN_PROGRESS");
        FinancialAct counter = this.createCounter(location2, "IN_PROGRESS");
        FinancialAct credit = this.createCredit(location3, null, "IN_PROGRESS");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{invoice1, invoice2, counter});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{credit});
        query.setLocation(location1);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{invoice2});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{invoice1, counter, credit});
    }

    @Test
    public void testQueryByLocationForUserWithNoLocations() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        User user = this.userFactory.createUser();
        Party practice = (Party)this.practiceFactory.newPractice().locations(new Party[]{location1, location2}).build();
        context.setUser(user);
        context.setPractice(practice);
        AbstractChargesQuery query = this.createQuery((Context)context);
        query.setLocation(null);
        this.checkNoLocationInvoices(query, IncompleteChargesQuery.ARCHETYPES);
        FinancialAct invoice = this.createInvoice(location1, null, "IN_PROGRESS");
        FinancialAct counter = this.createCounter(location2, "IN_PROGRESS");
        FinancialAct credit = this.createCredit(location3, null, "IN_PROGRESS");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{invoice, counter});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{credit});
        query.setLocation(location1);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{invoice});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{counter, credit});
    }

    @Test
    public void testQueryByStatus() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        User user = (User)this.userFactory.newUser().addLocations(new Party[]{location1}).build();
        context.setUser(user);
        AbstractChargesQuery query = this.createQuery((Context)context);
        FinancialAct inProgress = this.createInvoice(location1, null, "IN_PROGRESS");
        FinancialAct completed = this.createInvoice(location1, null, "COMPLETED");
        FinancialAct onHold = this.createInvoice(location1, null, "ON_HOLD");
        FinancialAct posted = this.createInvoice(location1, null, "POSTED");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{inProgress, completed, onHold});
        if (this.selectsPosted) {
            QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{posted});
        } else {
            QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{posted});
        }
        query.setStatus("IN_PROGRESS");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{inProgress});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{completed, onHold, posted});
    }

    @Test
    public void testQueryByClinician() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        User user = this.userFactory.createUser();
        context.setUser(user);
        User clinician1 = this.userFactory.createClinician();
        User clinician2 = this.userFactory.createClinician();
        FinancialAct invoice1 = this.createInvoice(location1, clinician1, "IN_PROGRESS");
        FinancialAct invoice2 = this.createInvoice(location1, clinician2, "COMPLETED");
        FinancialAct invoice3 = this.createInvoice(location1, null, "ON_HOLD");
        FinancialAct invoice4 = this.createInvoice(location1, clinician1, "POSTED");
        FinancialAct credit1 = this.createCredit(location1, clinician1, "IN_PROGRESS");
        FinancialAct credit2 = this.createCredit(location1, clinician2, "POSTED");
        FinancialAct counter1 = this.createCounter(location1, "IN_PROGRESS");
        FinancialAct counter2 = this.createCounter(location1, "POSTED");
        AbstractChargesQuery query = this.createQuery((Context)context);
        query.setClinician(clinician1);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{invoice1, credit1});
        if (this.selectsPosted) {
            QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{invoice4});
        } else {
            QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{invoice4});
        }
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{invoice2, invoice3, credit2, counter1, counter2});
        query.setClinician(clinician2);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{invoice2});
        if (this.selectsPosted) {
            QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{credit2});
        } else {
            QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{credit2});
        }
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{invoice1, invoice3, invoice4, credit1, counter1, counter2});
    }

    protected abstract AbstractChargesQuery createQuery(Context var1);

    private void checkNoLocationInvoices(AbstractChargesQuery query, String ... shortNames) {
        ResultSet set = query.query();
        ResultSetIterator iterator = new ResultSetIterator(set);
        while (iterator.hasNext()) {
            FinancialAct act = (FinancialAct)iterator.next();
            IMObjectBean bean = this.getBean((IMObject)act);
            Assert.assertTrue((boolean)bean.isA(shortNames));
            Assert.assertNull((Object)bean.getTargetRef("location"));
        }
    }

    private FinancialAct createInvoice(Party location, User clinician, String status) {
        return this.createCharge((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newInvoice(), location, clinician, status);
    }

    private FinancialAct createCredit(Party location, User clinician, String status) {
        return this.createCharge((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newCredit(), location, clinician, status);
    }

    private FinancialAct createCharge(TestCustomerChargeBuilder<?, ?> builder, Party location, User clinician, String status) {
        boolean counter = builder instanceof TestCounterSaleBuilder;
        return (FinancialAct)((TestCustomerChargeBuilder)((TestCustomerChargeBuilder)((TestCustomerChargeBuilder)builder.customer(this.customer)).location(location)).clinician(clinician).status(status)).item().patient(counter ? null : this.patient).product(this.product).add().build();
    }

    private FinancialAct createCounter(Party location, String status) {
        return this.createCharge((TestCustomerChargeBuilder<?, ?>)this.accountFactory.newCounterSale(), location, null, status);
    }
}

