/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.product;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.product.ProductQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.product.ProductCRUDWindow;

public class ProductCRUDWindowTestCase
extends AbstractAppTest {
    private ArchetypeAwareGrantedAuthority all;
    private ArchetypeAwareGrantedAuthority createAll;
    private ArchetypeAwareGrantedAuthority saveAll;
    private ArchetypeAwareGrantedAuthority removeAll;
    private ArchetypeAwareGrantedAuthority createProducts;
    private ArchetypeAwareGrantedAuthority saveProducts;
    private ArchetypeAwareGrantedAuthority removeProducts;

    @Before
    public void setUp() {
        super.setUp();
        this.all = this.createAuthority("*", "*");
        this.createAll = this.createAuthority("create", "*");
        this.saveAll = this.createAuthority("save", "*");
        this.removeAll = this.createAuthority("remove", "*");
        this.createProducts = this.createAuthority("create", "product.*");
        this.saveProducts = this.createAuthority("save", "product.*");
        this.removeProducts = this.createAuthority("remove", "product.*");
    }

    @Test
    public void checkButtonPermissions() {
        ProductCRUDWindow window1 = this.createWindow("ADMINISTRATOR", new ArchetypeAwareGrantedAuthority[0]);
        this.checkButton(window1, "button.new", false);
        this.checkButton(window1, "view", true);
        this.checkButton(window1, "button.edit", false);
        this.checkButton(window1, "button.delete", false);
        this.checkButton(window1, "copy", false);
        this.checkButton(window1, "button.export", false);
        this.checkButton(window1, "button.import", false);
        this.checkButton(window1, "button.synchwithsfs", false);
        ProductCRUDWindow window2 = this.createWindow(null, this.all);
        this.checkButton(window2, "button.new", true);
        this.checkButton(window2, "view", true);
        this.checkButton(window2, "button.edit", true);
        this.checkButton(window2, "button.delete", true);
        this.checkButton(window2, "copy", true);
        this.checkButton(window2, "button.export", true);
        this.checkButton(window2, "button.import", true);
        this.checkButton(window2, "button.synchwithsfs", true);
        ProductCRUDWindow window3 = this.createWindow(null, this.createAll, this.saveAll, this.removeAll);
        this.checkButton(window3, "button.new", true);
        this.checkButton(window3, "view", true);
        this.checkButton(window3, "button.edit", true);
        this.checkButton(window3, "button.delete", true);
        this.checkButton(window3, "copy", true);
        this.checkButton(window3, "button.export", true);
        this.checkButton(window3, "button.import", true);
        this.checkButton(window3, "button.synchwithsfs", true);
        ProductCRUDWindow window4 = this.createWindow(null, this.createProducts, this.saveProducts, this.removeProducts);
        this.checkButton(window4, "button.new", true);
        this.checkButton(window4, "view", true);
        this.checkButton(window4, "button.edit", true);
        this.checkButton(window4, "button.delete", true);
        this.checkButton(window4, "copy", true);
        this.checkButton(window4, "button.export", true);
        this.checkButton(window4, "button.import", true);
        this.checkButton(window4, "button.synchwithsfs", true);
        ProductCRUDWindow window5 = this.createWindow(null, this.createProducts, this.saveProducts);
        this.checkButton(window5, "button.new", true);
        this.checkButton(window5, "view", true);
        this.checkButton(window5, "button.edit", true);
        this.checkButton(window5, "button.delete", false);
        this.checkButton(window5, "copy", true);
        this.checkButton(window5, "button.export", false);
        this.checkButton(window5, "button.import", false);
        this.checkButton(window5, "button.synchwithsfs", false);
        ProductCRUDWindow window6 = this.createWindow(null, this.createProducts);
        this.checkButton(window6, "button.new", false);
        this.checkButton(window6, "view", true);
        this.checkButton(window6, "button.edit", false);
        this.checkButton(window6, "button.delete", false);
        this.checkButton(window6, "copy", false);
        this.checkButton(window6, "button.export", false);
        this.checkButton(window6, "button.import", false);
        this.checkButton(window6, "button.synchwithsfs", false);
        ProductCRUDWindow window7 = this.createWindow(null, this.saveProducts);
        this.checkButton(window7, "button.new", false);
        this.checkButton(window7, "view", true);
        this.checkButton(window7, "button.edit", false);
        this.checkButton(window7, "button.delete", false);
        this.checkButton(window7, "copy", false);
        this.checkButton(window7, "button.export", false);
        this.checkButton(window7, "button.import", false);
        this.checkButton(window7, "button.synchwithsfs", false);
        ArchetypeAwareGrantedAuthority createMedication = this.createAuthority("create", "product.medication");
        ArchetypeAwareGrantedAuthority saveMedication = this.createAuthority("save", "product.medication");
        ProductCRUDWindow window8 = this.createWindow(null, createMedication, saveMedication);
        this.checkButton(window8, "button.new", false);
        this.checkButton(window8, "view", true);
        this.checkButton(window8, "button.edit", false);
        this.checkButton(window8, "button.delete", false);
        this.checkButton(window8, "copy", false);
        this.checkButton(window8, "button.export", false);
        this.checkButton(window8, "button.import", false);
        this.checkButton(window8, "button.synchwithsfs", false);
    }

    private void checkButton(ProductCRUDWindow window, String buttonId, boolean exists) {
        Button button = EchoTestHelper.findButton((Component)window.getComponent(), (String)buttonId);
        if (exists) {
            Assert.assertNotNull((Object)button);
        } else {
            Assert.assertNull((Object)button);
        }
    }

    private ProductCRUDWindow createWindow(String userType, ArchetypeAwareGrantedAuthority ... authorities) {
        User user = TestHelper.createUser((String)"foo", (boolean)false);
        if (userType != null) {
            user.addClassification(TestHelper.getLookup((String)"lookup.userType", (String)userType));
        }
        if (authorities.length != 0) {
            SecurityRole role = new SecurityRole();
            for (ArchetypeAwareGrantedAuthority authority : authorities) {
                role.addAuthority(authority);
            }
            ((org.openvpms.component.business.domain.im.security.User)user).addRole(role);
        }
        Party location = (Party)this.create("party.organisationLocation", Party.class);
        LocalContext context = new LocalContext();
        context.setUser(user);
        context.setLocation(location);
        Archetypes archetypes = Archetypes.create((String)"product.*", Product.class);
        ProductQuery query = (ProductQuery)Mockito.mock(ProductQuery.class);
        ResultSet set = (ResultSet)Mockito.mock(ResultSet.class);
        final FlowSheetServiceFactory factory = (FlowSheetServiceFactory)Mockito.mock(FlowSheetServiceFactory.class);
        Mockito.when((Object)factory.isSmartFlowSheetEnabled(location)).thenReturn((Object)true);
        return new ProductCRUDWindow(archetypes, (Query)query, set, (Context)context, new HelpContext("foo", null)){

            protected FlowSheetServiceFactory getFlowSheetServiceFactory() {
                return factory;
            }
        };
    }

    private ArchetypeAwareGrantedAuthority createAuthority(String method, String archetype) {
        ArchetypeAwareGrantedAuthority authority = new ArchetypeAwareGrantedAuthority();
        authority.setServiceName("archetypeService");
        authority.setMethod(method);
        authority.setShortName(archetype);
        return authority;
    }
}

