/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.visit;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryCRUDWindow;
import org.openvpms.web.workspace.patient.history.PatientHistoryBrowser;
import org.openvpms.web.workspace.patient.history.PatientHistoryCRUDWindow;
import org.openvpms.web.workspace.patient.problem.ProblemBrowser;
import org.openvpms.web.workspace.patient.problem.ProblemRecordCRUDWindow;
import org.openvpms.web.workspace.patient.visit.VisitEditor;

public class VisitEditorTestCase
extends AbstractAppTest {
    private Context context;
    private Party customer;
    private Party patient;
    private FinancialAct invoice;

    @Before
    public void setUp() {
        super.setUp();
        this.context = new LocalContext((Context)ContextApplicationInstance.getInstance().getContext());
        Party practice = this.context.getPractice();
        Assert.assertNotNull((Object)practice);
        IMObjectBean bean = this.getBean((IMObject)practice);
        bean.setValue("showProblemsInVisit", (Object)true);
        this.customer = TestHelper.createCustomer();
        this.patient = TestHelper.createPatient((Party)this.customer);
        this.context.setPatient(this.patient);
        this.invoice = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        IMObjectBean invoiceBean = this.getBean((IMObject)this.invoice);
        invoiceBean.setTarget("customer", (IMObject)this.customer);
        invoiceBean.save();
    }

    @Test
    public void testInit() {
        PatientTestHelper.createEvent((Date)TestHelper.getDate((String)"2014-07-01"), (Party)this.patient, (Act[])new Act[0]);
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDate((String)"2014-07-20"), (Party)this.patient, (Act[])new Act[0]);
        VisitEditor editor = new VisitEditor(this.customer, this.patient, event, this.invoice, this.context, new HelpContext("dummy", null));
        editor.getComponent();
        Assert.assertEquals((Object)this.patient, (Object)editor.getPatient());
        Assert.assertEquals((Object)event, (Object)editor.getHistoryBrowser().getSelected());
        Assert.assertEquals((Object)event, (Object)editor.getHistoryWindow().getObject());
        Assert.assertEquals((Object)event, (Object)editor.getHistoryWindow().getEvent());
    }

    @Test
    public void testSelectHistory() {
        Date date1 = TestHelper.getDate((String)"2014-07-01");
        Act note1 = PatientTestHelper.createNote((Date)date1, (Party)this.patient);
        Act event1 = PatientTestHelper.createEvent((Date)date1, (Party)this.patient, (Act[])new Act[]{note1});
        Date date2 = TestHelper.getDate((String)"2014-07-02");
        Act note2 = PatientTestHelper.createNote((Date)date2, (Party)this.patient);
        Act event2 = PatientTestHelper.createEvent((Date)date2, (Party)this.patient, (Act[])new Act[]{note2});
        VisitEditor editor = new VisitEditor(this.customer, this.patient, event2, this.invoice, this.context, new HelpContext("dummy", null));
        editor.getComponent();
        PatientHistoryBrowser history = editor.getHistoryBrowser();
        history.setSelected(event1);
        this.checkHistorySelection(event1, event1, editor);
        history.setSelected(note1);
        this.checkHistorySelection(note1, event1, editor);
        history.setSelected(event2);
        this.checkHistorySelection(event2, event2, editor);
        history.setSelected(note2);
        this.checkHistorySelection(note2, event2, editor);
    }

    @Test
    public void testSelectProblems() {
        Date date1 = TestHelper.getDate((String)"2014-07-01");
        Act note1 = PatientTestHelper.createNote((Date)date1, (Party)this.patient);
        Act problem1 = PatientTestHelper.createProblem((Date)date1, (Party)this.patient, (Act[])new Act[]{note1});
        Act event1 = PatientTestHelper.createEvent((Date)date1, (Party)this.patient, (Act[])new Act[]{problem1, note1});
        Date date2 = TestHelper.getDate((String)"2014-07-02");
        Act note2 = PatientTestHelper.createNote((Date)date2, (Party)this.patient);
        Act problem2 = PatientTestHelper.createProblem((Date)date2, (Party)this.patient, (Act[])new Act[]{note2});
        Act event2 = PatientTestHelper.createEvent((Date)date2, (Party)this.patient, (Act[])new Act[]{problem2, note2});
        VisitEditor editor = new VisitEditor(this.customer, this.patient, event2, this.invoice, this.context, new HelpContext("dummy", null));
        editor.getComponent();
        editor.selectTab(1);
        this.checkProblemSelection(null, null, null, editor);
        ProblemBrowser browser = editor.getProblemBrowser();
        browser.setSelected(problem1);
        this.checkProblemSelection(problem1, problem1, event1, editor);
        browser.setSelected(note1);
        this.checkProblemSelection(note1, problem1, event1, editor);
        browser.setSelected(event1);
        this.checkProblemSelection(event1, problem1, event1, editor);
        browser.setSelected(event2);
        this.checkProblemSelection(event2, problem2, event2, editor);
    }

    @Test
    public void testHyperlinks() {
        Date date1 = TestHelper.getDate((String)"2014-07-01");
        Act note1 = PatientTestHelper.createNote((Date)date1, (Party)this.patient);
        Act problem1 = PatientTestHelper.createProblem((Date)date1, (Party)this.patient, (Act[])new Act[]{note1});
        Act event1 = PatientTestHelper.createEvent((Date)date1, (Party)this.patient, (Act[])new Act[]{problem1});
        Date date2 = TestHelper.getDate((String)"2014-07-02");
        Act note2 = PatientTestHelper.createNote((Date)date2, (Party)this.patient);
        Act problem2 = PatientTestHelper.createProblem((Date)date2, (Party)this.patient, (Act[])new Act[]{note2});
        Act event2 = PatientTestHelper.createEvent((Date)date2, (Party)this.patient, (Act[])new Act[]{problem2});
        VisitEditor editor = new VisitEditor(this.customer, this.patient, event2, this.invoice, this.context, new HelpContext("dummy", null));
        editor.getComponent();
        editor.followHyperlink((IMObject)problem1);
        this.checkProblemSelection(problem1, problem1, event1, editor);
        editor.followHyperlink((IMObject)event2);
        this.checkHistorySelection(event2, event2, editor);
        editor.followHyperlink((IMObject)problem2);
        this.checkProblemSelection(problem2, problem2, event2, editor);
    }

    private void checkHistorySelection(Act object, Act event, VisitEditor editor) {
        PatientHistoryBrowser selectedBrowser = editor.getHistoryBrowser();
        Assert.assertEquals((Object)object, (Object)selectedBrowser.getSelected());
        Assert.assertEquals((Object)event, (Object)selectedBrowser.getSelectedParent());
        AbstractPatientHistoryCRUDWindow window = editor.getHistoryWindow();
        Assert.assertTrue((boolean)(window instanceof PatientHistoryCRUDWindow));
        Assert.assertEquals((Object)object, (Object)window.getObject());
        Assert.assertEquals((Object)event, (Object)((PatientHistoryCRUDWindow)window).getEvent());
    }

    private void checkProblemSelection(Act object, Act problem, Act event, VisitEditor editor) {
        ProblemBrowser browser = editor.getProblemBrowser();
        Assert.assertNotNull((Object)browser);
        Assert.assertEquals((Object)object, (Object)browser.getSelected());
        Assert.assertEquals((Object)problem, (Object)browser.getSelectedParent());
        ProblemRecordCRUDWindow window = editor.getProblemWindow();
        Assert.assertNotNull((Object)window);
        Assert.assertEquals((Object)object, (Object)window.getObject());
        Assert.assertEquals((Object)problem, (Object)window.getProblem());
        Assert.assertEquals((Object)event, (Object)window.getEvent());
    }
}

