/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.summary;

import java.util.Date;
import nextapp.echo2.app.Component;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.prefs.UserPreferences;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.CustomerPatientSummary;

public class CustomerPatientSummaryTestCase
extends AbstractAppTest {
    @Test
    public void testContext() {
        Party globalCustomer = TestHelper.createCustomer();
        Party globalPatient = TestHelper.createPatient((Party)globalCustomer);
        Party customer1 = TestHelper.createCustomer();
        Party customer2 = TestHelper.createCustomer();
        Party patient2 = TestHelper.createPatient((Party)customer2);
        Party patient3 = TestHelper.createPatient();
        GlobalContext global = ContextApplicationInstance.getInstance().getContext();
        global.setCustomer(globalCustomer);
        global.setPatient(globalPatient);
        UserPreferences preferences = ContextApplicationInstance.getInstance().getPreferences();
        Party location = TestHelper.createLocation();
        Party schedule = ScheduleTestHelper.createSchedule((Party)location);
        Act appointment = ScheduleTestHelper.createAppointment((Date)new Date(), (Entity)schedule, (Party)customer1, null, (String)"PENDING");
        TestCustomerPatientSummary summary1 = new TestCustomerPatientSummary((Context)global, (Preferences)preferences);
        summary1.getSummary(appointment);
        Assert.assertNotNull((Object)summary1.customerContext);
        Assert.assertEquals((Object)customer1, (Object)summary1.customerContext.getCustomer());
        Assert.assertNull((Object)summary1.customerContext.getPatient());
        Assert.assertNull((Object)summary1.patientContext);
        TestCustomerPatientSummary summary2 = new TestCustomerPatientSummary((Context)global, (Preferences)preferences);
        summary2.getSummary(patient2);
        Assert.assertNotNull((Object)summary2.customerContext);
        Assert.assertEquals((Object)customer2, (Object)summary2.customerContext.getCustomer());
        Assert.assertNotNull((Object)summary2.patientContext);
        Assert.assertEquals((Object)patient2, (Object)summary2.customerContext.getPatient());
        TestCustomerPatientSummary summary3 = new TestCustomerPatientSummary((Context)global, (Preferences)preferences);
        summary3.getSummary(patient3);
        Assert.assertNull((Object)summary3.customerContext);
        Assert.assertNotNull((Object)summary3.patientContext);
    }

    private static class TestCustomerPatientSummary
    extends CustomerPatientSummary {
        private Context customerContext;
        private Context patientContext;

        public TestCustomerPatientSummary(Context context, Preferences preferences) {
            super(context, new HelpContext("foo", null), preferences);
        }

        protected Component getCustomerSummary(Party customer, Context context) {
            this.customerContext = context;
            return super.getCustomerSummary(customer, context);
        }

        protected Component getPatientSummary(Party patient, Context context) {
            this.patientContext = context;
            return super.getPatientSummary(patient, context);
        }
    }
}

