/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr.prescription;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.patient.prescription.PrescriptionTestHelper;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.AbstractCustomerChargeActEditorTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeTestHelper;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.patient.mr.prescription.PrescriptionDispenser;

public class PrescriptionDispenserTestCase
extends AbstractCustomerChargeActEditorTest {
    private final List<String> errors = new ArrayList<String>();
    private Context context;
    private Party patient;
    private Party customer;
    private User clinician;
    private User author;
    private Product product;
    private BigDecimal unitCost;
    private Act prescription;
    private Runnable completionListener;
    private int completionCount;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.context = new LocalContext();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.author = this.userFactory.createUser();
        this.clinician = this.userFactory.createClinician();
        this.context.setPractice(this.getPractice());
        this.context.setLocation(this.practiceFactory.createLocation());
        this.context.setUser(this.author);
        this.context.setClinician(this.clinician);
        Entity discountType = (Entity)this.productFactory.newDiscount().percentage(50).discountFixedPrice(true).build();
        BigDecimal fixedPriceExTax = BigDecimal.valueOf(3L);
        BigDecimal unitPriceExTax = new BigDecimal("0.10");
        this.unitCost = new BigDecimal("0.05");
        this.product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(BigDecimal.ZERO, fixedPriceExTax)).unitPrice(this.unitCost, unitPriceExTax)).addDiscounts(new Entity[]{discountType})).build();
        this.addDiscount((Entity)this.patient, discountType);
        this.prescription = PrescriptionTestHelper.createPrescription((Party)this.patient, (Product)this.product, (User)this.clinician, (int)10);
        this.initErrorHandler(this.errors);
        this.completionListener = () -> ++this.completionCount;
        new AuthenticationContextImpl().setUser(this.author);
    }

    @Test
    public void testDispense() {
        TestDispenser dispenser = new TestDispenser(this.context);
        dispenser.dispense(this.prescription, this.customer, this.completionListener);
        this.checkInvoice(dispenser, this.clinician);
        Assert.assertEquals((long)1L, (long)this.completionCount);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testDispenseAddsToExistingInvoice() {
        List existing = FinancialTestHelper.createChargesInvoice((Party)this.customer, (User)this.clinician, (String)"IN_PROGRESS", (FinancialAct[])new FinancialAct[0]);
        this.save(existing);
        TestDispenser dispenser = new TestDispenser(this.context);
        dispenser.dispense(this.prescription, this.customer, this.completionListener);
        FinancialAct invoice = dispenser.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertEquals(existing.get(0), (Object)invoice);
        Assert.assertEquals((long)1L, (long)this.completionCount);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testDispenseDeactivatedProduct() {
        this.product.setActive(false);
        this.save((IMObject)this.product);
        TestDispenser dispenser = new TestDispenser(this.context);
        dispenser.dispense(this.prescription, this.customer, this.completionListener);
        FinancialAct invoice = dispenser.getInvoice();
        Assert.assertNull((Object)invoice);
        Assert.assertEquals((long)0L, (long)this.completionCount);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"This medication cannot be dispensed as it is inactive.", (Object)this.errors.get(0));
    }

    @Test
    public void testDispenseForProductNotAtLocation() {
        this.practiceFactory.updatePractice(this.getPractice()).useLocationProducts(true).build();
        TestDispenser dispenser = new TestDispenser(this.context);
        dispenser.dispense(this.prescription, this.customer, this.completionListener);
        FinancialAct invoice = dispenser.getInvoice();
        Assert.assertNull((Object)invoice);
        Assert.assertEquals((long)0L, (long)this.completionCount);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)(this.product.getName() + " cannot be dispensed at this location."), (Object)this.errors.get(0));
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[]{this.context.getLocation()});
        this.productFactory.updateProduct(this.product).newProductStockLocation().stockLocation(stockLocation).add().build();
        this.errors.clear();
        dispenser.dispense(this.prescription, this.customer, this.completionListener);
        Assert.assertNotNull((Object)dispenser.getInvoice());
        Assert.assertEquals((long)1L, (long)this.completionCount);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testDispenseForProductNotAtInvoiceLocation() {
        this.practiceFactory.updatePractice(this.getPractice()).useLocationProducts(true).build();
        List existing = FinancialTestHelper.createChargesInvoice((Party)this.customer, (User)this.clinician, (String)"IN_PROGRESS", (FinancialAct[])new FinancialAct[0]);
        IMObjectBean bean = this.getBean((IMObject)existing.get(0));
        Party location2 = this.practiceFactory.createLocation();
        bean.setTarget("location", (IMObject)location2);
        bean.save();
        TestDispenser dispenser = new TestDispenser(this.context);
        dispenser.dispense(this.prescription, this.customer, this.completionListener);
        FinancialAct invoice = dispenser.getInvoice();
        Assert.assertNull((Object)invoice);
        Assert.assertEquals((long)0L, (long)this.completionCount);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)(this.product.getName() + " cannot be dispensed at the invoice location, " + location2.getName() + "."), (Object)this.errors.get(0));
    }

    @Test
    public void testDispenseToChargeEditor() {
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layout.setEdit(true);
        List acts = FinancialTestHelper.createChargesInvoice((Party)this.customer, (User)this.clinician, (String)"IN_PROGRESS", (FinancialAct[])new FinancialAct[0]);
        DefaultCustomerChargeActEditor editor = new DefaultCustomerChargeActEditor((FinancialAct)acts.get(0), null, (LayoutContext)layout, false);
        editor.getComponent();
        TestDispenser dispenser = new TestDispenser(this.context);
        dispenser.dispense(this.prescription, (CustomerChargeActEditor)editor, this.completionListener);
        this.checkInvoice(dispenser, this.clinician);
        Assert.assertTrue((boolean)this.errors.isEmpty());
        Assert.assertEquals((long)1L, (long)this.completionCount);
    }

    @Test
    public void testDispenseWithoutClinician() {
        this.context.setClinician(null);
        TestDispenser dispenser = new TestDispenser(this.context);
        dispenser.dispense(this.prescription, this.customer, this.completionListener);
        this.checkInvoice(dispenser, null);
        Assert.assertEquals((long)1L, (long)this.completionCount);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testCancelDispense() {
        this.initErrorHandler(this.errors);
        TestDispenser dispenser = new TestDispenser(true, this.context);
        dispenser.dispense(this.prescription, this.customer, this.completionListener);
        FinancialAct invoice = dispenser.getInvoice();
        Assert.assertNotNull((Object)invoice);
        Assert.assertNull((Object)this.get((IMObject)invoice));
        Assert.assertEquals((long)0L, (long)this.completionCount);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    private void checkInvoice(TestDispenser dispenser, User clinician) {
        FinancialAct invoice = dispenser.getInvoice();
        Assert.assertNotNull((Object)invoice);
        List items = this.getBean((IMObject)invoice).getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        BigDecimal fixedPrice = new BigDecimal("3.30");
        BigDecimal unitPrice = new BigDecimal("0.11");
        BigDecimal total = new BigDecimal("2.20");
        BigDecimal discount = new BigDecimal("2.20");
        BigDecimal tax = new BigDecimal("0.20");
        FinancialTestHelper.checkItem((FinancialAct)((FinancialAct)items.get(0)), (String)"act.customerAccountInvoiceItem", (Party)this.patient, (Product)this.product, null, (int)-1, (User)this.author, (User)clinician, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.TEN, (BigDecimal)this.unitCost, (BigDecimal)unitPrice, (BigDecimal)BigDecimal.ZERO, (BigDecimal)fixedPrice, (BigDecimal)discount, (BigDecimal)tax, (BigDecimal)total, (boolean)true);
        this.checkCharge(invoice, this.customer, this.author, clinician, tax, total);
    }

    private static class TestDispenser
    extends PrescriptionDispenser {
        private final boolean cancel;
        private FinancialAct invoice;

        public TestDispenser(Context context) {
            this(false, context);
        }

        public TestDispenser(boolean cancel, Context context) {
            super(context, new HelpContext("foo", null));
            this.cancel = cancel;
        }

        public FinancialAct getInvoice() {
            return this.invoice;
        }

        protected CustomerChargeActItemEditor dispense(PrescriptionDispenser.Prescription prescription, CustomerChargeActEditor editor, Runnable completionListener) {
            this.invoice = editor.getObject();
            CustomerChargeActItemEditor item = super.dispense(prescription, editor, completionListener);
            EditorQueue queue = item.getEditorQueue();
            if (this.cancel) {
                PopupDialog dialog = queue.getCurrent();
                Assert.assertTrue((boolean)(dialog instanceof EditDialog));
                IMObjectEditor medication = ((EditDialog)dialog).getEditor();
                Assert.assertTrue((boolean)medication.getObject().isA("act.patientMedication"));
                Assert.assertTrue((boolean)medication.isValid());
                EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"cancel");
            } else {
                CustomerChargeTestHelper.checkSavePopup(queue, "act.patientMedication", false);
            }
            return item;
        }
    }
}

