/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.insurance.claim.GapPaymentEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class GapPaymentEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testPaymentProcessorItemsExcluded() {
        FinancialAct payment = (FinancialAct)this.create("act.customerAccountPayment", FinancialAct.class);
        GapPaymentEditor editor = this.createEditor(payment, BigDecimal.TEN, this.practiceFactory.createLocation(), this.practiceFactory.createTill(), true);
        CollectionProperty items = editor.getCollectionProperty("items");
        Assert.assertNotNull((Object)items);
        List<String> archetypes = Arrays.asList(items.getArchetypeRange());
        Assert.assertFalse((boolean)archetypes.contains("act.customerAccountPaymentPP"));
        Assert.assertFalse((boolean)archetypes.contains("act.customerAccountRefundPP"));
    }

    private GapPaymentEditor createEditor(FinancialAct act, BigDecimal invoice, Party location, Entity till, boolean tillRequired) {
        LocalContext localContext = new LocalContext();
        DefaultLayoutContext context = new DefaultLayoutContext((Context)localContext, new HelpContext("foo", null));
        context.setEdit(true);
        GapPaymentEditor editor = new GapPaymentEditor(act, null, (LayoutContext)context, invoice, location, till, tillRequired);
        editor.getComponent();
        return editor;
    }
}

