/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import nextapp.echo2.app.ApplicationInstance;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.insurance.TestClaimBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestAttachmentBuilder;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.insurance.claim.Attachment;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.report.DocumentConverter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.patient.history.PatientHistoryIterator;
import org.openvpms.web.workspace.patient.insurance.claim.AttachmentCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.Charges;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimAttachmentGenerator;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimContext;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimItemCollectionEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class ClaimAttachmentGeneratorTestCase
extends AbstractAppTest {
    @Autowired
    private InsuranceRules insuranceRules;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestInsuranceFactory insuranceFactory;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party customer;
    private Party patient;
    private Party location;
    private Party insurer;
    private Act policy;

    @Before
    public void setUp() {
        super.setUp();
        ((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().singletonByType().type("INSURANCE_CLAIM_MEDICAL_RECORDS").name("Medical Records")).document(this.documentFactory.createJRXML("Medical Records.jrxml"))).build();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.insurer = this.insuranceFactory.createInsurer();
        this.policy = this.insuranceFactory.createPolicy(this.customer, this.patient, this.insurer, "123456789");
        this.location = this.practiceFactory.createLocation();
    }

    @Test
    public void testFormGeneration() {
        Entity formTemplate = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").name("Z Form")).blankDocument()).build();
        DocumentAct form = this.patientFactory.createForm(this.patient, formTemplate);
        ((TestVisitBuilder)this.patientFactory.newVisit().patient(this.patient)).addItem((Act)form).build();
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().item().treatmentDates(new Date(), new Date()).add().attachment((Act)form).build();
        this.checkGenerate(claim, null, "Patient Form", "Z Form.pdf", null);
    }

    @Test
    public void testFormGenerationWithoutTemplate() {
        Entity formTemplate = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").name("Z Form")).build();
        DocumentAct form = this.patientFactory.createForm(this.patient, formTemplate);
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().item().treatmentDates(new Date(), new Date()).add().attachment((Act)form).build();
        this.checkGenerate(claim, null, "Patient Form", null, "REPORT-0032: Template has no document: Z Form");
    }

    @Test
    public void testPatientAttachmentGeneration() {
        Document pdf = this.documentFactory.createPDF("report.pdf");
        DocumentAct attachment = (DocumentAct)((TestAttachmentBuilder)((TestAttachmentBuilder)this.patientFactory.newAttachment().patient(this.patient)).document(pdf)).build();
        ((TestVisitBuilder)this.patientFactory.newVisit().patient(this.patient)).addItem((Act)attachment).build();
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().item().treatmentDates(new Date(), new Date()).add().attachment((Act)attachment).build();
        Document generated = this.checkGenerate(claim, null, "Patient Attachment", "report.pdf", null);
        Assert.assertNotNull((Object)generated);
        Assert.assertNotEquals((Object)pdf, (Object)generated);
    }

    @Test
    public void testConvertODTToPDF() {
        Document odt = this.documentFactory.createODT("report.odt");
        DocumentAct attachment = (DocumentAct)((TestAttachmentBuilder)((TestAttachmentBuilder)this.patientFactory.newAttachment().patient(this.patient)).document(odt)).build();
        ((TestVisitBuilder)this.patientFactory.newVisit().patient(this.patient)).addItem((Act)attachment).build();
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().item().treatmentDates(new Date(), new Date()).add().attachment((Act)attachment).build();
        Document generated = this.checkGenerate(claim, null, "Patient Attachment", "report.pdf", null);
        Assert.assertNotNull((Object)generated);
        Assert.assertNotEquals((Object)odt, (Object)generated);
        Assert.assertEquals((Object)"application/pdf", (Object)generated.getMimeType());
    }

    @Test
    public void testConvertDOCToPDF() {
        Document doc = this.documentFactory.createDOC("report.doc");
        DocumentAct investigation = (DocumentAct)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(this.patient)).investigationType(this.laboratoryFactory.createInvestigationType()).report(doc).build();
        ((TestVisitBuilder)this.patientFactory.newVisit().patient(this.patient)).addItem((Act)investigation).build();
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().item().treatmentDates(new Date(), new Date()).add().attachment((Act)investigation).build();
        Document generated = this.checkGenerate(claim, null, "Patient Investigation", "report.pdf", null);
        Assert.assertNotNull((Object)generated);
        Assert.assertNotEquals((Object)doc, (Object)generated);
        Assert.assertEquals((Object)"application/pdf", (Object)generated.getMimeType());
    }

    @Test
    public void testInvoiceGeneration() {
        ((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().singletonByType().type("INSURANCE_CLAIM_INVOICE").name("Invoice")).blankDocument()).build();
        TestInvoiceBuilder invoiceBuilder = this.accountFactory.newInvoice();
        FinancialAct invoice = (FinancialAct)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)invoiceBuilder.customer(this.customer)).item().patient(this.patient)).product(this.productFactory.createService())).unitPrice(10)).add()).build();
        FinancialAct invoiceItem = (FinancialAct)invoiceBuilder.getItems().get(0);
        ((TestVisitBuilder)this.patientFactory.newVisit().patient(this.patient)).addChargeItems(new FinancialAct[]{invoiceItem}).build();
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().item(new FinancialAct[]{invoiceItem}).build();
        this.checkGenerate(claim, invoiceItem, "Customer Invoice " + invoice.getId(), "Invoice.pdf", null);
    }

    @Test
    public void testPatientAttachmentWithoutDocument() {
        DocumentAct attachment = (DocumentAct)((TestAttachmentBuilder)this.patientFactory.newAttachment().patient(this.patient)).build();
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().item().treatmentDates(new Date(), new Date()).add().attachment((Act)attachment).build();
        this.checkGenerate(claim, null, "Patient Attachment", null, "The Attachment has no document.");
    }

    @Test
    public void testDeleteSourceDocument() {
        Entity template = this.documentFactory.createTemplate("act.patientDocumentForm");
        DocumentAct form = this.patientFactory.createForm(this.patient, template);
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().item().treatmentDates(new Date(), new Date()).add().attachment((Act)form).build();
        this.remove((IMObject)form);
        this.checkGenerate(claim, null, "Patient Form", null, "The original document has been deleted.");
    }

    @Test
    public void testInvestigationGeneration() {
        DocumentAct investigation = (DocumentAct)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(this.patient)).investigationType(this.laboratoryFactory.createInvestigationType()).report(this.documentFactory.createPDF("Results.pdf")).build();
        ((TestVisitBuilder)this.patientFactory.newVisit().patient(this.patient)).addItem((Act)investigation).build();
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().item().treatmentDates(new Date(), new Date()).add().attachment((Act)investigation).build();
        this.checkGenerate(claim, null, "Patient Investigation", "Results.pdf", null);
    }

    @Test
    public void testInvestigationWithoutDocument() {
        DocumentAct investigation = (DocumentAct)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(this.patient)).investigationType(this.laboratoryFactory.createInvestigationType()).build();
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().item().treatmentDates(new Date(), new Date()).add().attachment((Act)investigation).build();
        this.checkGenerate(claim, null, "Patient Investigation", null, "The Investigation has no document.");
    }

    @Test
    public void testHistoryWithNoPriorClaim() {
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().date("2025-04-16 11:32:06").item().treatmentDates("2025-04-16 11:32:25", "2025-04-16 11:32:27").add().build();
        Charges charges = this.createCharges(claim);
        LocalContext context = new LocalContext();
        ClaimAttachmentGenerator generator = this.createClaimAttachmentGenerator(charges, (Context)context);
        ClaimItemCollectionEditor items = this.createClaimItemCollectionEditor(claim, (Context)context, charges);
        this.checkIterator(generator.getHistory((Act)claim, items, this.insurer), new Act[0]);
        Act visit1 = this.createVisit("2025-01-24 11:43:46", "2025-01-24 11:53:40");
        Act visit2 = this.createVisit("2025-03-05 15:55:08", "2025-03-05 16:13:59");
        Act visit3 = this.createVisit("2025-04-16 11:11:02", "2025-04-16 11:31:55");
        this.createVisit("2025-04-16 16:00:00", "2025-04-16 16:10:00");
        this.checkIterator(generator.getHistory((Act)claim, items, this.insurer), visit3, visit2, visit1);
    }

    @Test
    public void testHistoryWithNoPriorClaimForTreatmentDatesEqualToVisit() {
        Act visit1 = this.createVisit("2025-01-24 11:43:46", "2025-01-24 11:53:40");
        Act visit2 = this.createVisit("2025-03-05 15:55:08", "2025-03-05 16:13:59");
        Act visit3 = this.createVisit("2025-04-16 11:11:02", "2025-04-16 11:31:55");
        this.createVisit("2025-04-16 16:00:00", "2025-04-16 16:10:00");
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().date("2025-04-16 11:32:06").item().treatmentDates(visit2.getActivityStartTime(), visit2.getActivityEndTime()).add().item().treatmentDates(visit3.getActivityStartTime(), visit3.getActivityEndTime()).add().build();
        Charges charges = this.createCharges(claim);
        LocalContext context = new LocalContext();
        ClaimAttachmentGenerator generator = this.createClaimAttachmentGenerator(charges, (Context)context);
        ClaimItemCollectionEditor items = this.createClaimItemCollectionEditor(claim, (Context)context, charges);
        this.checkIterator(generator.getHistory((Act)claim, items, this.insurer), visit3, visit2, visit1);
    }

    @Test
    public void testHistoryWithPriorClaimForInsurerWithInsuranceService() {
        this.insuranceFactory.updateInsurer(this.insurer).insuranceService(this.insuranceFactory.createInsuranceService()).build();
        Act visit1 = this.createVisit("2025-01-24 11:43:46", "2025-01-24 11:53:40");
        Act visit2 = this.createVisit("2025-03-05 15:55:08", "2025-03-05 16:13:59");
        FinancialAct claim1 = (FinancialAct)this.newClaimBuilder().date("2025-03-05 16:14:12").item().treatmentDates("2025-03-05 16:14:27", "2025-03-05 16:14:29").add().status("SETTLED").build();
        Charges charges1 = this.createCharges(claim1);
        LocalContext context1 = new LocalContext();
        ClaimAttachmentGenerator generator1 = this.createClaimAttachmentGenerator(charges1, (Context)context1);
        ClaimItemCollectionEditor items1 = this.createClaimItemCollectionEditor(claim1, (Context)context1, charges1);
        this.checkIterator(generator1.getHistory((Act)claim1, items1, this.insurer), visit2, visit1);
        Act visit3 = this.createVisit("2025-04-16 11:11:02", "2025-04-16 11:31:55");
        this.createVisit("2025-04-16 16:00:00", "2025-04-16 16:10:00");
        FinancialAct claim2 = (FinancialAct)this.newClaimBuilder().date("2025-04-16 11:32:06").item().treatmentDates("2025-04-16 11:32:25", "2025-04-16 11:32:27").add().build();
        Charges charges2 = this.createCharges(claim2);
        LocalContext context2 = new LocalContext();
        ClaimAttachmentGenerator generator2 = this.createClaimAttachmentGenerator(charges2, (Context)context2);
        ClaimItemCollectionEditor items2 = this.createClaimItemCollectionEditor(claim2, (Context)context2, charges2);
        this.checkIterator(generator2.getHistory((Act)claim2, items2, this.insurer), visit3);
    }

    @Test
    public void testHistoryForOutOfOrderClaims() {
        this.insuranceFactory.updateInsurer(this.insurer).insuranceService(this.insuranceFactory.createInsuranceService()).build();
        Act visit1 = this.createVisit("2025-01-24 11:43:46", "2025-01-24 11:53:40");
        Act visit2 = this.createVisit("2025-03-05 15:55:08", "2025-03-05 16:13:59");
        Act visit3 = this.createVisit("2025-04-16 11:11:02", "2025-04-16 11:31:55");
        Act visit4 = this.createVisit("2025-04-16 16:00:00", "2025-04-16 16:10:00");
        FinancialAct claim1 = (FinancialAct)this.newClaimBuilder().date("2025-01-24 12:00:00").item().treatmentDates(visit1.getActivityStartTime(), visit1.getActivityEndTime()).add().status("SETTLED").build();
        Charges charges1 = this.createCharges(claim1);
        LocalContext context1 = new LocalContext();
        ClaimAttachmentGenerator generator1 = this.createClaimAttachmentGenerator(charges1, (Context)context1);
        ClaimItemCollectionEditor items1 = this.createClaimItemCollectionEditor(claim1, (Context)context1, charges1);
        this.checkIterator(generator1.getHistory((Act)claim1, items1, this.insurer), visit1);
        FinancialAct claim2 = (FinancialAct)this.newClaimBuilder().date("2025-04-16 16:05:00").item().treatmentDates(visit4.getActivityStartTime(), visit4.getActivityEndTime()).add().build();
        Charges charges2 = this.createCharges(claim2);
        LocalContext context2 = new LocalContext();
        ClaimAttachmentGenerator generator2 = this.createClaimAttachmentGenerator(charges2, (Context)context2);
        ClaimItemCollectionEditor items2 = this.createClaimItemCollectionEditor(claim2, (Context)context2, charges2);
        this.checkIterator(generator2.getHistory((Act)claim2, items2, this.insurer), visit4, visit3, visit2);
        FinancialAct claim3 = (FinancialAct)this.newClaimBuilder().date("2025-04-16 11:35:05").item().treatmentDates(visit3.getActivityStartTime(), visit3.getActivityEndTime()).add().build();
        Charges charges3 = this.createCharges(claim3);
        LocalContext context3 = new LocalContext();
        ClaimAttachmentGenerator generator3 = this.createClaimAttachmentGenerator(charges3, (Context)context3);
        ClaimItemCollectionEditor items3 = this.createClaimItemCollectionEditor(claim3, (Context)context3, charges3);
        this.checkIterator(generator3.getHistory((Act)claim3, items3, this.insurer), visit3, visit2);
    }

    @Test
    public void testHistoryWithPriorClaimForInsurerWithDifferentInsuranceService() {
        this.insuranceFactory.updateInsurer(this.insurer).insuranceService(this.insuranceFactory.createInsuranceService()).build();
        Act visit1 = this.createVisit("2025-01-24 11:43:46", "2025-01-24 11:53:40");
        Act visit2 = this.createVisit("2025-03-05 15:55:08", "2025-03-05 16:13:59");
        FinancialAct claim1 = (FinancialAct)this.newClaimBuilder().date("2025-03-05 16:14:12").item().treatmentDates("2025-03-05 16:14:27", "2025-03-05 16:14:29").add().status("SETTLED").build();
        Charges charges1 = this.createCharges(claim1);
        LocalContext context1 = new LocalContext();
        ClaimAttachmentGenerator generator1 = this.createClaimAttachmentGenerator(charges1, (Context)context1);
        ClaimItemCollectionEditor items1 = this.createClaimItemCollectionEditor(claim1, (Context)context1, charges1);
        this.checkIterator(generator1.getHistory((Act)claim1, items1, this.insurer), visit2, visit1);
        Act visit3 = this.createVisit("2025-04-16 11:11:02", "2025-04-16 11:31:55");
        this.createVisit("2025-04-16 16:00:00", "2025-04-16 16:10:00");
        Party insurer2 = (Party)this.insuranceFactory.newInsurer().insuranceService(this.insuranceFactory.createInsuranceService()).build();
        Act policy2 = this.insuranceFactory.createPolicy(this.customer, this.patient, insurer2, "ABCDEFG");
        FinancialAct claim2 = (FinancialAct)this.newClaimBuilder().policy(policy2).date("2025-04-16 11:32:06").item().treatmentDates("2025-04-16 11:32:25", "2025-04-16 11:32:27").add().build();
        Charges charges2 = this.createCharges(claim2);
        LocalContext context2 = new LocalContext();
        ClaimAttachmentGenerator generator2 = this.createClaimAttachmentGenerator(charges2, (Context)context2);
        ClaimItemCollectionEditor items2 = this.createClaimItemCollectionEditor(claim2, (Context)context2, charges2);
        this.checkIterator(generator2.getHistory((Act)claim2, items2, insurer2), visit3, visit2, visit1);
    }

    @Test
    public void testNoHistory() {
        FinancialAct claim = (FinancialAct)this.newClaimBuilder().item().treatmentDates(new Date(), new Date()).add().build();
        Charges charges = this.createCharges(claim);
        LocalContext context = new LocalContext();
        ClaimAttachmentGenerator generator = this.createClaimAttachmentGenerator(charges, (Context)context);
        ClaimItemCollectionEditor items = this.createClaimItemCollectionEditor(claim, (Context)context, charges);
        AttachmentCollectionEditor attachments = items.getAttachments();
        MutableBoolean success = new MutableBoolean();
        Semaphore semaphore1 = new Semaphore(0);
        Assert.assertNull((Object)attachments.getHistory());
        generator.generate((Act)claim, this.insurer, items, attachments, this.location, status -> {
            semaphore1.release();
            success.setValue(status);
        });
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Generate Attachment", (String)"There is no patient history for the selected treatment dates. Continue?", (String)"no");
        Assert.assertFalse((boolean)success.booleanValue());
        DocumentAct history1 = attachments.getHistory();
        Assert.assertNotNull((Object)history1);
        Assert.assertNull((Object)history1.getDocument());
        Semaphore semaphore2 = new Semaphore(0);
        generator.generate((Act)claim, this.insurer, items, attachments, this.location, status -> {
            semaphore2.release();
            success.setValue(status);
        });
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Generate Attachment", (String)"There is no patient history for the selected treatment dates. Continue?", (String)"yes");
        this.processQueuedTasks(semaphore2);
        DocumentAct history2 = attachments.getHistory();
        Assert.assertNotNull((Object)history2);
        Assert.assertNotEquals((Object)history1, (Object)history2);
        Assert.assertNotNull((Object)history2.getDocument());
    }

    private TestClaimBuilder newClaimBuilder() {
        User clinician = this.userFactory.createClinician();
        return this.insuranceFactory.newClaim().policy(this.policy).claimHandler(clinician).clinician(clinician).location(this.location);
    }

    private Document checkGenerate(FinancialAct claim, FinancialAct invoiceItem, String name, String documentName, String error) {
        Document result = null;
        Charges charges = this.createCharges(claim);
        if (invoiceItem != null) {
            charges.add((Act)invoiceItem);
        }
        LocalContext context = new LocalContext();
        ClaimAttachmentGenerator generator = this.createClaimAttachmentGenerator(charges, (Context)context);
        ClaimItemCollectionEditor items = this.createClaimItemCollectionEditor(claim, (Context)context, charges);
        Semaphore semaphore = new Semaphore(0);
        MutableBoolean success = new MutableBoolean();
        AttachmentCollectionEditor attachments = items.getAttachments();
        generator.generate((Act)claim, this.insurer, items, attachments, this.location, status -> {
            success.setValue(status);
            semaphore.release();
        });
        this.processQueuedTasks(semaphore);
        List acts = attachments.getCurrentActs();
        if (error == null) {
            Assert.assertEquals((long)2L, (long)acts.size());
            Assert.assertTrue((boolean)success.booleanValue());
            this.checkAttachment("Patient History", "Medical Records.pdf", acts);
            result = this.checkAttachment(name, documentName, acts);
        } else {
            Assert.assertFalse((boolean)success.booleanValue());
            DocumentAct failed = this.getAttachment(name, acts);
            Assert.assertEquals((Object)Attachment.Status.ERROR.toString(), (Object)failed.getStatus());
            Assert.assertEquals((Object)error, (Object)this.getBean((IMObject)failed).getString("error"));
        }
        return result;
    }

    private void processQueuedTasks(Semaphore semaphore) {
        boolean done = false;
        for (int i = 0; i < 20; ++i) {
            ApplicationInstance.getActive().getUpdateManager().processClientUpdates();
            try {
                if (!semaphore.tryAcquire(1, 1L, TimeUnit.SECONDS)) continue;
                done = true;
                break;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertTrue((boolean)done);
    }

    private Document checkAttachment(String name, String fileName, List<Act> attachments) {
        DocumentAct attachment = this.getAttachment(name, attachments);
        Assert.assertEquals((Object)name, (Object)attachment.getName());
        Assert.assertEquals((Object)fileName, (Object)attachment.getFileName());
        Assert.assertEquals((Object)"application/pdf", (Object)attachment.getMimeType());
        Assert.assertEquals((Object)Attachment.Status.PENDING.toString(), (Object)attachment.getStatus());
        Document document = (Document)this.get(attachment.getDocument(), Document.class);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)fileName, (Object)document.getName());
        Assert.assertEquals((Object)"application/pdf", (Object)document.getMimeType());
        return document;
    }

    private void checkIterator(PatientHistoryIterator iterator, Act ... expected) {
        List actual = IterableUtils.toList((Iterable)iterator);
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], actual.get(i));
        }
    }

    private ClaimAttachmentGenerator createClaimAttachmentGenerator(Charges charges, Context context) {
        DummyConverter converter = new DummyConverter();
        return new ClaimAttachmentGenerator(this.customer, this.patient, charges, context, (DocumentConverter)converter);
    }

    private Charges createCharges(FinancialAct claim) {
        ClaimContext claimContext = new ClaimContext(claim, this.customer, this.patient, this.location, this.getArchetypeService(), this.insuranceRules, (InsuranceServices)Mockito.mock(InsuranceServices.class), (InsuranceFactory)Mockito.mock(InsuranceFactory.class));
        return new Charges(claimContext);
    }

    private ClaimItemCollectionEditor createClaimItemCollectionEditor(FinancialAct claim, Context context, Charges charges) {
        PropertySet set = new PropertySetBuilder((IMObject)claim).build();
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(context, new HelpContext("foo", null));
        AttachmentCollectionEditor attachments = new AttachmentCollectionEditor((CollectionProperty)set.get("attachments"), (Act)claim, (LayoutContext)layoutContext);
        attachments.getComponent();
        return new ClaimItemCollectionEditor((CollectionProperty)set.get("items"), (Act)claim, this.customer, this.patient, charges, attachments, (LayoutContext)layoutContext);
    }

    private Act createVisit(String startTime, String endTime) {
        return (Act)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().patient(this.patient)).startTime(startTime)).endTime(endTime)).status("COMPLETED")).build();
    }

    private DocumentAct getAttachment(String name, List<Act> attachments) {
        DocumentAct attachment = attachments.stream().filter(act -> name.equals(act.getName())).findFirst().orElse(null);
        Assert.assertNotNull((Object)attachment);
        return attachment;
    }

    private class DummyConverter
    implements DocumentConverter {
        private DummyConverter() {
        }

        public boolean canConvert(Document document, String mimeType) {
            return "application/pdf".equals(mimeType);
        }

        public boolean canConvert(String fileName, String sourceMimeType, String targetMimeType) {
            return "application/pdf".equals(targetMimeType);
        }

        public Document convert(Document document, String mimeType) {
            return ClaimAttachmentGeneratorTestCase.this.documentFactory.createPDF(FilenameUtils.getBaseName((String)document.getName()) + ".pdf");
        }

        public Document convert(Document document, String mimeType, boolean email) {
            return this.convert(document, mimeType);
        }

        public byte[] export(Document document, String mimeType, boolean email) {
            return new byte[0];
        }
    }
}

