/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.laboratory.LaboratoryTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.workspace.patient.history.PatientHistoryFilter;
import org.openvpms.web.workspace.patient.history.PatientHistoryIterator;
import org.openvpms.web.workspace.patient.history.ProductTypeSearch;
import org.openvpms.web.workspace.patient.history.TextSearch;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientHistoryIteratorTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestDocumentFactory documentFactory;
    private static final String[] SHORT_NAMES = new String[]{"act.patientClinicalProblem", "act.patientWeight", "act.patientClinicalNote", "act.patientMedication", "act.patientClinicalAddendum", "act.patientInvestigation", "act.patientInvestigationVersion", "act.patientDocumentAttachment", "act.patientDocumentAttachmentVersion", "act.patientDocumentForm", "act.patientDocumentLetter", "act.patientDocumentLetterVersion", "act.patientDocumentImage", "act.patientDocumentImageVersion", "act.customerAccountInvoiceItem"};

    @Test
    public void testIterator() {
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        Act weight = PatientTestHelper.createWeight((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician);
        Act problemNote = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:04:00"), (Party)patient, (User)clinician);
        Act problem = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2014-05-09 10:05:00"), (Party)patient, (User)clinician, (Act[])new Act[]{problemNote});
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{weight, problemNote, problem});
        List<Act> acts = Collections.singletonList(event);
        String[] none = new String[]{};
        this.check(acts, none, true, event);
        this.check(acts, none, false, event);
        String[] problemWeight = new String[]{"act.patientClinicalProblem", "act.patientWeight"};
        this.check(acts, problemWeight, true, event, weight, problem);
        this.check(acts, problemWeight, false, event, problem, weight);
        this.check(acts, SHORT_NAMES, true, event, weight, problem, problemNote);
        this.check(acts, SHORT_NAMES, false, event, problem, problemNote, weight);
    }

    @Test
    public void testUnlinkProblemItems() {
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        Act weight = PatientTestHelper.createWeight((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician);
        Act problemNote = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:04:00"), (Party)patient, (User)clinician);
        Act problem = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2014-05-09 10:05:00"), (Party)patient, (User)clinician, (Act[])new Act[]{problemNote});
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{weight, problem});
        List<Act> acts = Collections.singletonList(event);
        String[] none = new String[]{};
        this.check(acts, none, true, event);
        this.check(acts, none, false, event);
        String[] problemWeight = new String[]{"act.patientClinicalProblem", "act.patientWeight"};
        this.check(acts, problemWeight, true, event, weight, problem);
        this.check(acts, problemWeight, false, event, problem, weight);
        this.check(acts, SHORT_NAMES, true, event, weight, problem, problemNote);
        this.check(acts, SHORT_NAMES, false, event, problem, problemNote, weight);
    }

    @Test
    public void testInvoiceItems() {
        Party patient = TestHelper.createPatient();
        Product product = TestHelper.createProduct();
        User clinician = TestHelper.createClinician();
        Act weight = PatientTestHelper.createWeight((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician);
        FinancialAct charge1 = this.createChargeItem(TestHelper.getDatetime((String)"2014-05-09 10:01:00"), patient, product);
        Act medication1 = this.createMedication(TestHelper.getDatetime((String)"2014-05-09 10:01:00"), patient, charge1);
        FinancialAct charge2 = this.createChargeItem(TestHelper.getDatetime((String)"2014-05-09 10:02:00"), patient, product);
        Act problemNote = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:04:00"), (Party)patient, (User)clinician);
        Act problem = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2014-05-09 10:05:00"), (Party)patient, (User)clinician, (Act[])new Act[]{problemNote});
        FinancialAct charge3 = this.createChargeItem(TestHelper.getDatetime((String)"2014-05-09 10:06:00"), patient, product);
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{weight, problemNote, problem, medication1});
        IMObjectBean eventBean = this.getBean((IMObject)event);
        eventBean.addTarget("chargeItems", (IMObject)charge1, "event");
        eventBean.addTarget("chargeItems", (IMObject)charge2, "event");
        eventBean.addTarget("chargeItems", (IMObject)charge3, "event");
        this.save((IMObject[])new Act[]{event, charge1, charge2});
        List<Act> acts = Collections.singletonList(event);
        String[] withCharge = new String[]{"act.patientClinicalProblem", "act.patientWeight", "act.patientMedication", "act.customerAccountInvoiceItem", "act.patientClinicalNote"};
        String[] noCharge = new String[]{"act.patientClinicalProblem", "act.patientWeight", "act.patientMedication", "act.patientClinicalNote"};
        this.check(acts, withCharge, true, new Act[]{event, weight, medication1, charge2, problem, problemNote, charge3});
        this.check(acts, withCharge, false, new Act[]{event, charge3, problem, problemNote, charge2, medication1, weight});
        this.check(acts, noCharge, true, event, weight, medication1, problem, problemNote);
        this.check(acts, noCharge, false, event, problem, problemNote, medication1, weight);
    }

    @Test
    public void testProblemLinkedTo2Visits() {
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        Act note1a = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:04:00"), (Party)patient, (User)clinician);
        Act note1b = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:05:00"), (Party)patient, (User)clinician);
        Act note2 = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-14 13:15:00"), (Party)patient, (User)clinician);
        Act problem = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2014-05-09 10:05:00"), (Party)patient, (User)clinician, (Act[])new Act[]{note1a, note1b, note2});
        Act event1 = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{note1a, note1b, problem});
        Act event2 = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2014-05-14 13:10:00"), (Party)patient, (User)clinician, (Act[])new Act[]{note2, problem});
        List<Act> acts = Arrays.asList(event2, event1);
        this.check(acts, SHORT_NAMES, true, event2, problem, note2, event1, problem, note1a, note1b);
        this.check(acts, SHORT_NAMES, false, event2, problem, note2, event1, problem, note1b, note1a);
    }

    @Test
    public void testAddendumRecords() {
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        Act note = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2016-03-20 10:00:05"), (Party)patient, (User)clinician);
        FinancialAct charge = this.createChargeItem(TestHelper.getDatetime((String)"2016-03-20 10:01:00"), patient, TestHelper.createProduct());
        Act medication = this.createMedication(TestHelper.getDatetime((String)"2016-03-20 10:01:00"), patient, charge);
        Act addendum1 = PatientTestHelper.createAddendum((Date)TestHelper.getDatetime((String)"2016-03-27 11:00:00"), (Party)patient, (User)clinician);
        Act addendum2 = PatientTestHelper.createAddendum((Date)TestHelper.getDatetime((String)"2016-03-27 12:00:00"), (Party)patient, (User)clinician);
        PatientTestHelper.addAddendum((Act)note, (Act)addendum1);
        PatientTestHelper.addAddendum((Act)note, (Act)addendum2);
        Act addendum3 = PatientTestHelper.createAddendum((Date)TestHelper.getDatetime((String)"2016-03-27 13:00:00"), (Party)patient, (User)clinician);
        Act addendum4 = PatientTestHelper.createAddendum((Date)TestHelper.getDatetime((String)"2016-03-27 14:00:00"), (Party)patient, (User)clinician);
        PatientTestHelper.addAddendum((Act)medication, (Act)addendum3);
        PatientTestHelper.addAddendum((Act)medication, (Act)addendum4);
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2016-03-20 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{note, addendum1, addendum2, medication, addendum3, addendum4});
        List<Act> acts = Collections.singletonList(event);
        this.check(acts, SHORT_NAMES, true, event, note, addendum1, addendum2, medication, addendum3, addendum4);
        this.check(acts, SHORT_NAMES, false, event, medication, addendum3, addendum4, note, addendum1, addendum2);
    }

    @Test
    public void testAddendumLinkedToProblem() {
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        Act note = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2016-03-20 10:00:05"), (Party)patient, (User)clinician);
        FinancialAct charge = this.createChargeItem(TestHelper.getDatetime((String)"2016-03-20 10:01:00"), patient, TestHelper.createProduct());
        Act medication = this.createMedication(TestHelper.getDatetime((String)"2016-03-20 10:01:00"), patient, charge);
        Act addendum1 = PatientTestHelper.createAddendum((Date)TestHelper.getDatetime((String)"2016-03-27 11:00:00"), (Party)patient, (User)clinician);
        Act addendum2 = PatientTestHelper.createAddendum((Date)TestHelper.getDatetime((String)"2016-03-27 12:00:00"), (Party)patient, (User)clinician);
        PatientTestHelper.addAddendum((Act)note, (Act)addendum1);
        PatientTestHelper.addAddendum((Act)note, (Act)addendum2);
        Act addendum3 = PatientTestHelper.createAddendum((Date)TestHelper.getDatetime((String)"2016-03-27 13:00:00"), (Party)patient, (User)clinician);
        Act addendum4 = PatientTestHelper.createAddendum((Date)TestHelper.getDatetime((String)"2016-03-27 14:00:00"), (Party)patient, (User)clinician);
        PatientTestHelper.addAddendum((Act)medication, (Act)addendum3);
        PatientTestHelper.addAddendum((Act)medication, (Act)addendum4);
        Act problem = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2016-03-20 10:05:00"), (Party)patient, (User)clinician, (Act[])new Act[]{note, addendum1, addendum2, medication, addendum3, addendum4});
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2016-03-20 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{note, addendum1, addendum2, medication, addendum3, addendum4, problem});
        List<Act> acts1 = Collections.singletonList(event);
        this.check(acts1, SHORT_NAMES, true, event, problem, note, addendum1, addendum2, medication, addendum3, addendum4);
        this.check(acts1, SHORT_NAMES, false, event, problem, medication, addendum3, addendum4, note, addendum1, addendum2);
    }

    @Test
    public void testSearch() {
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        Entity investigationType = LaboratoryTestHelper.createInvestigationType();
        investigationType.setName("Pathology");
        Entity medicationProductType = ProductTestHelper.createProductType((String)"Medications");
        Entity investigationProductType = ProductTestHelper.createProductType((String)"Investigations");
        this.save((IMObject)investigationType);
        Product product1 = ProductTestHelper.createMedication((Entity)medicationProductType);
        product1.setName("drug");
        this.save((IMObject)product1);
        Entity batch = ProductTestHelper.createBatch((String)"1234567", (Product)product1, (Date)new Date(), (Party[])new Party[0]);
        Product product2 = ProductTestHelper.createMedication((Entity)investigationProductType);
        Act weight = PatientTestHelper.createWeight((Party)patient, (Date)TestHelper.getDatetime((String)"2018-02-09 10:00:00"), (BigDecimal)new BigDecimal("5.1"), (WeightUnits)WeightUnits.KILOGRAMS);
        Act note1 = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2018-02-09 10:02:00"), (Party)patient, (User)clinician, (String)"note 1");
        Act addendum1 = PatientTestHelper.createAddendum((Date)TestHelper.getDatetime((String)"2018-02-10 09:00:00"), (Party)patient, (User)clinician, (String)"note 1 addendum");
        PatientTestHelper.addAddendum((Act)note1, (Act)addendum1);
        Act note2 = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2018-02-09 10:03:00"), (Party)patient, (User)clinician, (String)"note 2 a");
        Act problemNote = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2018-02-09 10:04:00"), (Party)patient, (User)clinician, (String)"note 2 b");
        Act problem = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2018-02-09 10:05:00"), (Party)patient, (User)clinician, (String)"OFF_FOOD", (String)"HEART_MURMUR", (Act[])new Act[]{problemNote});
        DocumentAct investigation = PatientTestHelper.createInvestigation((Date)TestHelper.getDatetime((String)"2018-01-09 11:00:00"), (Party)patient, (User)clinician, (Party)TestHelper.createLocation(), (Entity)investigationType, (Product)product2);
        Act medication = PatientTestHelper.createMedication((Date)TestHelper.getDatetime((String)"2018-02-09 11:05:00"), (Party)patient, (Product)product1);
        IMObjectBean bean = this.getBean((IMObject)medication);
        bean.setValue("label", (Object)"Take once a day before meals");
        bean.setTarget("batch", (IMObject)batch);
        bean.save();
        Product product3 = ProductTestHelper.createMedication((Entity)medicationProductType);
        product3.setName("service");
        this.save((IMObject)product3);
        Entity documentTemplate = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").name("Vaccination Certificate")).build();
        DocumentAct form = PatientTestHelper.createDocumentForm((Date)TestHelper.getDatetime((String)"2018-01-09 12:00:00"), (Party)patient, (Product)product3, (Entity)documentTemplate);
        Product product4 = ProductTestHelper.createMedication((Entity)investigationProductType);
        product4.setName("product 4");
        this.save((IMObject)product4);
        DocumentAct letterVersion = PatientTestHelper.createDocumentLetterVersion((Date)TestHelper.getDatetime((String)"2018-01-09 12:05:00"));
        letterVersion.setFileName("Referral 1.pdf");
        DocumentAct letter = PatientTestHelper.createDocumentLetter((Date)TestHelper.getDatetime((String)"2018-01-09 12:04:00"), (Party)patient, (Product)product4, (Act[])new Act[]{letterVersion});
        letter.setFileName("Referral 2.pdf");
        this.save((IMObject[])new DocumentAct[]{letter, letterVersion});
        Entity serviceProductType = ProductTestHelper.createProductType();
        Product service = ProductTestHelper.createService();
        service.setName("Consult Fee");
        ProductTestHelper.addProductType((Product)service, (Entity)serviceProductType);
        FinancialAct charge = FinancialTestHelper.createInvoiceItem((Date)TestHelper.getDatetime((String)"2018-01-09 12:05:00"), (Party)patient, (User)clinician, (Product)service, (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.TEN, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
        this.save((IMObject)charge);
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2018-02-09 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{weight, note1, addendum1, note2, problemNote, problem, investigation, medication, form, letter, charge});
        List<Act> acts = Collections.singletonList(event);
        this.check(acts, "Weight", true, event, weight);
        this.check(acts, "Problem", true, event, problem);
        this.check(acts, "Visit", true, event);
        this.check(acts, "note 1", true, event, note1, addendum1);
        this.check(acts, "note 2", true, event, note2, problemNote);
        this.check(acts, "pathology", true, new Act[]{event, investigation});
        this.check(acts, Long.toString(investigation.getId()), true, new Act[]{event, investigation});
        this.check(acts, "drug", true, event, medication);
        this.check(acts, "once a day", true, event, medication);
        this.check(acts, "4567", true, event, medication);
        this.check(acts, "5.1", true, event, weight);
        this.check(acts, "certificate", true, new Act[]{event, form});
        this.check(acts, "service", true, new Act[]{event, form});
        this.check(acts, "referral", true, new Act[]{event, letter, letterVersion});
        this.check(acts, "product 4", true, new Act[]{event, letter});
        this.check(acts, "referral 2", true, new Act[]{event, letter});
        this.check(acts, "referral 1", true, new Act[]{event, letter, letterVersion});
        this.check(acts, "off food", true, event, problem);
        this.check(acts, "heart murmur", true, event, problem);
        this.check(acts, "fee", true, new Act[]{event, charge});
        this.check(acts, null, new Entity[]{medicationProductType}, true, new Act[]{event, form, medication});
        this.check(acts, null, new Entity[]{investigationProductType}, true, new Act[]{event, investigation, letter});
        this.check(acts, null, new Entity[]{serviceProductType}, true, new Act[]{event, charge});
        this.check(acts, null, new Entity[]{medicationProductType, serviceProductType}, true, new Act[]{event, form, charge, medication});
        this.check(acts, "fee", new Entity[]{medicationProductType, serviceProductType}, true, new Act[]{event, charge});
    }

    private void check(List<Act> events, String search, boolean sortAscending, Act ... expected) {
        this.check(events, SHORT_NAMES, search, null, sortAscending, expected);
    }

    private void check(List<Act> events, String search, Entity[] productTypes, boolean sortAscending, Act ... expected) {
        this.check(events, SHORT_NAMES, search, productTypes, sortAscending, expected);
    }

    private void check(List<Act> events, String[] shortNames, boolean sortAscending, Act ... expected) {
        this.check(events, shortNames, null, null, sortAscending, expected);
    }

    private void check(List<Act> events, String[] shortNames, String search, Entity[] productTypes, boolean sortAscending, Act[] expected) {
        int index = 0;
        List<Act> acts = this.getActs(events, shortNames, search, productTypes, sortAscending);
        if (acts.size() != expected.length) {
            Assert.fail((String)("Expected " + Arrays.asList(expected) + " but got " + acts));
        }
        for (Act act : acts) {
            Assert.assertEquals((Object)expected[index++], (Object)act);
        }
    }

    private Act createMedication(Date startTime, Party patient, FinancialAct chargeItem) {
        Act medication = PatientTestHelper.createMedication((Party)patient);
        medication.setActivityStartTime(startTime);
        if (chargeItem != null) {
            IMObjectBean bean = this.getBean((IMObject)chargeItem);
            bean.addTarget("dispensing", (IMObject)medication, "invoiceItem");
            this.save((IMObject[])new Act[]{chargeItem, medication});
        } else {
            this.save((IMObject)medication);
        }
        return medication;
    }

    private FinancialAct createChargeItem(Date startTime, Party patient, Product product) {
        FinancialAct item = FinancialTestHelper.createChargeItem((String)"act.customerAccountInvoiceItem", (Party)patient, (Product)product, (BigDecimal)BigDecimal.ONE);
        item.setActivityStartTime(startTime);
        this.save((IMObject)item);
        return item;
    }

    private List<Act> getActs(List<Act> events, String[] shortNames, String search, Entity[] productTypes, boolean sortAscending) {
        Object predicate = null;
        if (search != null) {
            predicate = new TextSearch(search, true, true, this.getArchetypeService());
        }
        if (productTypes != null) {
            HashSet<Reference> set = new HashSet<Reference>();
            for (Entity productType : productTypes) {
                set.add(productType.getObjectReference());
            }
            ProductTypeSearch productTypeSearch = new ProductTypeSearch(set, this.getArchetypeService());
            predicate = predicate == null ? productTypeSearch : predicate.and(productTypeSearch);
        }
        PatientHistoryFilter filter = new PatientHistoryFilter(shortNames, null, (Predicate)predicate, sortAscending, (ArchetypeService)this.getArchetypeService());
        PatientHistoryIterator iterator = new PatientHistoryIterator(events, filter);
        ArrayList<Act> result = new ArrayList<Act>();
        CollectionUtils.addAll(result, (Iterable)iterator);
        return result;
    }
}

