/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.history;

import java.util.Date;
import nextapp.echo2.app.Component;
import org.hibernate.validator.internal.util.Contracts;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.patient.history.PatientHistoryCRUDWindow;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientHistoryCRUDWindowTestCase
extends AbstractAppTest {
    @Autowired
    private TestPatientFactory patientFactory;

    @Test
    public void testCreateVisitForExistingVisit() {
        LocalContext context = new LocalContext();
        Party patient = this.patientFactory.createPatient();
        Act visit = (Act)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().patient(patient)).status("IN_PROGRESS")).startTime(TestHelper.getDate((String)"2022-03-18"))).build();
        context.setPatient(patient);
        PatientHistoryCRUDWindow window = new PatientHistoryCRUDWindow((Context)context, new HelpContext("foo", null));
        window.setEvent(visit);
        window.getComponent();
        window.create();
        EchoTestHelper.findSelectionDialogAndSelect((Object)"act.patientClinicalEvent");
        this.verifyCannotAddVisit(visit);
        visit.setStatus("COMPLETED");
        visit.setActivityEndTime(new Date());
        this.save((IMObject)visit);
        window.create();
        EchoTestHelper.findSelectionDialogAndSelect((Object)"act.patientClinicalEvent");
        EditDialog editDialog = EchoTestHelper.findEditDialog();
        Contracts.assertNotNull((Object)editDialog);
    }

    @Test
    public void testAddVisitAndNote() {
        LocalContext context = new LocalContext();
        Party patient = this.patientFactory.createPatient();
        Act visit = (Act)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().patient(patient)).status("IN_PROGRESS")).startTime(TestHelper.getDate((String)"2022-03-18"))).build();
        context.setPatient(patient);
        PatientHistoryCRUDWindow window = new PatientHistoryCRUDWindow((Context)context, new HelpContext("foo", null));
        window.getComponent();
        window.addVisitAndNote();
        this.verifyCannotAddVisit(visit);
        visit.setStatus("COMPLETED");
        visit.setActivityEndTime(new Date());
        this.save((IMObject)visit);
        window.addVisitAndNote();
        EditDialog editDialog = EchoTestHelper.findEditDialog();
        Contracts.assertNotNull((Object)editDialog);
    }

    private void verifyCannotAddVisit(Act visit) {
        InformationDialog dialog = (InformationDialog)EchoTestHelper.getWindowPane(InformationDialog.class);
        Assert.assertEquals((Object)"Cannot add Visit", (Object)dialog.getTitle());
        Assert.assertEquals((Object)("A new Visit cannot be added until the existing Visit dated " + DateFormatter.formatDate((Date)visit.getActivityStartTime(), (boolean)false) + " is Completed."), (Object)dialog.getMessage());
        EchoTestHelper.fireButton((Component)dialog, (String)"ok");
    }
}

