/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentRefundBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.object.BuiltObjects;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.paymentprocessor.exception.PaymentProcessorException;
import org.openvpms.paymentprocessor.service.PaymentRequirements;
import org.openvpms.paymentprocessor.service.PaymentRequirementsBuilder;
import org.openvpms.paymentprocessor.service.RefundRequirements;
import org.openvpms.paymentprocessor.service.RefundRequirementsBuilder;
import org.openvpms.paymentprocessor.service.TransactionRequirements;
import org.openvpms.paymentprocessor.transaction.Transaction;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.payment.PaymentProcessorPaymentItemEditor;
import org.openvpms.web.workspace.customer.payment.PaymentProcessorTestHelper;
import org.openvpms.web.workspace.customer.payment.TestPaymentProcessorPaymentItemEditor;
import org.openvpms.web.workspace.customer.payment.TestPaymentProcessorService;
import org.springframework.beans.factory.annotation.Autowired;

public class PaymentProcessorPaymentItemEditorTestCase
extends AbstractAppTest {
    @Autowired
    private CustomerAccountRules rules;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPaymentProcessorFactory paymentProcessorFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    private Party customer;
    private Party location;
    private Entity processor;
    private Entity till;

    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.location = this.practiceFactory.createLocation();
        this.processor = this.paymentProcessorFactory.createPaymentProcessor();
        this.till = this.practiceFactory.createTill();
    }

    @Test
    public void testValidationForPostedParentWithOutstandingTransaction() {
        this.checkValidationForPostedParentWithOutstandingTransaction((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkValidationForPostedParentWithOutstandingTransaction((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testCanDelete() {
        this.checkCanDelete("PENDING", false);
        this.checkCanDelete("IN_PROGRESS", false);
        this.checkCanDelete("SUBMITTED", false);
        this.checkCanDelete("COMPLETED", false);
        this.checkCanDelete("ERROR", true);
        this.checkCanDelete("CANCELLED", true);
    }

    @Test
    public void testRequiresTransaction() {
        this.checkRequiresTransaction("PENDING", true);
        this.checkRequiresTransaction("IN_PROGRESS", true);
        this.checkRequiresTransaction("SUBMITTED", true);
        this.checkRequiresTransaction("ERROR", true);
        this.checkRequiresTransaction("CANCELLED", true);
        this.checkRequiresTransaction("COMPLETED", false);
    }

    @Test
    public void testCanCancelTransaction() {
        this.checkCanCancel("PENDING", true);
        this.checkCanCancel("IN_PROGRESS", true);
        this.checkCanCancel("SUBMITTED", true);
        this.checkCanCancel("CANCELLED", false);
        this.checkCanCancel("COMPLETED", false);
        this.checkCanCancel("ERROR", false);
    }

    @Test
    public void testValidationFailsIfPaymentProcessorDoesntSupportUnmatchedRefunds() {
        TestRefundBuilder builder = this.newRefund();
        FinancialAct parent = (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)builder.paymentProcessor(this.processor, 10)).add(new FinancialAct[0])).build();
        FinancialAct item = (FinancialAct)builder.getBuiltObjects().getObject("act.customerAccountRefundPP", FinancialAct.class);
        TestPaymentProcessorService service = new TestPaymentProcessorService(false);
        TestPaymentProcessorPaymentItemEditor editor = this.createEditor(item, parent, service);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)(this.processor.getName() + " doesn't support unmatched refunds"));
    }

    @Test
    public void testMandatoryDescriptionAndEmail() {
        TestPaymentBuilder paymentBuilder = this.newPayment();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)paymentBuilder.paymentProcessor(this.processor, 10)).build();
        FinancialAct paymentItem = (FinancialAct)paymentBuilder.getBuiltObjects().getObject("act.customerAccountPaymentPP", FinancialAct.class);
        this.checkMandatoryDescriptionAndEmail(payment, paymentItem);
        TestRefundBuilder refundBuilder = this.newRefund();
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)refundBuilder.paymentProcessor(this.processor, 10)).build();
        FinancialAct refundItem = (FinancialAct)refundBuilder.getBuiltObjects().getObject("act.customerAccountRefundPP", FinancialAct.class);
        this.checkMandatoryDescriptionAndEmail(refund, refundItem);
    }

    @Test
    public void testPerformTransaction() {
        this.checkPerformTransaction((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkPerformTransaction((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testPerformTransactionAfterError() {
        this.checkPerformTransactionAfterError((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkPerformTransactionAfterError((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testPerformTransactionAfterCancellation() {
        this.checkPerformTransactionAfterCancellation((TestPaymentRefundBuilder<?>)this.newPayment());
        this.checkPerformTransactionAfterCancellation((TestPaymentRefundBuilder<?>)this.newRefund());
    }

    @Test
    public void testPerformTransactionWithPaymentProcessorServiceUnavailable() {
        TestPaymentBuilder builder = this.newPayment();
        FinancialAct parent = (FinancialAct)((TestPaymentBuilder)builder.paymentProcessor(this.processor, 10)).build();
        FinancialAct item = (FinancialAct)builder.getBuiltObjects().getObject("act.customerAccountPaymentPP", FinancialAct.class);
        TestPaymentProcessorPaymentItemEditor editor = this.createEditor(item, parent);
        editor.setPaymentProcessor(this.processor);
        editor.setService(null);
        MutableBoolean completed = new MutableBoolean(false);
        try {
            editor.performTransaction(() -> ((MutableBoolean)completed).setTrue());
            Assert.fail((String)"Expected performTransaction() to fail");
        }
        catch (PaymentProcessorException expected) {
            Assert.assertEquals((Object)("PAYMENT-0001: Payment Processor unavailable for " + this.processor.getName()), (Object)expected.getMessage());
        }
        Assert.assertFalse((boolean)completed.booleanValue());
    }

    @Test
    public void testPaymentProcessorRefundMustCorrespondToPayment() {
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)this.newPayment().status("POSTED")).paymentProcessor(processor, 10)).build();
        FinancialAct refund = this.rules.createInProgressReversal(payment, null);
        IMObjectBean bean = this.getBean((IMObject)refund);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        FinancialAct refundPP = (FinancialAct)items.get(0);
        refundPP.setTotal(BigDecimal.ONE);
        refund.setTotal(BigDecimal.ONE);
        this.save((IMObject[])new FinancialAct[]{refundPP, refund});
        TestPaymentProcessorPaymentItemEditor editor = this.createEditor(refundPP, refund);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"The total must be $10.00");
    }

    private void checkReadOnly(PaymentProcessorPaymentItemEditor editor, String status) {
        boolean readOnly = "IN_PROGRESS".equals(status) || "SUBMITTED".equals(status) || "COMPLETED".equals(status);
        this.checkReadOnly(editor, readOnly);
    }

    private void checkReadOnly(PaymentProcessorPaymentItemEditor editor, boolean readOnly) {
        Assert.assertEquals((Object)readOnly, (Object)editor.getProperty("description").isReadOnly());
        Assert.assertEquals((Object)readOnly, (Object)editor.getProperty("email").isReadOnly());
        Assert.assertEquals((Object)readOnly, (Object)editor.getProperty("amount").isReadOnly());
    }

    private void checkValidationForPostedParentWithOutstandingTransaction(TestPaymentRefundBuilder<?> builder) {
        String[] incompleteStatuses;
        for (String status : incompleteStatuses = new String[]{"PENDING", "IN_PROGRESS", "SUBMITTED", "ERROR", "CANCELLED"}) {
            FinancialAct parent = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(this.processor).amount(10)).addTransaction(status).add().build();
            BuiltObjects objects = builder.getBuiltObjects();
            String itemArchetype = parent.isA("act.customerAccountPayment") ? "act.customerAccountPaymentPP" : "act.customerAccountRefundPP";
            FinancialAct item = (FinancialAct)objects.getObject(itemArchetype, FinancialAct.class);
            TestPaymentProcessorPaymentItemEditor editor = this.createEditor(item, parent);
            parent.setStatus("POSTED");
            EditorTestHelper.assertInvalid((Modifiable)editor, (String)("Cannot finalise " + this.getDisplayName((IMObject)parent) + ". It has an outstanding " + this.processor.getName() + " transaction."));
            parent.setStatus("IN_PROGRESS");
            EditorTestHelper.assertValid((Modifiable)editor);
        }
    }

    private void performTransaction(PaymentProcessorPaymentItemEditor editor, boolean expectSubmitDialog, boolean success) {
        MutableInt called = new MutableInt(0);
        editor.performTransaction(() -> ((MutableInt)called).increment());
        if (expectSubmitDialog) {
            Assert.assertEquals((long)0L, (long)called.intValue());
            String email = editor.getProperty("email").getString();
            PaymentProcessorTestHelper.checkPaymentProcessorStatusDialog((FinancialAct)editor.getParent(), this.processor, email);
        }
        if (success) {
            Assert.assertEquals((long)1L, (long)called.intValue());
        } else {
            Assert.assertEquals((long)0L, (long)called.intValue());
        }
    }

    private FinancialAct checkTransactions(FinancialAct item, Transaction.Status ... statuses) {
        List transactions = this.getBean((IMObject)item).getTargets("transactions", FinancialAct.class, Policies.orderBySequence());
        Assert.assertEquals((long)statuses.length, (long)transactions.size());
        for (int i = 0; i < statuses.length; ++i) {
            Assert.assertEquals((Object)statuses[i], (Object)Transaction.Status.valueOf((String)((FinancialAct)transactions.get(i)).getStatus()));
        }
        return !transactions.isEmpty() ? (FinancialAct)transactions.get(transactions.size() - 1) : null;
    }

    private void checkCanDelete(String status, boolean canDelete) {
        this.checkCanDelete((TestPaymentRefundBuilder<?>)this.newPayment(), status, canDelete);
        this.checkCanDelete((TestPaymentRefundBuilder<?>)this.newRefund(), status, canDelete);
    }

    private void checkCanDelete(TestPaymentRefundBuilder<?> builder, String status, boolean canDelete) {
        FinancialAct parent = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(this.processor).amount(10)).addTransaction(status).add().build();
        String itemArchetype = parent.isA("act.customerAccountPayment") ? "act.customerAccountPaymentPP" : "act.customerAccountRefundPP";
        BuiltObjects objects = builder.getBuiltObjects();
        FinancialAct item = (FinancialAct)objects.getObject(itemArchetype, FinancialAct.class);
        TestPaymentProcessorPaymentItemEditor editor = this.createEditor(item, parent);
        Assert.assertEquals((Object)canDelete, (Object)editor.canDelete());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, status);
    }

    private void checkRequiresTransaction(String status, boolean required) {
        this.checkRequiresTransaction((TestPaymentRefundBuilder<?>)this.newPayment(), status, required);
        this.checkRequiresTransaction((TestPaymentRefundBuilder<?>)this.newRefund(), status, required);
    }

    private void checkRequiresTransaction(TestPaymentRefundBuilder<?> builder, String status, boolean required) {
        FinancialAct parent = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(this.processor).amount(10)).addTransaction(status).add().build();
        String itemArchetype = parent.isA("act.customerAccountPayment") ? "act.customerAccountPaymentPP" : "act.customerAccountRefundPP";
        BuiltObjects objects = builder.getBuiltObjects();
        FinancialAct item = (FinancialAct)objects.getObject(itemArchetype, FinancialAct.class);
        TestPaymentProcessorPaymentItemEditor editor = this.createEditor(item, parent);
        Assert.assertEquals((Object)required, (Object)editor.requiresTransaction());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, status);
    }

    private void checkCanCancel(String status, boolean canCancel) {
        this.checkCanCancel((TestPaymentRefundBuilder<?>)this.newPayment(), status, canCancel);
        this.checkCanCancel((TestPaymentRefundBuilder<?>)this.newRefund(), status, canCancel);
    }

    private void checkCanCancel(TestPaymentRefundBuilder<?> builder, String status, boolean canCancel) {
        FinancialAct parent = (FinancialAct)((TestPaymentProcessorItemBuilder)builder.paymentProcessor().processor(this.processor).amount(10)).addTransaction(status).add().build();
        String itemArchetype = parent.isA("act.customerAccountPayment") ? "act.customerAccountPaymentPP" : "act.customerAccountRefundPP";
        BuiltObjects objects = builder.getBuiltObjects();
        FinancialAct item = (FinancialAct)objects.getObject(itemArchetype, FinancialAct.class);
        TestPaymentProcessorPaymentItemEditor editor = this.createEditor(item, parent);
        Assert.assertEquals((Object)canCancel, (Object)editor.canCancelTransaction());
    }

    private void checkMandatoryDescriptionAndEmail(FinancialAct parent, FinancialAct item) {
        PaymentRequirements paymentRequirements = ((PaymentRequirementsBuilder)((PaymentRequirementsBuilder)PaymentRequirements.newRequirements().description(TransactionRequirements.Field.MANDATORY)).email(TransactionRequirements.Field.MANDATORY)).build();
        RefundRequirements refundRequirements = ((RefundRequirementsBuilder)((RefundRequirementsBuilder)RefundRequirements.newRequirements().description(TransactionRequirements.Field.MANDATORY)).email(TransactionRequirements.Field.MANDATORY)).supportsUnmatchedRefunds(true).build();
        TestPaymentProcessorService service = new TestPaymentProcessorService(paymentRequirements, refundRequirements);
        TestPaymentProcessorPaymentItemEditor editor = this.createEditor(item, parent, service);
        service.setSubmitCallback(transaction -> transaction.setStatus(Transaction.Status.SUBMITTED));
        editor.setService(service);
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, false);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Description is required");
        editor.getProperty("description").setValue((Object)"Deposit for surgery");
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Email is required");
        editor.getProperty("email").setValue((Object)"foo@bar.com");
        EditorTestHelper.assertValid((Modifiable)editor);
        Assert.assertTrue((boolean)editor.requiresTransaction());
        this.performTransaction(editor, true, true);
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
    }

    private void checkPerformTransaction(TestPaymentRefundBuilder<?> builder) {
        FinancialAct parent = (FinancialAct)builder.paymentProcessor(this.processor, 10).build();
        String itemArchetype = parent.isA("act.customerAccountPayment") ? "act.customerAccountPaymentPP" : "act.customerAccountRefundPP";
        FinancialAct item = (FinancialAct)builder.getBuiltObjects().getObject(itemArchetype, FinancialAct.class);
        TestPaymentProcessorPaymentItemEditor editor = this.createEditor(item, parent);
        TestPaymentProcessorService service = new TestPaymentProcessorService();
        service.setSubmitCallback(transaction -> transaction.setStatus(Transaction.Status.SUBMITTED));
        editor.setService(service);
        editor.setPaymentProcessor(this.processor);
        EditorTestHelper.assertValid((Modifiable)editor);
        Assert.assertFalse((boolean)editor.isComplete());
        Assert.assertTrue((boolean)editor.requiresTransaction());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, false);
        this.performTransaction(editor, true, true);
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
        FinancialAct transaction2 = this.checkTransactions(item, Transaction.Status.SUBMITTED);
        Assert.assertNotNull((Object)transaction2);
        transaction2.setStatus("COMPLETED");
        this.save((IMObject)transaction2);
        Assert.assertFalse((boolean)editor.isComplete());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
        Assert.assertTrue((boolean)editor.requiresTransaction());
        this.performTransaction(editor, false, true);
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
        Assert.assertTrue((boolean)editor.isComplete());
        Assert.assertFalse((boolean)editor.requiresTransaction());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
        this.checkTransactions(item, Transaction.Status.COMPLETED);
    }

    private void checkPerformTransactionAfterError(TestPaymentRefundBuilder<?> builder) {
        FinancialAct parent = (FinancialAct)((TestPaymentRefundBuilder)builder.status("IN_PROGRESS")).paymentProcessor(this.processor, 10).build();
        String itemArchetype = parent.isA("act.customerAccountPayment") ? "act.customerAccountPaymentPP" : "act.customerAccountRefundPP";
        FinancialAct item = (FinancialAct)builder.getBuiltObjects().getObject(itemArchetype, FinancialAct.class);
        TestPaymentProcessorPaymentItemEditor editor = this.createEditor(item, parent);
        editor.setPaymentProcessor(this.processor);
        TestPaymentProcessorService service = new TestPaymentProcessorService();
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, false);
        service.setSubmitCallback(transaction -> transaction.setStatus(Transaction.Status.ERROR));
        editor.setService(service);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)editor.requiresTransaction());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, false);
        this.performTransaction(editor, false, false);
        this.checkTransactions(item, Transaction.Status.ERROR);
        Assert.assertTrue((boolean)editor.requiresTransaction());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, false);
        service.setSubmitCallback(transaction -> transaction.setStatus(Transaction.Status.SUBMITTED));
        this.performTransaction(editor, true, true);
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
        this.checkTransactions(item, Transaction.Status.ERROR, Transaction.Status.SUBMITTED);
        Assert.assertTrue((boolean)editor.requiresTransaction());
        service.setCheckCallback(transaction -> {
            transaction.setStatus(Transaction.Status.COMPLETED);
            return true;
        });
        this.performTransaction(editor, false, true);
        Assert.assertFalse((boolean)editor.requiresTransaction());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
        this.checkTransactions(item, Transaction.Status.ERROR, Transaction.Status.COMPLETED);
    }

    private void checkPerformTransactionAfterCancellation(TestPaymentRefundBuilder<?> builder) {
        FinancialAct parent = (FinancialAct)((TestPaymentRefundBuilder)builder.status("IN_PROGRESS")).paymentProcessor(this.processor, 10).build();
        String itemArchetype = parent.isA("act.customerAccountPayment") ? "act.customerAccountPaymentPP" : "act.customerAccountRefundPP";
        FinancialAct item = (FinancialAct)builder.getBuiltObjects().getObject(itemArchetype, FinancialAct.class);
        TestPaymentProcessorPaymentItemEditor editor = this.createEditor(item, parent);
        editor.setPaymentProcessor(this.processor);
        TestPaymentProcessorService service = new TestPaymentProcessorService();
        editor.setService(service);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertFalse((boolean)editor.isComplete());
        Assert.assertTrue((boolean)editor.requiresTransaction());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, false);
        this.performTransaction(editor, true, true);
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
        FinancialAct transaction1 = this.checkTransactions(item, Transaction.Status.SUBMITTED);
        Assert.assertNotNull((Object)transaction1);
        transaction1.setStatus("CANCELLED");
        this.save((IMObject)transaction1);
        Assert.assertFalse((boolean)editor.isComplete());
        Assert.assertTrue((boolean)editor.requiresTransaction());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
        this.performTransaction(editor, true, true);
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
        FinancialAct transaction2 = this.checkTransactions(item, Transaction.Status.CANCELLED, Transaction.Status.SUBMITTED);
        Assert.assertNotNull((Object)transaction2);
        Assert.assertFalse((boolean)editor.isComplete());
        Assert.assertTrue((boolean)editor.requiresTransaction());
        transaction2.setStatus("COMPLETED");
        this.save((IMObject)transaction2);
        Assert.assertFalse((boolean)editor.isComplete());
        Assert.assertTrue((boolean)editor.requiresTransaction());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
        this.performTransaction(editor, false, true);
        Assert.assertTrue((boolean)editor.isComplete());
        Assert.assertFalse((boolean)editor.requiresTransaction());
        this.checkReadOnly((PaymentProcessorPaymentItemEditor)editor, true);
        this.checkTransactions(item, Transaction.Status.CANCELLED, Transaction.Status.COMPLETED);
    }

    private TestPaymentProcessorPaymentItemEditor createEditor(FinancialAct item, FinancialAct payment) {
        return this.createEditor(item, payment, new TestPaymentProcessorService());
    }

    private TestPaymentProcessorPaymentItemEditor createEditor(FinancialAct item, FinancialAct payment, TestPaymentProcessorService service) {
        LocalContext localContext = new LocalContext();
        Party location = (Party)this.getBean((IMObject)payment).getTarget("location", Party.class);
        localContext.setLocation(location);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)localContext, new HelpContext("foo", null));
        context.setEdit(true);
        TestPaymentProcessorPaymentItemEditor editor = new TestPaymentProcessorPaymentItemEditor(item, payment, (LayoutContext)context);
        editor.setService(service);
        editor.getComponent();
        return editor;
    }

    private TestPaymentBuilder newPayment() {
        return (TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customer)).location(this.location)).till(this.till)).status("IN_PROGRESS");
    }

    private TestRefundBuilder newRefund() {
        return (TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(this.customer)).location(this.location)).till(this.till)).status("IN_PROGRESS");
    }
}

