/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.i18n.Messages;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.paymentprocessor.exception.PaymentProcessorException;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.PaymentDeletionHandler;
import org.openvpms.web.workspace.customer.payment.TestPaymentProcessorPaymentItemEditor;
import org.openvpms.web.workspace.customer.payment.TestPaymentProcessorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class PaymentDeletionHandlerTestCase
extends AbstractAppTest {
    private IMObjectEditorFactory editorFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private CustomerAccountRules rules;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPaymentProcessorFactory paymentProcessorFactory;
    private Party customer;
    private Entity till;
    private Party location;

    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.till = this.practiceFactory.createTill();
        this.location = this.practiceFactory.createLocation();
        this.editorFactory = new TestIMObjectEditorFactory(this.getArchetypeService(), new TestPaymentProcessorService());
    }

    @Test
    public void testDelete() {
        FinancialAct payment = this.createPayment("IN_PROGRESS");
        FinancialAct refund = this.createRefund("IN_PROGRESS");
        this.verifyDeleteSucceeds(payment, 0);
        this.verifyDeleteSucceeds(refund, 0);
    }

    @Test
    public void testDeletePosted() {
        FinancialAct payment = this.createPayment("POSTED");
        FinancialAct refund = this.createRefund("POSTED");
        this.verifyDeleteFails(payment, 0, "Cannot delete Payment. It has been finalised.");
        this.verifyDeleteFails(refund, 0, "Cannot delete Refund. It has been finalised.");
    }

    @Test
    public void testDeleteWithOutstandingEFT() {
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct payment1 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("IN_PROGRESS", terminal)).add()).build();
        this.verifyDeleteFails(payment1, 3, "Cannot delete Payment. It has an outstanding EFTPOS transaction.");
        FinancialAct payment3 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).eft().amount(BigDecimal.TEN)).addTransaction("PENDING", terminal)).add()).build();
        this.verifyDeleteFails(payment3, 1, "Cannot delete Payment. It has an outstanding EFTPOS transaction.");
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("IN_PROGRESS", terminal)).add()).build();
        this.verifyDeleteFails(refund, 3, "Cannot delete Refund. It has an outstanding EFTPOS transaction.");
    }

    @Test
    public void testDeleteWithApprovedEFT() {
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("APPROVED", terminal)).add()).build();
        this.verifyDeleteFails(payment, 3, "Cannot delete Payment. It has an approved EFTPOS transaction.");
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("APPROVED", terminal)).add()).build();
        this.verifyDeleteFails(refund, 3, "Cannot delete Refund. It has an approved EFTPOS transaction.");
    }

    @Test
    public void testDeleteWithNoTerminalEFT() {
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("NO_TERMINAL", terminal)).add()).build();
        this.verifyDeleteSucceeds(payment, 3);
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("NO_TERMINAL", terminal)).add()).build();
        this.verifyDeleteSucceeds(refund, 3);
    }

    @Test
    public void testDeleteWithPendingOrInProgressPaymentProcessorItem() {
        Entity paymentProcessor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment1 = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor(paymentProcessor, 10)).build();
        this.verifyDeleteSucceeds(payment1, 0);
        FinancialAct refund1 = (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor(paymentProcessor, 10)).build();
        this.verifyDeleteSucceeds(refund1, 0);
        FinancialAct payment2 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("PENDING")).add()).build();
        this.verifyDeleteSucceeds(payment2, 1);
        FinancialAct refund2 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("PENDING")).add()).build();
        this.verifyDeleteSucceeds(refund2, 1);
        FinancialAct payment3 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("IN_PROGRESS")).add()).build();
        this.verifyDeleteSucceeds(payment3, 1);
        FinancialAct refund3 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("IN_PROGRESS")).add()).build();
        this.verifyDeleteSucceeds(refund3, 1);
        FinancialAct payment4 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("SUBMITTED")).add()).build();
        this.verifyDeleteSucceeds(payment4, 1);
        FinancialAct refund4 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("SUBMITTED")).add()).build();
        this.verifyDeleteSucceeds(refund4, 1);
        FinancialAct payment5 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("ERROR")).addTransaction("PENDING")).add()).build();
        this.verifyDeleteSucceeds(payment5, 2);
        FinancialAct refund5 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("ERROR")).addTransaction("PENDING")).add()).build();
        this.verifyDeleteSucceeds(refund5, 2);
        FinancialAct payment6 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("ERROR")).addTransaction("IN_PROGRESS")).add()).build();
        this.verifyDeleteSucceeds(payment6, 2);
        FinancialAct refund6 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("ERROR")).addTransaction("IN_PROGRESS")).add()).build();
        this.verifyDeleteSucceeds(refund6, 2);
        FinancialAct payment7 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("CANCELLED")).addTransaction("PENDING")).add()).build();
        this.verifyDeleteSucceeds(payment7, 2);
        FinancialAct refund7 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("CANCELLED")).addTransaction("PENDING")).add()).build();
        this.verifyDeleteSucceeds(refund7, 2);
        FinancialAct payment8 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("CANCELLED")).addTransaction("SUBMITTED")).add()).build();
        this.verifyDeleteSucceeds(payment8, 2);
        FinancialAct refund8 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("CANCELLED")).addTransaction("SUBMITTED")).add()).build();
        this.verifyDeleteSucceeds(refund8, 2);
    }

    @Test
    public void testDeleteWithErrorOrCancelledPaymentProcessorTransaction() {
        Entity paymentProcessor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment1 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("ERROR")).add()).build();
        this.verifyDeleteSucceeds(payment1, 1);
        FinancialAct refund1 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("ERROR")).add()).build();
        this.verifyDeleteSucceeds(refund1, 1);
        FinancialAct payment2 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("CANCELLED")).add()).build();
        this.verifyDeleteSucceeds(payment2, 1);
        FinancialAct refund2 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("CANCELLED")).add()).build();
        this.verifyDeleteSucceeds(refund2, 1);
        FinancialAct payment3 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("ERROR")).addTransaction("CANCELLED")).add()).build();
        this.verifyDeleteSucceeds(payment3, 2);
        FinancialAct refund3 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("ERROR")).addTransaction("CANCELLED")).add()).build();
        this.verifyDeleteSucceeds(refund3, 2);
        FinancialAct payment4 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("CANCELLED")).addTransaction("ERROR")).add()).build();
        this.verifyDeleteSucceeds(payment4, 2);
        FinancialAct refund4 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("CANCELLED")).addTransaction("ERROR")).add()).build();
        this.verifyDeleteSucceeds(refund4, 2);
    }

    @Test
    public void testDeleteWithCompletedPaymentProcessorTransaction() {
        Entity paymentProcessor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment1 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("COMPLETED")).add()).build();
        this.verifyDeleteFails(payment1, 1, "Cannot delete Payment. It has a completed Payment Processor transaction.");
        FinancialAct refund1 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("COMPLETED")).add()).build();
        this.verifyDeleteFails(refund1, 1, "Cannot delete Refund. It has a completed Payment Processor transaction.");
        FinancialAct payment2 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("ERROR")).addTransaction("COMPLETED")).add()).build();
        this.verifyDeleteFails(payment2, 2, "Cannot delete Payment. It has a completed Payment Processor transaction.");
        FinancialAct refund2 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("ERROR")).addTransaction("COMPLETED")).add()).build();
        this.verifyDeleteFails(refund2, 2, "Cannot delete Refund. It has a completed Payment Processor transaction.");
        FinancialAct payment3 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("CANCELLED")).addTransaction("COMPLETED")).add()).build();
        this.verifyDeleteFails(payment3, 2, "Cannot delete Payment. It has a completed Payment Processor transaction.");
        FinancialAct refund3 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("CANCELLED")).addTransaction("COMPLETED")).add()).build();
        this.verifyDeleteFails(refund3, 2, "Cannot delete Refund. It has a completed Payment Processor transaction.");
    }

    @Test
    public void testFailureDuringCancellationOfPaymentProcessorItem() {
        Entity paymentProcessor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment1 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("PENDING")).add()).build();
        this.checkFailureDuringCancellationOfPaymentProcessorItem(payment1);
        FinancialAct refund1 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().status("IN_PROGRESS")).till(this.till)).customer(this.customer)).location(this.location)).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("PENDING")).add()).build();
        this.checkFailureDuringCancellationOfPaymentProcessorItem(refund1);
    }

    @Test
    public void testEditor() {
        FinancialAct payment = this.createPayment("IN_PROGRESS");
        FinancialAct refund = this.createRefund("IN_PROGRESS");
        TestPaymentDeletionHandler handler1 = this.createDeletionHandler(payment);
        handler1.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertTrue((boolean)(handler1.getEditor() instanceof CustomerPaymentEditor));
        TestPaymentDeletionHandler handler2 = this.createDeletionHandler(refund);
        handler2.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertTrue((boolean)(handler2.getEditor() instanceof CustomerPaymentEditor));
    }

    @Test
    public void testDeactivate() {
        FinancialAct payment = this.createPayment("IN_PROGRESS");
        FinancialAct refund = this.createPayment("IN_PROGRESS");
        this.checkDeactivate(payment);
        this.checkDeactivate(refund);
    }

    @Test
    public void testFactory() {
        FinancialAct payment = this.createPayment("POSTED");
        FinancialAct refund = this.createRefund("POSTED");
        IMObjectDeletionHandlerFactory factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        Assert.assertNotNull((Object)this.applicationContext);
        factory.setApplicationContext(this.applicationContext);
        Assert.assertTrue((boolean)(factory.create((IMObject)payment) instanceof PaymentDeletionHandler));
        Assert.assertTrue((boolean)(factory.create((IMObject)refund) instanceof PaymentDeletionHandler));
    }

    private TestPaymentDeletionHandler createDeletionHandler(FinancialAct act) {
        return this.createDeletionHandler(act, this.editorFactory);
    }

    private TestPaymentDeletionHandler createDeletionHandler(FinancialAct act, IMObjectEditorFactory factory) {
        return new TestPaymentDeletionHandler(act, factory, ServiceHelper.getTransactionManager(), ServiceHelper.getArchetypeService(), this.rules);
    }

    private void verifyDeleteSucceeds(FinancialAct act, int expectedTransactions) {
        List<FinancialAct> transactions = this.getTransactions(act);
        Assert.assertEquals((long)expectedTransactions, (long)transactions.size());
        TestPaymentDeletionHandler handler = this.createDeletionHandler(act);
        Deletable deletable = handler.getDeletable();
        Assert.assertTrue((String)deletable.getReason(), (boolean)deletable.canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertTrue((boolean)(handler.getEditor() instanceof CustomerPaymentEditor));
        Assert.assertNull((Object)this.get((IMObject)act));
        for (FinancialAct transaction : transactions) {
            if (transaction.isA(new String[]{"act.EFTPOSPayment", "act.EFTPOSRefund"}) && "NO_TERMINAL".equals(transaction.getStatus())) {
                Assert.assertNull((Object)this.get((IMObject)transaction));
                continue;
            }
            FinancialAct reloaded = (FinancialAct)this.get((IMObject)transaction);
            Assert.assertNotNull((Object)reloaded);
            String status = transaction.getStatus();
            if (transaction.isA(new String[]{"act.EFTPOSPayment", "act.EFTPOSRefund"})) {
                Assert.assertEquals((Object)status, (Object)reloaded.getStatus());
                continue;
            }
            if (transaction.isA(new String[]{"act.paymentProcessorPayment", "act.paymentProcessorRefund"})) {
                if (status.equals("PENDING") || status.equals("IN_PROGRESS") || status.equals("SUBMITTED")) {
                    Assert.assertEquals((Object)"CANCELLED", (Object)reloaded.getStatus());
                    continue;
                }
                Assert.assertEquals((Object)status, (Object)reloaded.getStatus());
                continue;
            }
            Assert.fail((String)("Unsupported transaction type: " + transaction.getArchetype()));
        }
    }

    private void verifyDeleteFails(FinancialAct act, int expectedTransactions, String reason) {
        List<FinancialAct> transactions = this.getTransactions(act);
        Assert.assertEquals((long)expectedTransactions, (long)transactions.size());
        TestPaymentDeletionHandler handler = this.createDeletionHandler(act);
        Deletable deletable = handler.getDeletable();
        Assert.assertFalse((boolean)deletable.canDelete());
        Assert.assertEquals((Object)reason, (Object)deletable.getReason());
        try {
            handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)this.get((IMObject)act));
        for (FinancialAct transaction : transactions) {
            Assert.assertNotNull((Object)this.get((IMObject)transaction));
        }
    }

    private void checkFailureDuringCancellationOfPaymentProcessorItem(FinancialAct act) {
        List items = this.getBean((IMObject)act).getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        List<FinancialAct> transactions = this.getTransactions(act);
        Assert.assertEquals((long)1L, (long)transactions.size());
        TestPaymentProcessorService paymentProcessorService = new TestPaymentProcessorService();
        paymentProcessorService.setCancelCallback(transaction -> {
            throw new PaymentProcessorException(Messages.create((String)"Error during cancellation"));
        });
        TestIMObjectEditorFactory factory = new TestIMObjectEditorFactory(this.getArchetypeService(), paymentProcessorService);
        TestPaymentDeletionHandler handler = this.createDeletionHandler(act, factory);
        Deletable deletable = handler.getDeletable();
        Assert.assertTrue((String)deletable.getReason(), (boolean)deletable.canDelete());
        try {
            handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
            Assert.fail((String)"Expected delete to fail");
        }
        catch (PaymentProcessorException exception) {
            Assert.assertEquals((Object)"Error during cancellation", (Object)exception.getMessage());
        }
        Assert.assertNotNull((Object)this.get((IMObject)act));
        for (FinancialAct item : items) {
            Assert.assertNotNull((Object)this.get((IMObject)item));
        }
        for (FinancialAct transaction2 : transactions) {
            Assert.assertNotNull((Object)this.get((IMObject)transaction2));
        }
    }

    private void checkDeactivate(FinancialAct act) {
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)act.getStatus());
        TestPaymentDeletionHandler handler1 = this.createDeletionHandler(act);
        Assert.assertFalse((boolean)handler1.canDeactivate());
        try {
            handler1.deactivate();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        act.setStatus("POSTED");
        TestPaymentDeletionHandler handler2 = this.createDeletionHandler(act);
        Assert.assertFalse((boolean)handler2.canDeactivate());
        try {
            handler2.deactivate();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private FinancialAct createPayment(String status) {
        return (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customer)).till(this.till)).status(status)).eft().amount(100)).add()).build();
    }

    private FinancialAct createRefund(String status) {
        return (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(this.customer)).till(this.till)).status(status)).eft().amount(100)).add()).build();
    }

    private List<FinancialAct> getTransactions(FinancialAct act) {
        Policy itemsWithTransactions = Policies.all((Predicate)Predicates.targetIsA((String[])new String[]{"act.customerAccountPaymentEFT", "act.customerAccountRefundEFT", "act.customerAccountPaymentPP", "act.customerAccountRefundPP"}));
        List items = this.getBean((IMObject)act).getTargets("items", FinancialAct.class, itemsWithTransactions);
        return items.stream().map(item -> this.getBean((IMObject)item).getTargets("transactions", FinancialAct.class)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static class TestIMObjectEditorFactory
    extends IMObjectEditorFactory {
        private final TestPaymentProcessorService paymentProcessorService;

        public TestIMObjectEditorFactory(IArchetypeService service, TestPaymentProcessorService paymentProcessorService) {
            super(service);
            this.paymentProcessorService = paymentProcessorService;
        }

        public IMObjectEditor create(IMObject object, IMObject parent, LayoutContext context) {
            if (object.isA(new String[]{"act.customerAccountPaymentPP", "act.customerAccountRefundPP"})) {
                TestPaymentProcessorPaymentItemEditor editor = new TestPaymentProcessorPaymentItemEditor((FinancialAct)object, (FinancialAct)parent, context);
                editor.setService(this.paymentProcessorService);
                return editor;
            }
            return super.create(object, parent, context);
        }
    }

    private static class TestPaymentDeletionHandler
    extends PaymentDeletionHandler {
        private IMObjectEditor editor;

        public TestPaymentDeletionHandler(FinancialAct object, IMObjectEditorFactory factory, PlatformTransactionManager transactionManager, IArchetypeRuleService service, CustomerAccountRules rules) {
            super(object, factory, transactionManager, service, rules);
        }

        public IMObjectEditor getEditor() {
            return this.editor;
        }

        protected IMObjectEditor createEditor(FinancialAct object, Context context, HelpContext help) {
            this.editor = super.createEditor((IMObject)object, context, help);
            return this.editor;
        }
    }
}

