/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.order;

import java.math.BigDecimal;
import java.util.Date;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.util.IMObjectHelper;

public class PharmacyTestHelper {
    public static FinancialAct createOrder(Party customer, Party patient, Product product, BigDecimal quantity, FinancialAct invoiceItem) {
        return PharmacyTestHelper.createOrder(new Date(), customer, patient, product, quantity, invoiceItem);
    }

    public static FinancialAct createOrder(Date startTime, Party customer, Party patient, Product product, BigDecimal quantity, FinancialAct invoiceItem) {
        return PharmacyTestHelper.createOrderReturn(true, startTime, customer, patient, product, quantity, invoiceItem);
    }

    public static FinancialAct createReturn(Party customer, Party patient, Product product, BigDecimal quantity, FinancialAct invoiceItem) {
        return PharmacyTestHelper.createReturn(new Date(), customer, patient, product, quantity, invoiceItem);
    }

    public static FinancialAct createReturn(Date startTime, Party customer, Party patient, Product product, BigDecimal quantity, FinancialAct invoiceItem) {
        return PharmacyTestHelper.createOrderReturn(false, startTime, customer, patient, product, quantity, invoiceItem);
    }

    private static FinancialAct createOrderReturn(boolean isOrder, Date startTime, Party customer, Party patient, Product product, BigDecimal quantity, FinancialAct invoiceItem) {
        FinancialAct act = (FinancialAct)TestHelper.create((String)(isOrder ? "act.customerOrderPharmacy" : "act.customerReturnPharmacy"));
        FinancialAct item = (FinancialAct)TestHelper.create((String)(isOrder ? "act.customerOrderItemPharmacy" : "act.customerReturnItemPharmacy"));
        act.setActivityStartTime(startTime);
        item.setActivityStartTime(startTime);
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)act);
        if (customer != null) {
            bean.setTarget("customer", (IMObject)customer);
        }
        bean.addTarget("items", (IMObject)item);
        IMObjectBean itemBean = IMObjectHelper.getBean((IMObject)item);
        if (patient != null) {
            itemBean.setTarget("patient", (IMObject)patient);
        }
        if (product != null) {
            itemBean.setTarget("product", (IMObject)product);
        }
        if (invoiceItem != null) {
            itemBean.setValue("sourceInvoiceItem", (Object)invoiceItem.getObjectReference());
        }
        item.setQuantity(quantity);
        TestHelper.save((IMObject[])new IMObject[]{act, item});
        return act;
    }
}

