/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.order;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.order.OrderRules;
import org.openvpms.archetype.rules.laboratory.LaboratoryTestHelper;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.charge.AbstractCustomerChargeActEditorTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeTestHelper;
import org.openvpms.web.workspace.customer.charge.TestChargeEditor;
import org.openvpms.web.workspace.customer.order.InvestigationOrderInvoicer;

public class InvestigationOrderInvoicerTestCase
extends AbstractCustomerChargeActEditorTest {
    private IArchetypeService service;
    private OrderRules rules;
    private Context context;
    private Party customer;
    private Party patient;
    private Product product;
    private Entity investigationType;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.service = (IArchetypeService)this.applicationContext.getBean("archetypeService", IArchetypeService.class);
        Party location = TestHelper.createLocation();
        Entity laboratory = CustomerChargeTestHelper.createHL7Laboratory(location);
        this.product = this.productFactory.createMedication();
        this.investigationType = LaboratoryTestHelper.createInvestigationType((Entity)laboratory, (Entity[])new Entity[0]);
        Entity test = LaboratoryTestHelper.createHL7Test((Entity)this.investigationType);
        ProductTestHelper.addTest((Product)this.product, (Entity)test);
        User clinician = TestHelper.createClinician();
        this.customer = TestHelper.createCustomer();
        this.patient = TestHelper.createPatient((Party)this.customer);
        this.context = new LocalContext();
        this.context.setPractice(this.getPractice());
        this.context.setLocation(location);
        User author = TestHelper.createUser();
        this.context.setUser(author);
        this.context.setClinician(clinician);
        this.context.setPatient(this.patient);
        this.context.setCustomer(this.customer);
        this.rules = new OrderRules(this.getArchetypeService());
    }

    @Test
    public void testReturnToInProgressInvoice() {
        TestChargeEditor editor = this.createInvoice(this.product);
        editor.setStatus("IN_PROGRESS");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct invoiceItem = this.getInvoiceItem(editor);
        Act investigation = this.getInvestigation(editor);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)investigation.getStatus());
        FinancialAct order = this.createReturn(this.customer, this.patient, this.product, this.investigationType, invoiceItem, investigation);
        TestInvestigationOrderInvoicer charger = new TestInvestigationOrderInvoicer(order, null, this.rules, this.service);
        Assert.assertTrue((boolean)charger.canCharge((CustomerChargeActEditor)editor));
        charger.charge((CustomerChargeActEditor)editor);
        editor.setStatus("POSTED");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertEquals((Object)"CANCELLED", (Object)investigation.getStatus());
    }

    @Test
    public void testReturnToPostedInvoice() {
        TestChargeEditor editor1 = this.createInvoice(this.product);
        FinancialAct invoiceItem = this.getInvoiceItem(editor1);
        Act investigation = this.getInvestigation(editor1);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)investigation.getStatus());
        editor1.setStatus("POSTED");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        FinancialAct order = this.createReturn(this.customer, this.patient, this.product, this.investigationType, invoiceItem, investigation);
        TestInvestigationOrderInvoicer charger1 = new TestInvestigationOrderInvoicer(order, null, this.rules, this.service);
        Assert.assertFalse((boolean)charger1.canCharge((CustomerChargeActEditor)editor1));
    }

    @Test
    public void testMissingCustomer() {
        String expected = "Customer is required";
        FinancialAct act = this.createReturn(null, this.patient, this.product, this.investigationType, null, null);
        this.checkRequired(act, expected);
    }

    @Test
    public void testMissingPatient() {
        String expected = "Patient is required";
        FinancialAct act = this.createReturn(this.customer, null, this.product, this.investigationType, null, null);
        this.checkRequired(act, expected);
    }

    @Test
    public void testMissingInvestigationType() {
        String expected = "Investigation is required";
        FinancialAct act = this.createReturn(this.customer, this.patient, this.product, null, null, null);
        this.checkRequired(act, expected);
    }

    private void checkRequired(FinancialAct act, String expected) {
        InvestigationOrderInvoicer charger = new InvestigationOrderInvoicer(act, this.context.getClinician(), this.rules, this.service);
        Assert.assertFalse((boolean)charger.isValid());
        DefaultValidator validator = new DefaultValidator();
        Assert.assertFalse((boolean)charger.validate((Validator)validator));
        Assert.assertEquals((long)1L, (long)validator.getInvalid().size());
        Modifiable modifiable = (Modifiable)validator.getInvalid().iterator().next();
        List errors = validator.getErrors(modifiable);
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((Object)expected, (Object)((ValidatorError)errors.get(0)).getMessage());
    }

    private TestChargeEditor createInvoice(Product product) {
        TestChargeEditor editor = this.createEditor();
        this.addItem((CustomerChargeActEditor)editor, this.patient, product, BigDecimal.ONE, editor.getQueue());
        return editor;
    }

    private TestChargeEditor createEditor() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layoutContext.setEdit(true);
        TestChargeEditor editor = new TestChargeEditor(charge, (LayoutContext)layoutContext, false);
        editor.getComponent();
        return editor;
    }

    private FinancialAct createReturn(Party customer, Party patient, Product product, Entity investigationType, FinancialAct invoiceItem, Act investigation) {
        FinancialAct act = (FinancialAct)this.create("act.customerReturnInvestigation", FinancialAct.class);
        FinancialAct item = (FinancialAct)this.create("act.customerReturnItemInvestigation", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        if (customer != null) {
            bean.setTarget("customer", (IMObject)customer);
        }
        ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
        item.addActRelationship(relationship);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        if (patient != null) {
            itemBean.setTarget("patient", (IMObject)patient);
        }
        if (product != null) {
            itemBean.setTarget("product", (IMObject)product);
        }
        if (investigationType != null) {
            itemBean.setTarget("investigationType", (IMObject)investigationType);
        }
        if (invoiceItem != null) {
            itemBean.setValue("sourceInvoiceItem", (Object)invoiceItem.getObjectReference());
        }
        if (investigation != null) {
            itemBean.setValue("sourceInvestigation", (Object)investigation.getObjectReference());
        }
        this.save((IMObject[])new FinancialAct[]{act, item});
        return act;
    }

    private FinancialAct getInvoiceItem(TestChargeEditor editor) {
        List acts = editor.getItems().getCurrentActs();
        Assert.assertEquals((long)1L, (long)acts.size());
        return (FinancialAct)acts.get(0);
    }

    private Act getInvestigation(TestChargeEditor editor) {
        List acts = editor.getItems().getCurrentActs();
        Assert.assertEquals((long)1L, (long)acts.size());
        CustomerChargeActItemEditor itemEditor = editor.getItems().getEditor((IMObject)acts.get(0));
        List investigations = itemEditor.getInvestigations();
        Assert.assertEquals((long)1L, (long)investigations.size());
        return (Act)investigations.get(0);
    }

    private static class TestInvestigationOrderInvoicer
    extends InvestigationOrderInvoicer {
        public TestInvestigationOrderInvoicer(FinancialAct act, User clinician, OrderRules rules, IArchetypeService service) {
            super(act, clinician, rules, service);
        }

        protected CustomerChargeActEditor createChargeEditor(FinancialAct charge, LayoutContext context) {
            return new TestChargeEditor(charge, context, true);
        }
    }
}

