/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.button.AbstractButton;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.IMTable;
import org.openvpms.web.component.prefs.UserPreferences;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.ChargeItemRelationshipCollectionViewer;
import org.openvpms.web.workspace.customer.charge.ChargeItemTableModel;
import org.springframework.beans.factory.annotation.Autowired;

public class ChargeItemRelationshipCollectionViewerTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testSortByProductType() {
        Entity typeA = this.productFactory.createProductType("A");
        Entity typeB = this.productFactory.createProductType("B");
        Product product1 = this.productFactory.createMedication(typeB);
        Product product2 = this.productFactory.createMedication();
        Product product3 = this.productFactory.createMedication(typeA);
        TestCounterSaleBuilder builder = this.accountFactory.newCounterSale();
        FinancialAct charge = (FinancialAct)((TestCounterSaleBuilder)((TestCounterSaleItemBuilder)((TestCounterSaleBuilder)((TestCounterSaleItemBuilder)((TestCounterSaleBuilder)((TestCounterSaleItemBuilder)((TestCounterSaleBuilder)builder.customer(this.customerFactory.createCustomer())).item().product(product1)).add()).item().product(product2)).add()).item().product(product3)).add()).build();
        FinancialAct item1 = builder.getItem(product1);
        FinancialAct item2 = builder.getItem(product2);
        FinancialAct item3 = builder.getItem(product3);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        UserPreferences preferences = (UserPreferences)layoutContext.getPreferences();
        preferences.initialise(this.userFactory.createUser());
        preferences.setPreference("entity.preferenceGroupCharge", "showProductType", (Object)true);
        IMObjectProperty items = new IMObjectProperty((IMObject)charge, this.getBean((IMObject)charge).getNode("items"));
        ChargeItemRelationshipCollectionViewer viewer = new ChargeItemRelationshipCollectionViewer((CollectionProperty)items, (Act)charge, (LayoutContext)layoutContext);
        viewer.getComponent();
        Button sort = EchoTestHelper.getSortButton((IMTable)viewer.getTable().getTable(), (String)"Product Type");
        ChargeItemTableModel model = viewer.getModel();
        EchoTestHelper.fireButton((AbstractButton)sort);
        List objects1 = model.getObjects();
        Assert.assertEquals((long)3L, (long)objects1.size());
        Assert.assertEquals((Object)item2, objects1.get(0));
        Assert.assertEquals((Object)item3, objects1.get(1));
        Assert.assertEquals((Object)item1, objects1.get(2));
        EchoTestHelper.fireButton((AbstractButton)sort);
        List objects2 = model.getObjects();
        Assert.assertEquals((long)3L, (long)objects2.size());
        Assert.assertEquals((Object)item1, objects2.get(0));
        Assert.assertEquals((Object)item3, objects2.get(1));
        Assert.assertEquals((Object)item2, objects2.get(2));
    }
}

